/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.juneau.Context;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.svl.Var;

public class VarResolverContext
extends Context {
    public static final String SVL_vars = "Svl.vars.set";
    public static final String SVL_vars_add = "Svl.vars.set.add";
    public static final String SVL_vars_remove = "Svl.vars.set.remove";
    public static final String SVL_context = "Svl.context.map";
    public static final String SVL_context_put = "Svl.context.map.put";
    private final Map<String, Var> stringVars;
    private final Map<String, Object> contextObjects;

    public VarResolverContext(ContextFactory cf) {
        super(cf);
        ContextFactory.PropertyMap pm = cf.getPropertyMap("Svl");
        Class[] varClasses = pm.get(SVL_vars, Class[].class, new Class[0]);
        ConcurrentSkipListMap<String, Var> m = new ConcurrentSkipListMap<String, Var>();
        for (Class c : varClasses) {
            if (!ClassUtils.isParentClass(Var.class, c)) {
                throw new RuntimeException("Invalid variable class.  Must extend from Var");
            }
            try {
                Var v = (Var)c.newInstance();
                m.put(v.getName(), v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.stringVars = Collections.unmodifiableMap(m);
        this.contextObjects = Collections.unmodifiableMap(pm.getMap(SVL_context, String.class, Object.class, Collections.emptyMap()));
    }

    protected Map<String, Var> getVars() {
        return this.stringVars;
    }

    protected Object getContextObject(String name) {
        return this.contextObjects.get(name);
    }
}

