/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.CoreApi;
import org.apache.juneau.svl.VarResolverContext;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.svl.vars.EnvVariablesVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;

public class VarResolver
extends CoreApi {
    public static final VarResolver DEFAULT = new VarResolver().addVars(SystemPropertiesVar.class, EnvVariablesVar.class).lock();

    public VarResolver addVars(Class<?> ... vars) {
        this.checkLock();
        ContextFactory cf = this.getContextFactory();
        for (Class<?> v : vars) {
            try {
                v.newInstance();
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(MessageFormat.format("Cannot instantiate variable class {0}.  Must have a public no-arg constructor.", v.getName()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cf.addToProperty("Svl.vars.set", v);
        }
        return this;
    }

    public VarResolver setContextObject(String name, Object object) {
        this.getContextFactory().putToProperty("Svl.context.map", name, object);
        return this;
    }

    public VarResolverSession createSession() {
        return new VarResolverSession(this.getContext(VarResolverContext.class), null);
    }

    public VarResolverSession createSession(Map<String, Object> sessionObjects) {
        return new VarResolverSession(this.getContext(VarResolverContext.class), sessionObjects);
    }

    public String resolve(String s) {
        return this.createSession(null).resolve(s);
    }

    public void resolveTo(String s, Writer w) throws IOException {
        this.createSession(null).resolveTo(s, w);
    }

    @Override
    public VarResolver lock() {
        super.lock();
        return this;
    }

    @Override
    public VarResolver clone() {
        try {
            return (VarResolver)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

