/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;

@Produces(value="text/xml+soap", contentType="text/xml")
public final class SoapXmlSerializer
extends XmlSerializer {
    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        XmlSerializerSession s = (XmlSerializerSession)session;
        XmlWriter w = s.getWriter();
        w.append("<?xml").attr("version", "1.0").attr("encoding", "UTF-8").appendln("?>");
        w.oTag("soap", "Envelope").attr("xmlns", "soap", (Object)s.getProperties().getString("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope")).appendln(">");
        w.sTag(1, "soap", "Body").nl();
        super.serialize(s, o);
        w.eTag(1, "soap", "Body").nl();
        w.eTag("soap", "Envelope").nl();
    }

    @Override
    public ObjectMap getResponseHeaders(ObjectMap properties) {
        return super.getResponseHeaders(properties).append("SOAPAction", properties.getString("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope"));
    }
}

