/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.response;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.juneau.Writable;
import org.apache.juneau.server.ReaderResource;
import org.apache.juneau.server.ResponseHandler;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestResponse;

public final class WritableHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        if (output instanceof Writable) {
            if (output instanceof ReaderResource) {
                ReaderResource r = (ReaderResource)output;
                String mediaType = r.getMediaType();
                if (mediaType != null) {
                    res.setContentType(mediaType);
                }
                for (Map.Entry<String, String> h : r.getHeaders().entrySet()) {
                    res.setHeader(h.getKey(), h.getValue());
                }
            }
            PrintWriter w = res.getNegotiatedWriter();
            ((Writable)output).writeTo(w);
            ((Writer)w).flush();
            ((Writer)w).close();
            return true;
        }
        return false;
    }
}

