/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.juneau.Streamable;
import org.apache.juneau.server.ResponseHandler;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestResponse;
import org.apache.juneau.server.StreamResource;

public final class StreamableHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        if (output instanceof Streamable) {
            if (output instanceof StreamResource) {
                StreamResource r = (StreamResource)output;
                String mediaType = r.getMediaType();
                if (mediaType != null) {
                    res.setContentType(mediaType);
                }
                for (Map.Entry<String, String> h : r.getHeaders().entrySet()) {
                    res.setHeader(h.getKey(), h.getValue());
                }
            }
            ServletOutputStream os = res.getOutputStream();
            ((Streamable)output).streamTo((OutputStream)os);
            os.flush();
            os.close();
            return true;
        }
        return false;
    }
}

