/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.remoteable;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.dto.Link;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestServletDefault;
import org.apache.juneau.server.annotation.Path;
import org.apache.juneau.server.annotation.RestMethod;

public abstract class RemoteableServlet
extends RestServletDefault {
    private Map<String, Class<?>> classNameMap = new ConcurrentHashMap();

    protected abstract Map<Class<?>, Object> getServiceMap() throws Exception;

    @RestMethod(name="GET", path="/")
    public List<Link> getInterfaces(RestRequest req) throws Exception {
        LinkedList<Link> l = new LinkedList<Link>();
        boolean useAll = !this.useOnlyAnnotated();
        for (Class<?> c : this.getServiceMap().keySet()) {
            if (!useAll && !this.getBeanContext().getClassMeta(c).isRemoteable()) continue;
            l.add(new Link(c.getName(), "{0}/{1}", req.getRequestURI(), c.getName()));
        }
        return l;
    }

    @RestMethod(name="GET", path="/{javaInterface}")
    public Collection<String> listMethods(@Path String javaInterface) throws Exception {
        return this.getMethods(javaInterface).keySet();
    }

    @RestMethod(name="POST", path="/{javaInterface}/{javaMethod}")
    public Object invoke(RestRequest req, @Path String javaInterface, @Path String javaMethod) throws Exception {
        ReaderParser p = req.getReaderParser();
        if (p == null) {
            throw new RestException(415, "Could not find parser for media type ''{0}''", req.getMediaType());
        }
        Class<?> c = this.getInterfaceClass(javaInterface);
        Object service = this.getServiceMap().get(c);
        if (service == null) {
            throw new RestException(404, "Service not found", new Object[0]);
        }
        Method m = this.getMethods(javaInterface).get(javaMethod);
        if (m == null) {
            throw new RestException(404, "Method not found", new Object[0]);
        }
        ClassMeta<?>[] argTypes = p.getBeanContext().getClassMetas(m.getParameterTypes());
        Object[] params = p.parseArgs(req.getReader(), argTypes);
        return m.invoke(service, params);
    }

    private boolean useOnlyAnnotated() {
        return this.getProperties().getBoolean("RemoteableService.includeOnlyRemoteableMethods", false);
    }

    private Map<String, Method> getMethods(String javaInterface) throws Exception {
        Class<?> c = this.getInterfaceClass(javaInterface);
        ClassMeta<?> cm = this.getBeanContext().getClassMeta(c);
        return this.useOnlyAnnotated() ? cm.getRemoteableMethods() : cm.getPublicMethods();
    }

    private Class<?> getInterfaceClass(String javaInterface) throws Exception {
        Class<?> c = this.classNameMap.get(javaInterface);
        if (c == null) {
            for (Class<?> c2 : this.getServiceMap().keySet()) {
                if (!c2.getName().equals(javaInterface)) continue;
                this.classNameMap.put(javaInterface, c2);
                return c2;
            }
            throw new RestException(404, "Interface class not found", new Object[0]);
        }
        return c;
    }
}

