/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.server.annotation.Property;
import org.apache.juneau.server.annotation.RestMethod;
import org.apache.juneau.server.jaxrs.JuneauProvider;

public class BaseProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private SerializerGroup serializers = new SerializerGroup();
    private ParserGroup parsers = new ParserGroup();
    private ObjectMap properties = new ObjectMap();

    protected BaseProvider() {
        try {
            this.properties = new ObjectMap();
            JuneauProvider jp = this.getClass().getAnnotation(JuneauProvider.class);
            this.serializers.append(jp.serializers());
            this.parsers.append(jp.parsers());
            for (Property p : jp.properties()) {
                this.properties.put(p.name(), p.value());
            }
            this.serializers.addBeanFilters(jp.beanFilters());
            this.parsers.addBeanFilters(jp.beanFilters());
            this.serializers.addPojoSwaps(jp.pojoSwaps());
            this.parsers.addPojoSwaps(jp.pojoSwaps());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectMap getMethodProperties(Annotation[] a) {
        ObjectMap m = new ObjectMap().setInner(this.properties);
        for (Annotation aa : a) {
            if (!(aa instanceof RestMethod)) continue;
            for (Property p : ((RestMethod)aa).properties()) {
                m.put(p.name(), p.value());
            }
        }
        return m;
    }

    public long getSize(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.serializers.findMatch(mediaType.toString()) != null;
    }

    public void writeTo(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream out) throws IOException, WebApplicationException {
        try {
            String mt = this.serializers.findMatch(mediaType.toString());
            if (mt == null) {
                throw new WebApplicationException(406);
            }
            Serializer s = this.serializers.getSerializer(mt);
            ObjectMap mp = this.getMethodProperties(a);
            mp.append("mediaType", mediaType.toString());
            if (s.isWriterSerializer()) {
                WriterSerializer s2 = (WriterSerializer)s;
                OutputStreamWriter w = new OutputStreamWriter(out, IOUtils.UTF8);
                SerializerSession session = s.createSession(w, mp, null);
                s2.serialize(session, o);
                w.flush();
                w.close();
            } else {
                OutputStreamSerializer s2 = (OutputStreamSerializer)s;
                SerializerSession session = s.createSession(s2, mp, null);
                s2.serialize(session, o);
                out.flush();
                out.close();
            }
        }
        catch (SerializeException e) {
            throw new IOException(e);
        }
    }

    public boolean isReadable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.parsers.findMatch(mediaType.toString()) != null;
    }

    public Object readFrom(Class<Object> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        try {
            String mt = this.parsers.findMatch(mediaType.toString());
            if (mt == null) {
                throw new WebApplicationException(415);
            }
            Parser p = this.parsers.getParser(mt);
            BeanContext bc = p.getBeanContext();
            ClassMeta cm = bc.getClassMeta(gType);
            ObjectMap mp = this.getMethodProperties(a);
            mp.put("mediaType", mediaType.toString());
            if (p.isReaderParser()) {
                ReaderParser p2 = (ReaderParser)p;
                InputStreamReader r = new InputStreamReader(in, IOUtils.UTF8);
                ParserSession session = p2.createSession(r, mp, null, null);
                return p2.parse(session, cm);
            }
            InputStreamParser p2 = (InputStreamParser)p;
            ParserSession session = p2.createSession(in, mp, null, null);
            return p2.parse(session, cm);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }
}

