/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server.converters;

import java.util.Collection;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.server.RestConverter;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.utils.PojoQuery;

public final class Queryable
implements RestConverter {
    public Object convert(RestRequest req, Object o, ClassMeta cm) {
        if (o == null) {
            return null;
        }
        try {
            if (req.hasAnyQueryParameters("q", "v", "s", "g", "i", "p", "l")) {
                BeanContext bc = req.getBeanContext();
                if (cm.getPojoSwap() != null) {
                    o = cm.getPojoSwap().swap(o, bc);
                }
                PojoQuery f = new PojoQuery(o, bc);
                if (o instanceof Collection || o.getClass().isArray()) {
                    ObjectMap query = req.getQueryParameter("q", ObjectMap.class);
                    ClassMeta<List> cm1 = bc.getCollectionClassMeta(List.class, String.class);
                    List view = req.getQueryParameter("v", cm1);
                    ClassMeta<List> cm2 = bc.getCollectionClassMeta(List.class, String.class);
                    List sort = req.getQueryParameter("s", cm2);
                    boolean ignoreCase = req.getQueryParameter("i", Boolean.class, Boolean.valueOf(false));
                    int pos = req.getQueryParameter("p", Integer.class, Integer.valueOf(0));
                    int limit = req.getQueryParameter("l", Integer.class, Integer.valueOf(0));
                    o = f.filterCollection(query, view, sort, pos, limit, ignoreCase);
                } else {
                    ClassMeta<List> cm2 = bc.getCollectionClassMeta(List.class, String.class);
                    List view = req.getQueryParameter("v", cm2);
                    o = f.filterMap(view);
                }
            }
            return o;
        }
        catch (SerializeException e) {
            throw new RestException(400, (Throwable)e);
        }
        catch (ParseException e) {
            throw new RestException(400, (Throwable)e);
        }
    }
}

