/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.server.RestUtils;

public final class UrlPathPattern
implements Comparable<UrlPathPattern> {
    private Pattern pattern;
    String patternString;
    private boolean isOnlyDotAll;
    private boolean isDotAll;
    String[] vars = new String[0];

    public UrlPathPattern(String patternString) {
        this.patternString = patternString;
        if (!StringUtils.startsWith(patternString, '/')) {
            patternString = '/' + patternString;
        }
        if (patternString.equals("/*")) {
            this.isOnlyDotAll = true;
            return;
        }
        if (patternString.endsWith("/*")) {
            this.isDotAll = true;
        }
        Pattern p = Pattern.compile("\\{([^\\}]+)\\}");
        LinkedList<String> vl = new LinkedList<String>();
        Matcher m = p.matcher(patternString);
        while (m.find()) {
            vl.add(m.group(1));
        }
        this.vars = vl.toArray(new String[vl.size()]);
        patternString = patternString.replaceAll("\\{[^\\}]+\\}", "([^\\/]+)");
        patternString = patternString.replaceAll("\\/\\*$", "((?:)|(?:\\/.*))");
        this.pattern = Pattern.compile(patternString);
    }

    protected String[] match(String path) {
        if (this.isOnlyDotAll) {
            if (path != null) {
                path = path.substring(1);
            }
            return new String[]{path};
        }
        if (path == null) {
            return this.patternString.equals("/") ? new String[]{} : null;
        }
        Matcher m = this.pattern.matcher(path);
        if (!m.matches()) {
            return null;
        }
        int len = m.groupCount();
        String[] v = new String[len];
        for (int i = 0; i < len; ++i) {
            v[i] = this.isDotAll && i == len - 1 ? (m.group(i + 1).isEmpty() ? null : m.group(i + 1).substring(1)) : RestUtils.decode(m.group(i + 1));
        }
        return v;
    }

    @Override
    public int compareTo(UrlPathPattern o) {
        int c;
        String s1 = this.patternString.replaceAll("\\{[^\\}]+\\}", ".").replaceAll("\\w+", "X").replaceAll("\\.", "W");
        String s2 = o.patternString.replaceAll("\\{[^\\}]+\\}", ".").replaceAll("\\w+", "X").replaceAll("\\.", "W");
        if (s1.isEmpty()) {
            s1 = "+";
        }
        if (s2.isEmpty()) {
            s2 = "+";
        }
        if (!s1.endsWith("/*")) {
            s1 = s1 + "/W";
        }
        if (!s2.endsWith("/*")) {
            s2 = s2 + "/W";
        }
        if ((c = s2.compareTo(s1)) == 0) {
            return o.toRegEx().compareTo(this.toRegEx());
        }
        return c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UrlPathPattern)) {
            return false;
        }
        return this.compareTo((UrlPathPattern)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.patternString;
    }

    public String toRegEx() {
        return this.isOnlyDotAll ? "*" : this.pattern.pattern();
    }
}

