/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Streamable;
import org.apache.juneau.internal.IOUtils;

public class StreamResource
implements Streamable {
    private byte[] contents;
    private String mediaType;
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    public StreamResource(byte[] contents, String mediaType) {
        this.contents = contents;
        this.mediaType = mediaType;
    }

    public StreamResource(InputStream contents, String mediaType) throws IOException {
        this.contents = IOUtils.readBytes(contents, 1024);
        this.mediaType = mediaType;
    }

    public StreamResource setHeader(String name, Object value) {
        this.headers.put(name, value == null ? "" : value.toString());
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void streamTo(OutputStream os) throws IOException {
        os.write(this.contents);
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }
}

