/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = new HashMap<Integer, String>(){
        {
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(206, "Partial Content");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Temporary Redirect");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(307, "Temporary Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Time-Out");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Large");
            this.put(415, "Unsupported Media Type");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Timeout");
            this.put(505, "HTTP Version Not Supported");
        }
    };
    private static final AsciiSet unencodedChars = new AsciiSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()\\");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String trimSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        while (s.length() > 0 && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimTrailingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static StringBuffer trimTrailingSlashes(StringBuffer s) {
        if (s == null) {
            return null;
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == '/') {
            s.setLength(s.length() - 1);
        }
        return s;
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        boolean needsDecode = false;
        for (int i = 0; i < s.length() && !needsDecode; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            needsDecode = true;
        }
        if (needsDecode) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !unencodedChars.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find servlet path in request URI.  URI=[" + requestURI + "], servletPath=[" + servletPath + "]", e);
        }
    }
}

