/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.Context;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.internal.StringUtils;

public final class RestServletContext
extends Context {
    public static final String REST_allowHeaderParams = "RestServlet.allowHeaderParams";
    public static final String REST_allowMethodParam = "RestServlet.allowMethodParam";
    public static final String REST_allowBodyParam = "RestServlet.allowBodyParam";
    public static final String REST_renderResponseStackTraces = "RestServlet.renderResponseStackTraces";
    public static final String REST_useStackTraceHashes = "RestServlet.useStackTraceHashes";
    public static final String REST_defaultCharset = "RestServlet.defaultCharset";
    public static final String REST_paramFormat = "RestServlet.paramFormat";
    public static final String REST_servletPath = "RestServlet.servletPath";
    public static final String REST_servletURI = "RestServlet.servletURI";
    public static final String REST_relativeServletURI = "RestServlet.relativeServletURI";
    public static final String REST_pathInfo = "RestServlet.pathInfo";
    public static final String REST_requestURI = "RestServlet.requestURI";
    public static final String REST_method = "RestServlet.method";
    public static final String REST_servletTitle = "RestServlet.servletTitle";
    public static final String REST_servletDescription = "RestServlet.servletDescription";
    public static final String REST_methodSummary = "RestServlet.methodSummary";
    public static final String REST_methodDescription = "RestServlet.methodDescription";
    final boolean allowHeaderParams;
    final boolean allowBodyParam;
    final boolean renderResponseStackTraces;
    final boolean useStackTraceHashes;
    final String defaultCharset;
    final String paramFormat;
    final Set<String> allowMethodParams;

    public RestServletContext(ContextFactory cf) {
        super(cf);
        this.allowHeaderParams = cf.getProperty(REST_allowHeaderParams, Boolean.TYPE, true);
        this.allowBodyParam = cf.getProperty(REST_allowBodyParam, Boolean.TYPE, true);
        this.renderResponseStackTraces = cf.getProperty(REST_renderResponseStackTraces, Boolean.TYPE, false);
        this.useStackTraceHashes = cf.getProperty(REST_useStackTraceHashes, Boolean.TYPE, true);
        this.defaultCharset = cf.getProperty(REST_defaultCharset, String.class, "utf-8");
        this.paramFormat = cf.getProperty(REST_paramFormat, String.class, "");
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (String m : StringUtils.split(cf.getProperty(REST_allowMethodParam, String.class, ""), ',')) {
            if (m.equals("true")) {
                s.add("*");
                continue;
            }
            s.add(m.toUpperCase());
        }
        this.allowMethodParams = Collections.unmodifiableSet(s);
    }
}

