/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigMgr;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ByteArrayCache;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Utils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.server.ClientVersionMatcher;
import org.apache.juneau.server.ResponseHandler;
import org.apache.juneau.server.RestConverter;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestGuard;
import org.apache.juneau.server.RestMatcher;
import org.apache.juneau.server.RestMatcherReflecting;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestResponse;
import org.apache.juneau.server.RestServletContext;
import org.apache.juneau.server.RestServletException;
import org.apache.juneau.server.RestUtils;
import org.apache.juneau.server.StreamResource;
import org.apache.juneau.server.UrlPathPattern;
import org.apache.juneau.server.annotation.Body;
import org.apache.juneau.server.annotation.FormData;
import org.apache.juneau.server.annotation.HasFormData;
import org.apache.juneau.server.annotation.HasQuery;
import org.apache.juneau.server.annotation.Header;
import org.apache.juneau.server.annotation.Inherit;
import org.apache.juneau.server.annotation.Messages;
import org.apache.juneau.server.annotation.Method;
import org.apache.juneau.server.annotation.Parameter;
import org.apache.juneau.server.annotation.Path;
import org.apache.juneau.server.annotation.PathRemainder;
import org.apache.juneau.server.annotation.Properties;
import org.apache.juneau.server.annotation.Property;
import org.apache.juneau.server.annotation.Query;
import org.apache.juneau.server.annotation.Response;
import org.apache.juneau.server.annotation.RestMethod;
import org.apache.juneau.server.annotation.RestResource;
import org.apache.juneau.server.response.DefaultHandler;
import org.apache.juneau.server.response.InputStreamHandler;
import org.apache.juneau.server.response.ReaderHandler;
import org.apache.juneau.server.response.RedirectHandler;
import org.apache.juneau.server.response.StreamableHandler;
import org.apache.juneau.server.response.WritableHandler;
import org.apache.juneau.server.vars.LocalizationVar;
import org.apache.juneau.server.vars.RequestVar;
import org.apache.juneau.server.vars.SerializedRequestAttrVar;
import org.apache.juneau.server.vars.ServletInitParamVar;
import org.apache.juneau.server.vars.UrlEncodeVar;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.svl.vars.ConfigFileVar;
import org.apache.juneau.svl.vars.EnvVariablesVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.MessageBundle;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final SortedMap<String, Charset> availableCharsets = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ResourceMethod> restMethods = new LinkedHashMap<String, ResourceMethod>();
    private final Map<String, MethodMeta> javaRestMethods = new LinkedHashMap<String, MethodMeta>();
    private final Map<String, RestServlet> childResources = new LinkedHashMap<String, RestServlet>();
    private RestServlet parentResource;
    private ServletConfig servletConfig;
    private volatile boolean isInitialized = false;
    private Exception initException;
    private JuneauLogger logger;
    private MessageBundle msgs;
    private Map<Integer, Integer> stackTraceHashes = new HashMap<Integer, Integer>();
    private String path;
    private LinkedHashMap<Class<?>, RestResource> restResourceAnnotationsChildFirst;
    private LinkedHashMap<Class<?>, RestResource> restResourceAnnotationsParentFirst;
    private UrlEncodingSerializer urlEncodingSerializer;
    private UrlEncodingParser urlEncodingParser;
    private ObjectMap properties;
    private RestGuard[] guards;
    private Class<?>[] beanFilters;
    private Class<?>[] pojoSwaps;
    private RestConverter[] converters;
    private TreeMap<String, String> defaultRequestHeaders;
    private Map<String, Object> defaultResponseHeaders;
    private EncoderGroup encoders;
    private SerializerGroup serializers;
    private ParserGroup parsers;
    private MimetypesFileTypeMap mimetypesFileTypeMap;
    private BeanContext beanContext;
    private VarResolver varResolver;
    private String title;
    private String description;
    private String termsOfService;
    private String contact;
    private String license;
    private String version;
    private String tags;
    private String externalDocs;
    private Map<String, byte[]> resourceStreams = new ConcurrentHashMap<String, byte[]>();
    private Map<String, String> resourceStrings = new ConcurrentHashMap<String, String>();
    private ConfigFile configFile;
    private ConfigFile resolvingConfigFile;
    private String configPath;
    private StreamResource styleSheet;
    private StreamResource favIcon;
    private Map<String, String> staticFilesMap;
    private String[] staticFilesPrefixes;
    private ResponseHandler[] responseHandlers;
    private String clientVersionHeader = "";
    private ConcurrentHashMap<Locale, Swagger> swaggers = new ConcurrentHashMap();
    RestServletContext context;
    private Map<String, StreamResource> staticFilesCache = new ConcurrentHashMap<String, StreamResource>();

    public RestServlet() {
        this.varResolver = this.createVarResolver();
        this.restResourceAnnotationsChildFirst = ReflectionUtils.findAnnotationsMap(RestResource.class, ((Object)((Object)this)).getClass());
        this.restResourceAnnotationsParentFirst = CollectionUtils.reverse(this.restResourceAnnotationsChildFirst);
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            if (r.config().isEmpty()) continue;
            this.configPath = r.config();
        }
        try {
            this.configFile = this.createConfigFile();
            this.varResolver.setContextObject("config", this.configFile);
        }
        catch (IOException e) {
            this.initException = e;
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.log(Level.FINE, "Servlet {0} init called.", ((Object)((Object)this)).getClass().getName());
            this.servletConfig = servletConfig;
            if (this.isInitialized) {
                return;
            }
            super.init(servletConfig);
            for (Map.Entry<Class<?>, RestResource> e : this.restResourceAnnotationsChildFirst.entrySet()) {
                Class<?> c = e.getKey();
                RestResource r = e.getValue();
                if (r.messages().isEmpty()) continue;
                if (this.msgs == null) {
                    this.msgs = new MessageBundle(c, r.messages());
                    continue;
                }
                this.msgs.addSearchPath(c, r.messages());
            }
            for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
                if (!r.title().isEmpty()) {
                    this.title = r.title();
                }
                if (!r.description().isEmpty()) {
                    this.description = r.description();
                }
                if (!r.clientVersionHeader().isEmpty()) {
                    this.clientVersionHeader = r.clientVersionHeader();
                }
                if (!r.termsOfService().isEmpty()) {
                    this.termsOfService = r.termsOfService();
                }
                if (!r.contact().isEmpty()) {
                    this.contact = r.contact();
                }
                if (!r.license().isEmpty()) {
                    this.license = r.license();
                }
                if (!r.version().isEmpty()) {
                    this.version = r.version();
                }
                if (!r.tags().isEmpty()) {
                    this.tags = r.tags();
                }
                if (r.externalDocs().isEmpty()) continue;
                this.externalDocs = r.externalDocs();
            }
            if (this.msgs == null) {
                this.msgs = new MessageBundle(((Object)((Object)this)).getClass(), "");
            }
            if (this.clientVersionHeader.isEmpty()) {
                this.clientVersionHeader = "X-Client-Version";
            }
            this.styleSheet = this.createStyleSheet();
            this.favIcon = this.createFavIcon();
            this.staticFilesMap = Collections.unmodifiableMap(this.createStaticFilesMap());
            this.staticFilesPrefixes = this.staticFilesMap.keySet().toArray(new String[0]);
            this.properties = this.createProperties();
            this.beanFilters = this.createBeanFilters();
            this.pojoSwaps = this.createPojoSwaps();
            this.context = ContextFactory.create().setProperties(this.properties).getContext(RestServletContext.class);
            this.beanContext = this.createBeanContext(this.properties, this.beanFilters, this.pojoSwaps);
            this.urlEncodingSerializer = this.createUrlEncodingSerializer(this.properties, this.beanFilters, this.pojoSwaps).lock();
            this.urlEncodingParser = this.createUrlEncodingParser(this.properties, this.beanFilters, this.pojoSwaps).lock();
            this.serializers = this.createSerializers(this.properties, this.beanFilters, this.pojoSwaps).lock();
            this.parsers = this.createParsers(this.properties, this.beanFilters, this.pojoSwaps).lock();
            this.converters = this.createConverters(this.properties);
            this.encoders = this.createEncoders(this.properties);
            this.guards = this.createGuards(this.properties);
            this.mimetypesFileTypeMap = this.createMimetypesFileTypeMap(this.properties);
            this.defaultRequestHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.defaultRequestHeaders.putAll(this.createDefaultRequestHeaders(this.properties));
            this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.properties);
            this.responseHandlers = this.createResponseHandlers(this.properties);
            LinkedList<String> methodsFound = new LinkedList<String>();
            for (java.lang.reflect.Method method : ((Object)((Object)this)).getClass().getMethods()) {
                if (!method.isAnnotationPresent(RestMethod.class)) continue;
                RestMethod a = method.getAnnotation(RestMethod.class);
                methodsFound.add(method.getName() + "," + a.name() + "," + a.path());
                try {
                    if (!Modifier.isPublic(method.getModifiers())) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", ((Object)((Object)this)).getClass().getName(), method.getName());
                    }
                    MethodMeta sm = new MethodMeta(method);
                    this.javaRestMethods.put(method.getName(), sm);
                    ResourceMethod rm = this.restMethods.get(sm.httpMethod);
                    if (rm == null) {
                        this.restMethods.put(sm.httpMethod, sm);
                        continue;
                    }
                    if (rm instanceof MultiMethod) {
                        ((MultiMethod)rm).addSimpleMethod(sm);
                        continue;
                    }
                    this.restMethods.put(sm.httpMethod, new MultiMethod(new MethodMeta[]{(MethodMeta)rm, sm}));
                }
                catch (RestServletException e) {
                    throw new RestServletException("Problem occurred trying to serialize methods on class {0}, methods={1}", ((Object)((Object)this)).getClass().getName(), JsonSerializer.DEFAULT_LAX.serialize(methodsFound)).initCause((Throwable)((Object)e));
                }
            }
            for (ResourceMethod m : this.restMethods.values()) {
                m.complete();
            }
            this.childResources.putAll(this.createChildrenMap());
            for (RestServlet child : this.childResources.values()) {
                child.init(servletConfig);
            }
            this.varResolver.addVars(LocalizationVar.class, RequestVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, UrlEncodeVar.class);
        }
        catch (RestException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            this.title = String.valueOf(this.initException.getLocalizedMessage());
        }
        catch (ServletException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            this.title = String.valueOf(this.initException.getLocalizedMessage());
            throw e;
        }
        catch (Exception e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            this.title = String.valueOf(this.initException.getLocalizedMessage());
            throw new ServletException((Throwable)e);
        }
        catch (Throwable e) {
            this.initException = new Exception(e);
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            this.title = String.valueOf(this.initException.getLocalizedMessage());
            throw new ServletException(e);
        }
        finally {
            this.isInitialized = true;
        }
    }

    protected Map<String, RestServlet> createChildrenMap() throws Exception {
        LinkedHashMap<String, RestServlet> m = new LinkedHashMap<String, RestServlet>();
        for (RestServlet r : this.createChildren()) {
            r.setParent(this);
            String p = r.findPath();
            if (p == null) {
                throw new RestServletException("Child resource ''{0}'' does not define a ''@RestResource.path'' attribute.", ((Object)((Object)r)).getClass().getName());
            }
            m.put(p, r);
        }
        return m;
    }

    protected List<RestServlet> createChildren() throws Exception {
        LinkedList<RestServlet> l = new LinkedList<RestServlet>();
        for (Class<?> c : this.getChildClasses()) {
            if (ClassUtils.isParentClass(RestServlet.class, c)) {
                l.add((RestServlet)((Object)c.newInstance()));
                continue;
            }
            l.add(this.resolveChild(c));
        }
        return l;
    }

    protected Class<?>[] getChildClasses() throws Exception {
        ArrayList l = new ArrayList();
        List<RestResource> rr = ReflectionUtils.findAnnotations(RestResource.class, ((Object)((Object)this)).getClass());
        for (RestResource r : rr) {
            l.addAll(Arrays.asList(r.children()));
        }
        return l.toArray(new Class[l.size()]);
    }

    protected ObjectMap createProperties() {
        ObjectMap m = new ObjectMap();
        ServletContext ctx = this.servletConfig.getServletContext();
        String ctxPath = ctx.getContextPath();
        if (ctxPath.endsWith("null")) {
            ctxPath = ctxPath.substring(0, ctxPath.length() - 4);
        }
        m.put("Serializer.relativeUriBase", ctxPath);
        Enumeration ep = this.servletConfig.getInitParameterNames();
        while (ep.hasMoreElements()) {
            String p = (String)ep.nextElement();
            String initParam = this.servletConfig.getInitParameter(p);
            m.put(p, initParam);
        }
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (Property p : r.properties()) {
                m.append(this.getVarResolver().resolve(p.name()), this.getVarResolver().resolve(p.value()));
            }
        }
        return m;
    }

    protected Class<?>[] createBeanFilters() {
        LinkedList l = new LinkedList();
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            for (Class<?> c : r.beanFilters()) {
                l.add(c);
            }
        }
        return l.toArray(new Class[l.size()]);
    }

    protected Class<?>[] createPojoSwaps() {
        LinkedList l = new LinkedList();
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            for (Class<?> c : r.pojoSwaps()) {
                l.add(c);
            }
        }
        return l.toArray(new Class[l.size()]);
    }

    protected BeanContext createBeanContext(ObjectMap properties, Class<?>[] beanFilters, Class<?>[] pojoSwaps) throws Exception {
        return ContextFactory.create().addBeanFilters(beanFilters).addPojoSwaps(pojoSwaps).setProperties(properties).getBeanContext();
    }

    protected UrlEncodingSerializer createUrlEncodingSerializer(ObjectMap properties, Class<?>[] beanFilters, Class<?>[] pojoSwaps) throws Exception {
        return ((UrlEncodingSerializer)new UrlEncodingSerializer().setProperties(properties).addBeanFilters((Class[])beanFilters)).addPojoSwaps((Class[])pojoSwaps);
    }

    protected UrlEncodingParser createUrlEncodingParser(ObjectMap properties, Class<?>[] beanFilters, Class<?>[] pojoSwaps) throws Exception {
        return ((UrlEncodingParser)new UrlEncodingParser().setProperties(properties).addBeanFilters((Class[])beanFilters)).addPojoSwaps((Class[])pojoSwaps);
    }

    protected SerializerGroup createSerializers(ObjectMap properties, Class<?>[] beanFilters, Class<?>[] pojoSwaps) throws Exception {
        SerializerGroup g = new SerializerGroup();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (Class<? extends Serializer> c : ArrayUtils.reverse(r.serializers())) {
                try {
                    g.append(c);
                }
                catch (Exception e) {
                    throw new RestServletException("Exception occurred while trying to instantiate Serializer ''{0}''", c.getSimpleName()).initCause(e);
                }
            }
        }
        g.setProperties(properties);
        g.addBeanFilters(beanFilters).addPojoSwaps(pojoSwaps);
        return g;
    }

    protected ParserGroup createParsers(ObjectMap properties, Class<?>[] beanFilters, Class<?>[] pojoSwaps) throws Exception {
        ParserGroup g = new ParserGroup();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (Class<? extends Parser> p : ArrayUtils.reverse(r.parsers())) {
                try {
                    g.append(p);
                }
                catch (Exception e) {
                    throw new RestServletException("Exception occurred while trying to instantiate Parser ''{0}''", p.getSimpleName()).initCause(e);
                }
            }
        }
        g.setProperties(properties);
        g.addBeanFilters(beanFilters).addPojoSwaps(pojoSwaps);
        return g;
    }

    protected RestConverter[] createConverters(ObjectMap properties) throws RestServletException {
        LinkedList<RestConverter> l = new LinkedList<RestConverter>();
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            for (Class<? extends RestConverter> c : r.converters()) {
                try {
                    l.add(c.newInstance());
                }
                catch (Exception e) {
                    throw new RestServletException("Exception occurred while trying to instantiate RestConverter ''{0}''", c.getSimpleName()).initCause(e);
                }
            }
        }
        return l.toArray(new RestConverter[l.size()]);
    }

    protected EncoderGroup createEncoders(ObjectMap properties) throws RestServletException {
        EncoderGroup g = new EncoderGroup().append(IdentityEncoder.INSTANCE);
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (Class<? extends Encoder> c : ArrayUtils.reverse(r.encoders())) {
                try {
                    g.append(c);
                }
                catch (Exception e) {
                    throw new RestServletException("Exception occurred while trying to instantiate Encoder ''{0}''", c.getSimpleName()).initCause(e);
                }
            }
        }
        return g;
    }

    protected RestGuard[] createGuards(ObjectMap properties) throws RestServletException {
        LinkedList<RestGuard> l = new LinkedList<RestGuard>();
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            for (Class<? extends RestGuard> c : ArrayUtils.reverse(r.guards())) {
                try {
                    l.add(c.newInstance());
                }
                catch (Exception e) {
                    throw new RestServletException("Exception occurred while trying to instantiate RestGuard ''{0}''", c.getSimpleName()).initCause(e);
                }
            }
        }
        return l.toArray(new RestGuard[l.size()]);
    }

    protected MimetypesFileTypeMap createMimetypesFileTypeMap(ObjectMap properties) {
        MimetypesFileTypeMap m = new MimetypesFileTypeMap();
        m.addMimeTypes("text/css css CSS");
        m.addMimeTypes("text/html html htm HTML");
        m.addMimeTypes("text/plain txt text TXT");
        m.addMimeTypes("application/javascript js");
        m.addMimeTypes("image/png png");
        m.addMimeTypes("image/gif gif");
        m.addMimeTypes("application/xml xml XML");
        m.addMimeTypes("application/json json JSON");
        return m;
    }

    protected Map<String, String> createDefaultRequestHeaders(ObjectMap properties) throws RestServletException {
        HashMap<String, String> m = new HashMap<String, String>();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (String s : r.defaultRequestHeaders()) {
                String[] h = this.parseHeader(s);
                if (h == null) {
                    throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", s);
                }
                m.put(h[0], h[1]);
            }
        }
        return m;
    }

    protected Map<String, Object> createDefaultResponseHeaders(ObjectMap properties) throws RestServletException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (String s : r.defaultResponseHeaders()) {
                String[] h = this.parseHeader(s);
                if (h == null) {
                    throw new RestServletException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", s);
                }
                m.put(h[0], h[1]);
            }
        }
        return m;
    }

    protected ResponseHandler[] createResponseHandlers(ObjectMap properties) throws RestException {
        LinkedList<ResponseHandler> l = new LinkedList<ResponseHandler>();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            for (Class<? extends ResponseHandler> c : r.responseHandlers()) {
                try {
                    l.add(c.newInstance());
                }
                catch (Exception e) {
                    throw new RestException(500, (Throwable)e);
                }
            }
        }
        l.add(new StreamableHandler());
        l.add(new WritableHandler());
        l.add(new ReaderHandler());
        l.add(new InputStreamHandler());
        l.add(new RedirectHandler());
        l.add(new DefaultHandler());
        return l.toArray(new ResponseHandler[l.size()]);
    }

    protected Swagger getSwaggerFromFile(Locale locale) throws RestException {
        Swagger s = this.swaggers.get(locale);
        if (s == null) {
            try {
                s = this.getResource(Swagger.class, "text/json", ((Object)((Object)this)).getClass().getSimpleName() + ".json", locale);
                this.swaggers.putIfAbsent(locale, s == null ? Swagger.NULL : s);
            }
            catch (Exception e) {
                throw new RestException(500, (Throwable)e);
            }
        }
        return s == Swagger.NULL ? null : s;
    }

    protected Swagger getSwagger(RestRequest req) throws RestException {
        try {
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s;
            }
            Info info = Info.create(this.getTitle(req), this.getVersion(req)).setContact(this.getContact(req)).setLicense(this.getLicense(req)).setDescription(this.getDescription(req)).setTermsOfService(this.getTermsOfService(req));
            s = Swagger.create(info).addConsumes(this.getSupportedAcceptTypes()).addProduces(this.getSupportedContentTypes()).setTags(this.getTags(req)).setExternalDocs(this.getExternalDocs(req));
            for (MethodMeta sm : this.javaRestMethods.values()) {
                if (!sm.isRequestAllowed(req)) continue;
                Operation o = sm.getSwaggerOperation(req);
                s.addPath(((MethodMeta)sm).pathPattern.patternString, sm.httpMethod.toLowerCase(), o);
            }
            return s;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    protected void setParent(RestServlet parent) {
        this.parentResource = parent;
    }

    public RestServlet getParent() {
        return this.parentResource;
    }

    private String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    protected RestRequest createRequest(HttpServletRequest req) throws ServletException {
        return new RestRequest(this, req);
    }

    protected RestResponse createResponse(RestRequest req, HttpServletResponse res) throws ServletException {
        return new RestResponse(this, req, res);
    }

    public boolean hasOptionsPage() {
        return false;
    }

    public synchronized RestServlet setProperty(String key, Object value) {
        this.getProperties().put(key, value);
        return this;
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        this.log(Level.FINE, "HTTP: {0} {1}", r1.getMethod(), r1.getRequestURI());
        long startTime = System.currentTimeMillis();
        try {
            int i;
            String pathInfoPart;
            RestServlet childResource;
            if (this.initException != null) {
                if (this.initException instanceof RestException) {
                    throw (RestException)this.initException;
                }
                throw new RestException(500, (Throwable)this.initException);
            }
            if (!this.isInitialized) {
                throw new RestException(500, "Servlet has not been initialized", new Object[0]);
            }
            String pathInfo = RestUtils.getPathInfoUndecoded(r1);
            if (pathInfo != null && !this.childResources.isEmpty() && !pathInfo.equals("/") && (childResource = this.childResources.get(pathInfoPart = (i = pathInfo.indexOf(47, 1)) == -1 ? pathInfo.substring(1) : pathInfo.substring(1, i))) != null) {
                final String pathInfoRemainder = i == -1 ? null : pathInfo.substring(i);
                final String servletPath = r1.getServletPath() + "/" + pathInfoPart;
                HttpServletRequestWrapper childRequest = new HttpServletRequestWrapper(r1){

                    public String getPathInfo() {
                        return RestUtils.decode(pathInfoRemainder);
                    }

                    public String getServletPath() {
                        return servletPath;
                    }
                };
                childResource.service((HttpServletRequest)childRequest, r2);
                return;
            }
            RestRequest req = this.createRequest(r1);
            RestResponse res = this.createResponse(req, r2);
            String method = req.getMethod();
            String methodUC = method.toUpperCase(Locale.ENGLISH);
            StreamResource r = null;
            if (pathInfo != null) {
                String p = pathInfo.substring(1);
                if (p.equals("favicon.ico")) {
                    r = this.favIcon;
                } else if (p.equals("style.css")) {
                    r = this.styleSheet;
                } else if (StringUtils.pathStartsWith(p, this.staticFilesPrefixes)) {
                    r = this.resolveStaticFile(p);
                }
            }
            if (r != null) {
                res.setStatus(200);
                res.setOutput(r);
            } else {
                int rc = 405;
                if (this.restMethods.containsKey(methodUC)) {
                    rc = this.restMethods.get(methodUC).invoke(method, pathInfo, this, req, res);
                } else if (this.restMethods.containsKey("*")) {
                    rc = this.restMethods.get("*").invoke(method, pathInfo, this, req, res);
                }
                if (rc != 200) {
                    this.handleNotFound(rc, req, res);
                }
            }
            if (res.hasOutput()) {
                Object output = res.getOutput();
                for (RestConverter converter : this.getConverters()) {
                    output = converter.convert(req, output, this.getBeanContext().getClassMetaForObject(output));
                }
                res.setOutput(output);
                this.handleResponse(req, res, output);
            }
            this.onSuccess(req, res, System.currentTimeMillis() - startTime);
        }
        catch (RestException e) {
            this.handleError(r1, r2, e);
        }
        catch (Throwable e) {
            this.handleError(r1, r2, new RestException(500, e));
        }
        this.log(Level.FINE, "HTTP: [{0} {1}] finished in {2}ms", r1.getMethod(), r1.getRequestURI(), System.currentTimeMillis() - startTime);
    }

    protected void handleNotFound(int rc, RestRequest req, RestResponse res) throws Exception {
        String onPath;
        String pathInfo = req.getPathInfo();
        String methodUC = req.getMethod();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new RestException(rc, "Method ''{0}'' not found on resource with matching pattern{1}.", methodUC, onPath);
        }
        if (rc == 412) {
            throw new RestException(rc, "Method ''{0}'' not found on resource{1} with matching matcher.", methodUC, onPath);
        }
        if (rc == 405) {
            throw new RestException(rc, "Method ''{0}'' not found on resource.", methodUC);
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    private synchronized void handleError(HttpServletRequest req, HttpServletResponse res, RestException e) throws IOException {
        Integer c = 1;
        if (this.context.useStackTraceHashes) {
            int h = e.hashCode();
            c = this.stackTraceHashes.get(h);
            if (c == null) {
                c = 1;
            } else {
                Integer n = c;
                Integer n2 = c = Integer.valueOf(c + 1);
            }
            this.stackTraceHashes.put(h, c);
            e.setOccurrence(c);
        }
        this.onError(req, res, e);
        this.renderError(req, res, e);
    }

    protected void renderError(HttpServletRequest req, HttpServletResponse res, RestException e) throws IOException {
        int status = e.getStatus();
        res.setStatus(status);
        res.setContentType("text/plain");
        res.setHeader("Content-Encoding", "identity");
        PrintWriter w = null;
        try {
            w = res.getWriter();
        }
        catch (IllegalStateException e2) {
            w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
        }
        String httpMessage = RestUtils.getHttpResponseText(status);
        if (httpMessage != null) {
            w.append("HTTP ").append(String.valueOf(status)).append(": ").append(httpMessage).append("\n\n");
        }
        if (this.context.renderResponseStackTraces) {
            e.printStackTrace(w);
        } else {
            w.append(e.getFullStackMessage(true));
        }
        w.flush();
        w.close();
    }

    protected void onError(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (this.shouldLog(req, res, e)) {
            String qs = req.getQueryString();
            String msg = "HTTP " + req.getMethod() + " " + e.getStatus() + " " + req.getRequestURI() + (qs == null ? "" : "?" + qs);
            int c = e.getOccurrence();
            if (this.shouldLogStackTrace(req, res, e)) {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg;
                this.log(Level.WARNING, e, msg, new Object[0]);
            } else {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg + ", " + e.getLocalizedMessage();
                this.log(Level.WARNING, msg, new Object[0]);
            }
        }
    }

    protected boolean shouldLog(HttpServletRequest req, HttpServletResponse res, RestException e) {
        String q = req.getQueryString();
        return q == null ? true : q.indexOf("noTrace=true") == -1;
    }

    protected boolean shouldLogStackTrace(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (e.getOccurrence() == 1) {
            switch (e.getStatus()) {
                case 401: 
                case 403: 
                case 404: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void log(Level level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    protected void logObjects(Level level, String msg, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = JsonSerializer.DEFAULT_LAX_READABLE.toStringObject(args[i]);
        }
        this.log(level, null, msg, args);
    }

    protected void log(Level level, Throwable cause, String msg, Object ... args) {
        JuneauLogger log = this.getLogger();
        if (args.length > 0) {
            msg = MessageFormat.format(msg, args);
        }
        log.log(level, msg, cause);
    }

    protected void onSuccess(RestRequest req, RestResponse res, long time) {
    }

    protected void onPreCall(RestRequest req) throws RestException {
    }

    protected void onPostCall(RestRequest req, RestResponse res) throws RestException {
    }

    protected void handleResponse(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        for (ResponseHandler h : this.getResponseHandlers()) {
            if (!h.handle(req, res, output)) continue;
            return;
        }
        throw new RestException(501, "No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'", new Object[0]);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void destroy() {
        for (RestServlet r : this.childResources.values()) {
            r.destroy();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamResource resolveStaticFile(String pathInfo) throws IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            String p = RestUtils.decode(RestUtils.trimSlashes(pathInfo));
            if (p.indexOf("..") != -1) {
                throw new RestException(404, "Invalid path", new Object[0]);
            }
            for (Map.Entry<String, String> e : this.staticFilesMap.entrySet()) {
                String p2;
                InputStream is;
                String remainder;
                String key = RestUtils.trimSlashes(e.getKey());
                if (!p.startsWith(key)) continue;
                String string = remainder = p.equals(key) ? "" : p.substring(key.length());
                if (!remainder.isEmpty() && !remainder.startsWith("/") || (is = this.getResource(p2 = RestUtils.trimSlashes(e.getValue()) + remainder, null)) == null) continue;
                try {
                    int i = p2.lastIndexOf(47);
                    String name = i == -1 ? p2 : p2.substring(i + 1);
                    String mediaType = this.getMimetypesFileTypeMap().getContentType(name);
                    this.staticFilesCache.put(pathInfo, new StreamResource(is, mediaType).setHeader("Cache-Control", "max-age=86400, public"));
                    StreamResource streamResource = this.staticFilesCache.get(pathInfo);
                    return streamResource;
                }
                finally {
                    is.close();
                }
            }
        }
        return this.staticFilesCache.get(pathInfo);
    }

    public Collection<String> getSupportedAcceptTypes() throws RestServletException {
        return this.getParsers().getSupportedMediaTypes();
    }

    public Collection<String> getSupportedContentTypes() throws RestServletException {
        return this.getSerializers().getSupportedMediaTypes();
    }

    public String getMethodSummary(String javaMethodName, RestRequest req) {
        MethodMeta m = this.javaRestMethods.get(javaMethodName);
        if (m != null) {
            return m.getSummary(req);
        }
        return "";
    }

    public String getMethodDescription(String javaMethodName, RestRequest req) {
        MethodMeta m = this.javaRestMethods.get(javaMethodName);
        if (m != null) {
            return m.getDescription(req);
        }
        return "";
    }

    public String getTitle(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.title != null) {
            return vr.resolve(this.title);
        }
        String title = this.msgs.findFirstString(req.getLocale(), "title");
        if (title != null) {
            return vr.resolve(title);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getTitle();
        }
        return null;
    }

    public String getDescription(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.description != null) {
            return vr.resolve(this.description);
        }
        String description = this.msgs.findFirstString(req.getLocale(), "description");
        if (description != null) {
            return vr.resolve(description);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getDescription();
        }
        return null;
    }

    public Contact getContact(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.contact != null) {
                return jp.parse((Object)vr.resolve(this.contact), Contact.class);
            }
            String contact = this.msgs.findFirstString(req.getLocale(), "contact");
            if (contact != null) {
                return jp.parse((Object)vr.resolve(contact), Contact.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null && s.getInfo() != null) {
                return s.getInfo().getContact();
            }
            return null;
        }
        catch (ParseException e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public License getLicense(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.license != null) {
                return jp.parse((Object)vr.resolve(this.license), License.class);
            }
            String license = this.msgs.findFirstString(req.getLocale(), "license");
            if (license != null) {
                return jp.parse((Object)vr.resolve(license), License.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null && s.getInfo() != null) {
                return s.getInfo().getLicense();
            }
            return null;
        }
        catch (ParseException e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public String getTermsOfService(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.termsOfService != null) {
            return vr.resolve(this.termsOfService);
        }
        String termsOfService = this.msgs.findFirstString(req.getLocale(), "termsOfService");
        if (termsOfService != null) {
            return vr.resolve(termsOfService);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getTermsOfService();
        }
        return null;
    }

    public String getVersion(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.version != null) {
            return vr.resolve(this.version);
        }
        String version = this.msgs.findFirstString(req.getLocale(), "version");
        if (version != null) {
            return vr.resolve(version);
        }
        Swagger s = req.getSwaggerFromFile();
        if (s != null && s.getInfo() != null) {
            return s.getInfo().getVersion();
        }
        return null;
    }

    public List<Tag> getTags(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.tags != null) {
                return jp.parseCollection(vr.resolve(this.tags), ArrayList.class, Tag.class);
            }
            String tags = this.msgs.findFirstString(req.getLocale(), "tags");
            if (tags != null) {
                return jp.parseCollection(vr.resolve(tags), ArrayList.class, Tag.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s.getTags();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public ExternalDocumentation getExternalDocs(RestRequest req) {
        VarResolverSession vr = req.getVarResolverSession();
        JsonParser jp = JsonParser.DEFAULT;
        try {
            if (this.externalDocs != null) {
                return jp.parse((Object)vr.resolve(this.externalDocs), ExternalDocumentation.class);
            }
            String externalDocs = this.msgs.findFirstString(req.getLocale(), "externalDocs");
            if (externalDocs != null) {
                return jp.parse((Object)vr.resolve(externalDocs), ExternalDocumentation.class);
            }
            Swagger s = req.getSwaggerFromFile();
            if (s != null) {
                return s.getExternalDocs();
            }
            return null;
        }
        catch (Exception e) {
            throw new RestException(500, (Throwable)e);
        }
    }

    public MessageBundle getMessages() {
        return this.msgs;
    }

    public MessageBundle getMessages(Locale locale) {
        return this.msgs.getBundle(locale);
    }

    public String getMessage(Locale locale, String key, Object ... args) {
        return this.msgs.getString(locale, key, args);
    }

    protected void addChildResource(String name, RestServlet resource) throws ServletException {
        resource.init(this.getServletConfig());
        this.childResources.put(name, resource);
    }

    public Map<String, RestServlet> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    public String getPath() {
        if (this.path == null) {
            String p;
            LinkedList<String> l = new LinkedList<String>();
            RestServlet r = this;
            while (r != null && (p = r.findPath()) != null) {
                l.addFirst(p);
                r = r.parentResource;
            }
            StringBuilder sb = new StringBuilder();
            for (String p2 : l) {
                sb.append('/').append(p2);
            }
            this.path = sb.toString();
        }
        return this.path;
    }

    private String findPath() {
        List<RestResource> rrc = ReflectionUtils.findAnnotations(RestResource.class, ((Object)((Object)this)).getClass());
        for (RestResource rc : rrc) {
            String p = rc.path();
            if (StringUtils.startsWith(p, '/')) {
                p = p.substring(1);
            }
            if (p.isEmpty()) continue;
            return p;
        }
        return null;
    }

    protected ConfigFile createConfigFile() throws IOException {
        String cf = this.varResolver.resolve(this.configPath);
        if (cf.isEmpty()) {
            return this.getConfigMgr().create();
        }
        return this.getConfigMgr().get(cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamResource createStyleSheet() throws IOException {
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            String path;
            InputStream is;
            if (r.stylesheet().isEmpty() || (is = this.getResource(path = this.getVarResolver().resolve(r.stylesheet()), null)) == null) continue;
            try {
                StreamResource streamResource = new StreamResource(is, "text/css");
                return streamResource;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamResource createFavIcon() throws IOException {
        for (RestResource r : this.restResourceAnnotationsChildFirst.values()) {
            String path;
            InputStream is;
            if (r.favicon().isEmpty() || (is = this.getResource(path = this.getVarResolver().resolve(r.favicon()), null)) == null) continue;
            try {
                StreamResource streamResource = new StreamResource(is, "image/x-icon");
                return streamResource;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    protected Map<String, String> createStaticFilesMap() throws ParseException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (RestResource r : this.restResourceAnnotationsParentFirst.values()) {
            if (r.staticFiles().isEmpty()) continue;
            m.putAll(JsonParser.DEFAULT.parseMap(this.getVarResolver().resolve(r.staticFiles()), LinkedHashMap.class, String.class, String.class));
        }
        return m;
    }

    protected ConfigMgr getConfigMgr() {
        return ConfigMgr.DEFAULT;
    }

    protected JuneauLogger getLogger() {
        if (this.logger == null) {
            this.logger = JuneauLogger.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    protected VarResolver getVarResolver() {
        return this.varResolver;
    }

    protected ConfigFile getConfig() {
        ConfigFile cf;
        if (this.resolvingConfigFile == null && (cf = this.configFile) != null) {
            this.resolvingConfigFile = cf.getResolving(this.getVarResolver());
        }
        return this.resolvingConfigFile;
    }

    protected VarResolver createVarResolver() {
        return new VarResolver().addVars(SystemPropertiesVar.class, EnvVariablesVar.class, ConfigFileVar.class);
    }

    protected ObjectMap createRequestProperties(ObjectMap methodProperties, final RestRequest req) {
        ObjectMap m = new ObjectMap(){

            @Override
            public Object get(Object key) {
                Object o = super.get(key);
                if (o == null) {
                    String k = key.toString();
                    if (k.indexOf(46) != -1) {
                        String prefix = k.substring(0, k.indexOf(46));
                        String remainder = k.substring(k.indexOf(46) + 1);
                        if ("path".equals(prefix)) {
                            return req.getPathParameter(remainder);
                        }
                        if ("query".equals(prefix)) {
                            return req.getQueryParameter(remainder);
                        }
                        if ("formData".equals(prefix)) {
                            return req.getFormDataParameter(remainder);
                        }
                        if ("header".equals(prefix)) {
                            return req.getHeader(remainder);
                        }
                    }
                    if (k.equals("Serializer.absolutePathUriBase")) {
                        int serverPort = req.getServerPort();
                        String serverName = req.getServerName();
                        return req.getScheme() + "://" + serverName + (serverPort == 80 || serverPort == 443 ? "" : ":" + serverPort);
                    }
                    if (k.equals("RestServlet.servletPath")) {
                        return req.getServletPath();
                    }
                    if (k.equals("RestServlet.servletURI")) {
                        return req.getServletURI();
                    }
                    if (k.equals("RestServlet.relativeServletURI")) {
                        return req.getRelativeServletURI();
                    }
                    if (k.equals("RestServlet.pathInfo")) {
                        return req.getPathInfo();
                    }
                    if (k.equals("RestServlet.requestURI")) {
                        return req.getRequestURI();
                    }
                    if (k.equals("RestServlet.method")) {
                        return req.getMethod();
                    }
                    if (k.equals("RestServlet.servletTitle")) {
                        return req.getServletTitle();
                    }
                    if (k.equals("RestServlet.servletDescription")) {
                        return req.getServletDescription();
                    }
                    if (k.equals("RestServlet.methodSummary")) {
                        return req.getMethodSummary();
                    }
                    if (k.equals("RestServlet.methodDescription")) {
                        return req.getMethodDescription();
                    }
                    o = req.getPathParameter(k);
                    if (o == null) {
                        o = req.getHeader(k);
                    }
                }
                if (o instanceof String) {
                    o = req.getVarResolverSession().resolve(o.toString());
                }
                return o;
            }
        };
        m.setInner(methodProperties);
        return m;
    }

    public ObjectMap getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    public RestGuard[] getGuards() {
        return this.guards;
    }

    public Class<?>[] getBeanFilters() {
        return this.beanFilters;
    }

    public Class<?>[] getPojoSwaps() {
        return this.pojoSwaps;
    }

    public RestConverter[] getConverters() {
        return this.converters;
    }

    public TreeMap<String, String> getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    protected Map<String, Object> getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    public EncoderGroup getEncoders() {
        return this.encoders;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public UrlEncodingParser getUrlEncodingParser() {
        return this.urlEncodingParser;
    }

    public UrlEncodingSerializer getUrlEncodingSerializer() {
        return this.urlEncodingSerializer;
    }

    public MimetypesFileTypeMap getMimetypesFileTypeMap() {
        return this.mimetypesFileTypeMap;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    protected RestServlet resolveChild(Class<?> interfaceClass) throws ServletException {
        throw new ServletException("Invalid child class specified.  Must be an instance of RestServlet.  Class=[" + interfaceClass.getName() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceChild(RestServlet servlet) throws ServletException {
        Map<String, RestServlet> map = this.childResources;
        synchronized (map) {
            RestServlet old = this.findRestServlet(servlet);
            if (old == null) {
                throw new ServletException("Could not find servlet with class " + ((Object)((Object)servlet)).getClass().getName() + " for update.");
            }
            RestServlet parent = old.getParent();
            servlet.setParent(parent);
            servlet.init(parent.getServletConfig());
            parent.childResources.put(servlet.getPath(), servlet);
            old.destroy();
        }
    }

    private RestServlet findRestServlet(RestServlet servlet) {
        for (RestServlet c : this.getChildResources().values()) {
            if (((Object)((Object)c)).getClass().equals(((Object)((Object)servlet)).getClass())) {
                return c;
            }
            RestServlet c2 = c.findRestServlet(servlet);
            if (c2 == null) continue;
            return c2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getResource(String name, Locale locale) throws IOException {
        byte[] b;
        String n;
        String string = n = locale == null || locale.toString().isEmpty() ? name : name + '|' + locale;
        if (!this.resourceStreams.containsKey(n)) {
            InputStream is = ReflectionUtils.getLocalizedResource(((Object)((Object)this)).getClass(), name, locale);
            if (is == null && name.indexOf("..") == -1) {
                for (String n2 : FileUtils.getCandidateFileNames(name, locale)) {
                    File f = new File(n2);
                    if (!f.exists() || !f.canRead()) continue;
                    is = new FileInputStream(f);
                    break;
                }
            }
            if (is != null) {
                try {
                    this.resourceStreams.put(n, ByteArrayCache.DEFAULT.cache(is));
                }
                finally {
                    is.close();
                }
            }
        }
        return (b = this.resourceStreams.get(n)) == null ? null : new ByteArrayInputStream(b);
    }

    public String getResourceAsString(String name, Locale locale) throws IOException {
        String n;
        String string = n = locale == null || locale.toString().isEmpty() ? name : name + '|' + locale;
        if (!this.resourceStrings.containsKey(n)) {
            String s = IOUtils.read(this.getResource(name, locale));
            if (s == null) {
                throw new IOException("Resource '" + name + "' not found.");
            }
            this.resourceStrings.put(n, s);
        }
        return this.resourceStrings.get(n);
    }

    public <T> T getResource(Class<T> c, String mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getResource(name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.getParsers().getParser(mediaType);
            if (p != null) {
                try {
                    if (p.isReaderParser()) {
                        return p.parse((Object)new InputStreamReader(is, IOUtils.UTF8), c);
                    }
                    return p.parse((Object)is, c);
                }
                catch (ParseException e) {
                    throw new ServletException("Could not parse resource '' as media type '" + mediaType + "'.");
                }
            }
            throw new ServletException("Unknown media type '" + mediaType + "'");
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public Map<String, Object> getSessionObjects(RestRequest req) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", (Object)req);
        return m;
    }

    static {
        availableCharsets.putAll(Charset.availableCharsets());
    }

    private class MultiMethod
    extends ResourceMethod {
        MethodMeta[] childMethods;
        List<MethodMeta> tempCache;
        Set<String> collisions;

        private MultiMethod(MethodMeta ... simpleMethods) throws RestServletException {
            this.tempCache = new LinkedList<MethodMeta>();
            this.collisions = new HashSet<String>();
            for (MethodMeta m : simpleMethods) {
                this.addSimpleMethod(m);
            }
        }

        private void addSimpleMethod(MethodMeta m) throws RestServletException {
            if (m.guards.length == 0 && m.requiredMatchers.length == 0 && m.optionalMatchers.length == 0) {
                String p = m.httpMethod + ":" + m.pathPattern.toRegEx();
                if (this.collisions.contains(p)) {
                    throw new RestServletException("Duplicate Java methods assigned to the same method/pattern:  method=''{0}'', path=''{1}''", m.httpMethod, m.pathPattern);
                }
                this.collisions.add(p);
            }
            this.tempCache.add(m);
        }

        @Override
        void complete() {
            Collections.sort(this.tempCache);
            this.collisions = null;
            this.childMethods = this.tempCache.toArray(new MethodMeta[this.tempCache.size()]);
        }

        @Override
        int invoke(String methodName, String pathInfo, RestServlet resource, RestRequest req, RestResponse res) throws RestException {
            int maxRc = 0;
            for (MethodMeta m : this.childMethods) {
                int rc = m.invoke(methodName, pathInfo, resource, req, res);
                if (rc == 200) {
                    return 200;
                }
                maxRc = Math.max(maxRc, rc);
            }
            return maxRc;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultiMethod: [\n");
            for (MethodMeta sm : this.childMethods) {
                sb.append("\t" + sm + "\n");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private class MethodMeta
    extends ResourceMethod
    implements Comparable<MethodMeta> {
        private String httpMethod;
        private java.lang.reflect.Method method;
        private UrlPathPattern pathPattern;
        private MethodParam[] params;
        private RestGuard[] guards;
        private RestMatcher[] optionalMatchers;
        private RestMatcher[] requiredMatchers;
        private RestConverter[] mConverters;
        private SerializerGroup mSerializers;
        private ParserGroup mParsers;
        private EncoderGroup mEncoders;
        private UrlEncodingParser mUrlEncodingParser;
        private UrlEncodingSerializer mUrlEncodingSerializer;
        private ObjectMap mProperties;
        private Map<String, String> mDefaultRequestHeaders;
        private String mDefaultEncoding;
        private boolean mPlainParams;
        private boolean deprecated;
        private String description;
        private String tags;
        private String summary;
        private String externalDocs;
        private Integer priority;
        private Parameter[] parameters;
        private Response[] responses;

        private MethodMeta(java.lang.reflect.Method method) throws RestServletException {
            try {
                int i;
                this.method = method;
                RestMethod m = method.getAnnotation(RestMethod.class);
                if (m == null) {
                    throw new RestServletException("@RestMethod annotation not found on method ''{0}.{1}''", method.getDeclaringClass().getName(), method.getName());
                }
                if (!m.description().isEmpty()) {
                    this.description = m.description();
                }
                if (!m.tags().isEmpty()) {
                    this.tags = m.tags();
                }
                if (!m.summary().isEmpty()) {
                    this.summary = m.summary();
                }
                if (!m.externalDocs().isEmpty()) {
                    this.externalDocs = m.externalDocs();
                }
                this.deprecated = m.deprecated();
                this.parameters = m.parameters();
                this.responses = m.responses();
                this.mSerializers = RestServlet.this.getSerializers();
                this.mParsers = RestServlet.this.getParsers();
                this.mUrlEncodingParser = RestServlet.this.getUrlEncodingParser();
                this.mUrlEncodingSerializer = RestServlet.this.getUrlEncodingSerializer();
                this.mProperties = RestServlet.this.getProperties();
                this.mEncoders = RestServlet.this.getEncoders();
                ArrayList<Inherit> si = new ArrayList<Inherit>(Arrays.asList(m.serializersInherit()));
                ArrayList<Inherit> pi = new ArrayList<Inherit>(Arrays.asList(m.parsersInherit()));
                if (m.serializers().length > 0 || m.parsers().length > 0 || m.properties().length > 0 || m.beanFilters().length > 0 || m.pojoSwaps().length > 0) {
                    this.mSerializers = si.contains((Object)Inherit.SERIALIZERS) || m.serializers().length == 0 ? this.mSerializers.clone() : new SerializerGroup();
                    this.mParsers = pi.contains((Object)Inherit.PARSERS) || m.parsers().length == 0 ? this.mParsers.clone() : new ParserGroup();
                    this.mUrlEncodingParser = this.mUrlEncodingParser.clone();
                }
                this.httpMethod = m.name().toUpperCase(Locale.ENGLISH);
                if (this.httpMethod.equals("") && method.getName().startsWith("do")) {
                    this.httpMethod = method.getName().substring(2).toUpperCase(Locale.ENGLISH);
                }
                if (this.httpMethod.equals("")) {
                    throw new RestServletException("@RestMethod name not specified on method ''{0}.{1}''", method.getDeclaringClass().getName(), method.getName());
                }
                if (this.httpMethod.equals("METHOD")) {
                    this.httpMethod = "*";
                }
                this.priority = m.priority();
                String p = m.path();
                this.mConverters = new RestConverter[m.converters().length];
                for (i = 0; i < this.mConverters.length; ++i) {
                    this.mConverters[i] = m.converters()[i].newInstance();
                }
                this.guards = new RestGuard[m.guards().length];
                for (i = 0; i < this.guards.length; ++i) {
                    this.guards[i] = m.guards()[i].newInstance();
                }
                LinkedList<RestMatcher> optionalMatchers = new LinkedList<RestMatcher>();
                LinkedList<RestMatcher> requiredMatchers = new LinkedList<RestMatcher>();
                for (int i2 = 0; i2 < m.matchers().length; ++i2) {
                    Class<? extends RestMatcher> c = m.matchers()[i2];
                    RestMatcher matcher = null;
                    matcher = ClassUtils.isParentClass(RestMatcherReflecting.class, c) ? c.getConstructor(RestServlet.class, java.lang.reflect.Method.class).newInstance(new Object[]{RestServlet.this, method}) : c.newInstance();
                    if (matcher.mustMatch()) {
                        requiredMatchers.add(matcher);
                        continue;
                    }
                    optionalMatchers.add(matcher);
                }
                if (!m.clientVersion().isEmpty()) {
                    requiredMatchers.add(new ClientVersionMatcher(RestServlet.this, method));
                }
                this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
                this.optionalMatchers = optionalMatchers.toArray(new RestMatcher[optionalMatchers.size()]);
                if (m.serializers().length > 0) {
                    this.mSerializers.append(m.serializers());
                    if (si.contains((Object)Inherit.TRANSFORMS)) {
                        this.mSerializers.addBeanFilters(RestServlet.this.getBeanFilters()).addPojoSwaps(RestServlet.this.getPojoSwaps());
                    }
                    if (si.contains((Object)Inherit.PROPERTIES)) {
                        this.mSerializers.setProperties(RestServlet.this.getProperties());
                    }
                }
                if (m.parsers().length > 0) {
                    this.mParsers.append(m.parsers());
                    if (pi.contains((Object)Inherit.TRANSFORMS)) {
                        this.mParsers.addBeanFilters(RestServlet.this.getBeanFilters()).addPojoSwaps(RestServlet.this.getPojoSwaps());
                    }
                    if (pi.contains((Object)Inherit.PROPERTIES)) {
                        this.mParsers.setProperties(RestServlet.this.getProperties());
                    }
                }
                if (m.properties().length > 0) {
                    this.mProperties = new ObjectMap().setInner(RestServlet.this.getProperties());
                    for (Property p1 : m.properties()) {
                        String n = p1.name();
                        String v = p1.value();
                        this.mProperties.put(n, v);
                        this.mSerializers.setProperty(n, v);
                        this.mParsers.setProperty(n, v);
                        this.mUrlEncodingParser.setProperty(n, v);
                    }
                }
                if (m.beanFilters().length > 0) {
                    this.mSerializers.addBeanFilters(m.beanFilters());
                    this.mParsers.addBeanFilters(m.beanFilters());
                    this.mUrlEncodingParser.addBeanFilters((Class[])m.beanFilters());
                }
                if (m.pojoSwaps().length > 0) {
                    this.mSerializers.addPojoSwaps(m.pojoSwaps());
                    this.mParsers.addPojoSwaps(m.pojoSwaps());
                    this.mUrlEncodingParser.addPojoSwaps((Class[])m.pojoSwaps());
                }
                if (m.encoders().length > 0 || !m.inheritEncoders()) {
                    EncoderGroup g = new EncoderGroup();
                    if (m.inheritEncoders()) {
                        g.append(this.mEncoders);
                    } else {
                        g.append(IdentityEncoder.INSTANCE);
                    }
                    for (Class<? extends Encoder> c : m.encoders()) {
                        try {
                            g.append(c);
                        }
                        catch (Exception e) {
                            throw new RestServletException("Exception occurred while trying to instantiate Encoder ''{0}''", c.getSimpleName()).initCause(e);
                        }
                    }
                    this.mEncoders = g;
                }
                this.mDefaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (String s : m.defaultRequestHeaders()) {
                    String[] h = RestServlet.this.parseHeader(s);
                    if (h == null) {
                        throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", s);
                    }
                    this.mDefaultRequestHeaders.put(h[0], h[1]);
                }
                this.mDefaultEncoding = this.mProperties.getString("RestServlet.defaultCharset", RestServlet.this.context.defaultCharset);
                String paramFormat = this.mProperties.getString("RestServlet.paramFormat", RestServlet.this.context.paramFormat);
                this.mPlainParams = paramFormat.equals("PLAIN");
                this.pathPattern = new UrlPathPattern(p);
                int attrIdx = 0;
                Type[] pt = method.getGenericParameterTypes();
                Annotation[][] pa = method.getParameterAnnotations();
                this.params = new MethodParam[pt.length];
                for (int i3 = 0; i3 < this.params.length; ++i3) {
                    this.params[i3] = new MethodParam(this, pt[i3], method, pa[i3]);
                    if (this.params[i3].paramType != ParamType.PATH || !this.params[i3].name.isEmpty()) continue;
                    if (this.pathPattern.vars.length <= attrIdx) {
                        throw new RestServletException("Number of attribute parameters in method ''{0}'' exceeds the number of URL pattern variables.", method.getName());
                    }
                    this.params[i3].name = this.pathPattern.vars[attrIdx++];
                }
                this.mSerializers.lock();
                this.mParsers.lock();
                this.mUrlEncodingParser.lock();
                method.setAccessible(true);
            }
            catch (Exception e) {
                throw new RestServletException("Exception occurred while initializing method ''{0}''", method.getName()).initCause(e);
            }
        }

        private Operation getSwaggerOperation(RestRequest req) throws ParseException {
            Operation o = Operation.create().setOperationId(this.method.getName()).setDescription(this.getDescription(req)).setTags(this.getTags(req)).setSummary(this.getSummary(req)).setExternalDocs(this.getExternalDocs(req)).setParameters(this.getParameters(req)).setResponses(this.getResponses(req));
            if (this.isDeprecated()) {
                o.setDeprecated(true);
            }
            if (!this.mParsers.getSupportedMediaTypes().equals(RestServlet.this.getParsers().getSupportedMediaTypes())) {
                o.setConsumes(this.mParsers.getSupportedMediaTypes());
            }
            if (!this.mSerializers.getSupportedMediaTypes().equals(RestServlet.this.getSerializers().getSupportedMediaTypes())) {
                o.setProduces(this.mSerializers.getSupportedMediaTypes());
            }
            return o;
        }

        private Operation getSwaggerOperationFromFile(RestRequest req) {
            Swagger s = req.getSwaggerFromFile();
            if (s != null && s.getPaths() != null && s.getPaths().get(this.pathPattern.patternString) != null) {
                return s.getPaths().get(this.pathPattern.patternString).get(this.httpMethod);
            }
            return null;
        }

        private String getDescription(RestRequest req) {
            VarResolverSession vr = req.getVarResolverSession();
            if (this.description != null) {
                return vr.resolve(this.description);
            }
            String description = RestServlet.this.msgs.findFirstString(req.getLocale(), this.method.getName() + ".description");
            if (description != null) {
                return vr.resolve(description);
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getDescription();
            }
            return null;
        }

        private List<String> getTags(RestRequest req) {
            VarResolverSession vr = req.getVarResolverSession();
            JsonParser jp = JsonParser.DEFAULT;
            try {
                if (this.tags != null) {
                    return jp.parseCollection(vr.resolve(this.tags), ArrayList.class, String.class);
                }
                String tags = RestServlet.this.msgs.findFirstString(req.getLocale(), this.method.getName() + ".tags");
                if (tags != null) {
                    return jp.parseCollection(vr.resolve(tags), ArrayList.class, String.class);
                }
                Operation o = this.getSwaggerOperationFromFile(req);
                if (o != null) {
                    return o.getTags();
                }
                return null;
            }
            catch (Exception e) {
                throw new RestException(500, (Throwable)e);
            }
        }

        private String getSummary(RestRequest req) {
            VarResolverSession vr = req.getVarResolverSession();
            if (this.summary != null) {
                return vr.resolve(this.summary);
            }
            String summary = RestServlet.this.msgs.findFirstString(req.getLocale(), this.method.getName() + ".summary");
            if (summary != null) {
                return vr.resolve(summary);
            }
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null) {
                return o.getSummary();
            }
            return null;
        }

        private ExternalDocumentation getExternalDocs(RestRequest req) {
            VarResolverSession vr = req.getVarResolverSession();
            JsonParser jp = JsonParser.DEFAULT;
            try {
                if (this.externalDocs != null) {
                    return jp.parse((Object)vr.resolve(this.externalDocs), ExternalDocumentation.class);
                }
                String externalDocs = RestServlet.this.msgs.findFirstString(req.getLocale(), this.method.getName() + ".externalDocs");
                if (externalDocs != null) {
                    return jp.parse((Object)vr.resolve(externalDocs), ExternalDocumentation.class);
                }
                Operation o = this.getSwaggerOperationFromFile(req);
                if (o != null) {
                    return o.getExternalDocs();
                }
                return null;
            }
            catch (Exception e) {
                throw new RestException(500, (Throwable)e);
            }
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }

        private List<ParameterInfo> getParameters(RestRequest req) throws ParseException {
            String in;
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null && o.getParameters() != null) {
                return o.getParameters();
            }
            VarResolverSession vr = req.getVarResolverSession();
            JsonParser jp = JsonParser.DEFAULT;
            TreeMap<String, ParameterInfo> m = new TreeMap<String, ParameterInfo>();
            for (Parameter v : this.parameters) {
                String in2 = vr.resolve(v.in());
                ParameterInfo p = ParameterInfo.createStrict(in2, vr.resolve(v.name()));
                if (!v.description().isEmpty()) {
                    p.setDescription(vr.resolve(v.description()));
                }
                if (v.required()) {
                    p.setRequired(v.required());
                }
                if ("body".equals(in2)) {
                    if (!v.schema().isEmpty()) {
                        p.setSchema(jp.parse((Object)vr.resolve(v.schema()), SchemaInfo.class));
                    }
                } else {
                    if (v.allowEmptyValue()) {
                        p.setAllowEmptyValue(v.allowEmptyValue());
                    }
                    if (!v.collectionFormat().isEmpty()) {
                        p.setCollectionFormat(vr.resolve(v.collectionFormat()));
                    }
                    if (!v._default().isEmpty()) {
                        p.setDefault(vr.resolve(v._default()));
                    }
                    if (!v.format().isEmpty()) {
                        p.setFormat(vr.resolve(v.format()));
                    }
                    if (!v.items().isEmpty()) {
                        p.setItems(jp.parse((Object)vr.resolve(v.items()), Items.class));
                    }
                    p.setType(vr.resolve(v.type()));
                }
                m.put(p.getIn() + '.' + p.getName(), p);
            }
            String prefix = this.method.getName() + ".req";
            for (String key : RestServlet.this.msgs.keySet(prefix)) {
                boolean isBody;
                if (key.length() <= prefix.length()) continue;
                String value = vr.resolve(RestServlet.this.msgs.getString(key));
                String[] parts = key.substring(prefix.length() + 1).split("\\.");
                if (parts.length == ((isBody = "body".equals(in = parts[0])) ? 2 : 3)) {
                    String field;
                    String name;
                    if ("body".equals(in)) {
                        name = null;
                        field = parts[1];
                    } else {
                        name = parts[1];
                        field = parts[2];
                    }
                    String k2 = in + '.' + name;
                    ParameterInfo p = (ParameterInfo)m.get(k2);
                    if (p == null) {
                        p = ParameterInfo.createStrict(in, name);
                        m.put(k2, p);
                    }
                    if (field.equals("description")) {
                        p.setDescription(value);
                    } else if (field.equals("required")) {
                        p.setRequired(Boolean.valueOf(value));
                    }
                    if ("body".equals(in)) {
                        if (!field.equals("schema")) continue;
                        p.setSchema(jp.parse((Object)value, SchemaInfo.class));
                        continue;
                    }
                    if (field.equals("allowEmptyValue")) {
                        p.setAllowEmptyValue(Boolean.valueOf(value));
                        continue;
                    }
                    if (field.equals("collectionFormat")) {
                        p.setCollectionFormat(value);
                        continue;
                    }
                    if (field.equals("default")) {
                        p.setDefault(value);
                        continue;
                    }
                    if (field.equals("format")) {
                        p.setFormat(value);
                        continue;
                    }
                    if (field.equals("items")) {
                        p.setItems(jp.parse((Object)value, Items.class));
                        continue;
                    }
                    if (!field.equals("type")) continue;
                    p.setType(value);
                    continue;
                }
                System.err.println("Unknown bundle key '" + key + "'");
            }
            for (MethodParam mp : this.params) {
                String k2;
                ParameterInfo p;
                in = mp.paramType.getSwaggerParameterType();
                if (in == null || (p = (ParameterInfo)m.get(k2 = in + '.' + ("body".equals(in) ? null : mp.name))) != null) continue;
                p = ParameterInfo.createStrict(in, mp.name);
                m.put(k2, p);
            }
            if (m.isEmpty()) {
                return null;
            }
            return new ArrayList<ParameterInfo>(m.values());
        }

        private Map<String, ResponseInfo> getResponses(RestRequest req) throws ParseException {
            HeaderInfo h;
            ResponseInfo r2;
            Operation o = this.getSwaggerOperationFromFile(req);
            if (o != null && o.getResponses() != null) {
                return o.getResponses();
            }
            VarResolverSession vr = req.getVarResolverSession();
            JsonParser jp = JsonParser.DEFAULT;
            TreeMap<String, ResponseInfo> m = new TreeMap<String, ResponseInfo>();
            TreeMap<String, HeaderInfo> m2 = new TreeMap<String, HeaderInfo>();
            for (Response r : this.responses) {
                String httpCode = String.valueOf(r.value());
                String description = r.description().isEmpty() ? RestUtils.getHttpResponseText(r.value()) : vr.resolve(r.description());
                r2 = ResponseInfo.create(description);
                if (r.headers().length > 0) {
                    for (Parameter v : r.headers()) {
                        h = HeaderInfo.createStrict(vr.resolve(v.type()));
                        if (!v.collectionFormat().isEmpty()) {
                            h.setCollectionFormat(vr.resolve(v.collectionFormat()));
                        }
                        if (!v._default().isEmpty()) {
                            h.setDefault(vr.resolve(v._default()));
                        }
                        if (!v.description().isEmpty()) {
                            h.setDescription(vr.resolve(v.description()));
                        }
                        if (!v.format().isEmpty()) {
                            h.setFormat(vr.resolve(v.format()));
                        }
                        if (!v.items().isEmpty()) {
                            h.setItems(jp.parse((Object)vr.resolve(v.items()), Items.class));
                        }
                        r2.addHeader(v.name(), h);
                        m2.put(httpCode + '.' + v.name(), h);
                    }
                }
                m.put(httpCode, r2);
            }
            String prefix = this.method.getName() + ".res";
            for (String key : RestServlet.this.msgs.keySet(prefix)) {
                String name;
                if (key.length() <= prefix.length()) continue;
                String value = vr.resolve(RestServlet.this.msgs.getString(key));
                String[] parts = key.substring(prefix.length() + 1).split("\\.");
                String httpCode = parts[0];
                r2 = (ResponseInfo)m.get(httpCode);
                if (r2 == null) {
                    r2 = ResponseInfo.create(null);
                    m.put(httpCode, r2);
                }
                String string = name = parts.length > 1 ? parts[1] : "";
                if ("header".equals(name) && parts.length > 3) {
                    String headerName = parts[2];
                    String field = parts[3];
                    String k2 = httpCode + '.' + headerName;
                    h = (HeaderInfo)m2.get(k2);
                    if (h == null) {
                        h = HeaderInfo.createStrict("string");
                        m2.put(k2, h);
                        r2.addHeader(name, h);
                    }
                    if (field.equals("collectionFormat")) {
                        h.setCollectionFormat(value);
                        continue;
                    }
                    if (field.equals("default")) {
                        h.setDefault(value);
                        continue;
                    }
                    if (field.equals("description")) {
                        h.setDescription(value);
                        continue;
                    }
                    if (field.equals("format")) {
                        h.setFormat(value);
                        continue;
                    }
                    if (field.equals("items")) {
                        h.setItems(jp.parse((Object)value, Items.class));
                        continue;
                    }
                    if (!field.equals("type")) continue;
                    h.setType(value);
                    continue;
                }
                if ("description".equals(name)) {
                    r2.setDescription(value);
                    continue;
                }
                if ("schema".equals(name)) {
                    r2.setSchema(jp.parse((Object)value, SchemaInfo.class));
                    continue;
                }
                if ("examples".equals(name)) {
                    r2.setExamples(jp.parseMap(value, TreeMap.class, String.class, Object.class));
                    continue;
                }
                System.err.println("Unknown bundle key '" + key + "'");
            }
            return m.isEmpty() ? null : m;
        }

        private boolean isRequestAllowed(RestRequest req) {
            for (RestGuard guard : this.guards) {
                req.javaMethod = this.method;
                if (guard.isRequestAllowed(req)) continue;
                return false;
            }
            return true;
        }

        @Override
        int invoke(String methodName, String pathInfo, RestServlet resource, RestRequest req, RestResponse res) throws RestException {
            String[] patternVals = this.pathPattern.match(pathInfo);
            if (patternVals == null) {
                return 404;
            }
            String remainder = null;
            if (patternVals.length > this.pathPattern.vars.length) {
                remainder = patternVals[this.pathPattern.vars.length];
            }
            for (int i = 0; i < this.pathPattern.vars.length; ++i) {
                req.setPathParameter(this.pathPattern.vars[i], patternVals[i]);
            }
            req.init(this.method, remainder, RestServlet.this.createRequestProperties(this.mProperties, req), this.mDefaultRequestHeaders, this.mDefaultEncoding, this.mSerializers, this.mParsers, this.mUrlEncodingParser);
            res.init(req.getProperties(), this.mDefaultEncoding, this.mSerializers, this.mUrlEncodingSerializer, this.mEncoders);
            for (RestGuard guard : RestServlet.this.getGuards()) {
                if (guard.guard(req, res)) continue;
                return 401;
            }
            for (RestMatcher m : this.requiredMatchers) {
                if (m.matches(req)) continue;
                return 412;
            }
            if (this.optionalMatchers.length > 0) {
                boolean matches = false;
                for (RestMatcher m : this.optionalMatchers) {
                    matches |= m.matches(req);
                }
                if (!matches) {
                    return 412;
                }
            }
            RestServlet.this.onPreCall(req);
            Object[] args = new Object[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                try {
                    args[i] = this.params[i].getValue(req, res);
                    continue;
                }
                catch (RestException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RestException(400, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.params[i].paramType.name(), this.params[i].name, this.params[i].type, this.method.getDeclaringClass().getName(), this.method.getName()).initCause(e);
                }
            }
            try {
                for (RestGuard guard : this.guards) {
                    if (guard.guard(req, res)) continue;
                    return 200;
                }
                Object output = this.method.invoke((Object)resource, args);
                if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                    res.setOutput(output);
                }
                RestServlet.this.onPostCall(req, res);
                if (res.hasOutput()) {
                    output = res.getOutput();
                    for (RestConverter converter : this.mConverters) {
                        output = converter.convert(req, output, RestServlet.this.getBeanContext().getClassMetaForObject(output));
                    }
                    res.setOutput(output);
                }
            }
            catch (IllegalArgumentException e) {
                throw new RestException(400, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", this.method.toString(), ClassUtils.getReadableClassNames(args));
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                if (e2 instanceof RestException) {
                    throw (RestException)e2;
                }
                if (e2 instanceof ParseException) {
                    throw new RestException(400, e2);
                }
                if (e2 instanceof InvalidDataConversionException) {
                    throw new RestException(400, e2);
                }
                throw new RestException(500, e2);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(500, (Throwable)e);
            }
            return 200;
        }

        public String toString() {
            return "SimpleMethod: name=" + this.httpMethod + ", path=" + this.pathPattern.patternString;
        }

        @Override
        public int compareTo(MethodMeta o) {
            int c = this.priority.compareTo(o.priority);
            if (c != 0) {
                return c;
            }
            c = this.pathPattern.compareTo(o.pathPattern);
            if (c != 0) {
                return c;
            }
            c = Utils.compare(o.requiredMatchers.length, this.requiredMatchers.length);
            if (c != 0) {
                return c;
            }
            c = Utils.compare(o.optionalMatchers.length, this.optionalMatchers.length);
            if (c != 0) {
                return c;
            }
            c = Utils.compare(o.guards.length, this.guards.length);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodMeta)) {
                return false;
            }
            return this.compareTo((MethodMeta)o) == 0;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    static class MethodParam {
        ParamType paramType;
        Type type;
        String name = "";
        boolean multiPart;
        boolean plainParams;

        MethodParam(MethodMeta mm, Type type, java.lang.reflect.Method method, Annotation[] annotations) throws ServletException {
            this.type = type;
            boolean isClass = type instanceof Class;
            if (isClass && ClassUtils.isParentClass(HttpServletRequest.class, (Class)type)) {
                this.paramType = ParamType.REQ;
            } else if (isClass && ClassUtils.isParentClass(HttpServletResponse.class, (Class)type)) {
                this.paramType = ParamType.RES;
            } else {
                for (Annotation a : annotations) {
                    Annotation p;
                    if (a instanceof Path) {
                        Path a2 = (Path)a;
                        this.paramType = ParamType.PATH;
                        this.name = a2.value();
                        continue;
                    }
                    if (a instanceof Header) {
                        Header h = (Header)a;
                        this.paramType = ParamType.HEADER;
                        this.name = h.value();
                        continue;
                    }
                    if (a instanceof FormData) {
                        p = (FormData)a;
                        if (p.multipart()) {
                            this.assertCollection(type, method);
                        }
                        this.paramType = ParamType.FORMDATA;
                        this.multiPart = p.multipart();
                        this.plainParams = p.format().equals("INHERIT") ? mm.mPlainParams : p.format().equals("PLAIN");
                        this.name = p.value();
                        continue;
                    }
                    if (a instanceof Query) {
                        p = (Query)a;
                        if (p.multipart()) {
                            this.assertCollection(type, method);
                        }
                        this.paramType = ParamType.QUERY;
                        this.multiPart = p.multipart();
                        this.plainParams = p.format().equals("INHERIT") ? mm.mPlainParams : p.format().equals("PLAIN");
                        this.name = p.value();
                        continue;
                    }
                    if (a instanceof HasFormData) {
                        p = (HasFormData)a;
                        this.paramType = ParamType.HASFORMDATA;
                        this.name = p.value();
                        continue;
                    }
                    if (a instanceof HasQuery) {
                        p = (HasQuery)a;
                        this.paramType = ParamType.HASQUERY;
                        this.name = p.value();
                        continue;
                    }
                    if (a instanceof Body) {
                        this.paramType = ParamType.BODY;
                        continue;
                    }
                    if (a instanceof Method) {
                        this.paramType = ParamType.METHOD;
                        if (type == String.class) continue;
                        throw new ServletException("@Method parameters must be of type String");
                    }
                    if (a instanceof PathRemainder) {
                        this.paramType = ParamType.PATHREMAINDER;
                        if (type == String.class) continue;
                        throw new ServletException("@PathRemainder parameters must be of type String");
                    }
                    if (a instanceof Properties) {
                        this.paramType = ParamType.PROPS;
                        this.name = "PROPERTIES";
                        continue;
                    }
                    if (!(a instanceof Messages)) continue;
                    this.paramType = ParamType.MESSAGES;
                    this.name = "MESSAGES";
                }
            }
            if (this.paramType == null) {
                this.paramType = ParamType.PATH;
            }
        }

        private void assertCollection(Type t, java.lang.reflect.Method m) throws ServletException {
            ClassMeta cm = BeanContext.DEFAULT.getClassMeta(t);
            if (!cm.isArray() && !cm.isCollection()) {
                throw new ServletException("Use of multipart flag on parameter that's not an array or Collection on method" + m);
            }
        }

        private Object getValue(RestRequest req, RestResponse res) throws Exception {
            BeanContext bc = req.getServlet().getBeanContext();
            switch (this.paramType) {
                case REQ: {
                    return req;
                }
                case RES: {
                    return res;
                }
                case PATH: {
                    return req.getPathParameter(this.name, this.type);
                }
                case BODY: {
                    return req.getBody(this.type);
                }
                case HEADER: {
                    return req.getHeader(this.name, this.type);
                }
                case METHOD: {
                    return req.getMethod();
                }
                case FORMDATA: {
                    if (this.multiPart) {
                        return req.getFormDataParameters(this.name, this.type);
                    }
                    if (this.plainParams) {
                        return bc.convertToType((Object)req.getFormDataParameter(this.name), bc.getClassMeta(this.type));
                    }
                    return req.getFormDataParameter(this.name, this.type);
                }
                case QUERY: {
                    if (this.multiPart) {
                        return req.getQueryParameters(this.name, this.type);
                    }
                    if (this.plainParams) {
                        return bc.convertToType((Object)req.getQueryParameter(this.name), bc.getClassMeta(this.type));
                    }
                    return req.getQueryParameter(this.name, this.type);
                }
                case HASFORMDATA: {
                    return bc.convertToType((Object)req.hasFormDataParameter(this.name), bc.getClassMeta(this.type));
                }
                case HASQUERY: {
                    return bc.convertToType((Object)req.hasQueryParameter(this.name), bc.getClassMeta(this.type));
                }
                case PATHREMAINDER: {
                    return req.getPathRemainder();
                }
                case PROPS: {
                    return res.getProperties();
                }
                case MESSAGES: {
                    return req.getResourceBundle();
                }
            }
            return null;
        }
    }

    static enum ParamType {
        REQ,
        RES,
        PATH,
        BODY,
        HEADER,
        METHOD,
        FORMDATA,
        QUERY,
        HASFORMDATA,
        HASQUERY,
        PATHREMAINDER,
        PROPS,
        MESSAGES;


        boolean isOneOf(ParamType ... pt) {
            for (ParamType ptt : pt) {
                if (this != ptt) continue;
                return true;
            }
            return false;
        }

        public String getSwaggerParameterType() {
            switch (this) {
                case PATH: {
                    return "path";
                }
                case HEADER: {
                    return "header";
                }
                case FORMDATA: {
                    return "formData";
                }
                case QUERY: {
                    return "query";
                }
                case BODY: {
                    return "body";
                }
            }
            return null;
        }
    }

    private abstract class ResourceMethod {
        private ResourceMethod() {
        }

        abstract int invoke(String var1, String var2, RestServlet var3, RestRequest var4, RestResponse var5) throws RestException;

        void complete() {
        }
    }
}

