/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestServlet;
import org.apache.juneau.server.RestServletException;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public final class RestResponse
extends HttpServletResponseWrapper {
    private final RestRequest request;
    private Object output;
    private boolean isNullOutput;
    private ObjectMap properties;
    SerializerGroup serializerGroup;
    UrlEncodingSerializer urlEncodingSerializer;
    private EncoderGroup encoders;
    private RestServlet servlet;
    private ServletOutputStream os;

    RestResponse(RestServlet servlet, RestRequest req, HttpServletResponse res) {
        super(res);
        this.request = req;
        this.servlet = servlet;
        for (Map.Entry<String, Object> e : servlet.getDefaultResponseHeaders().entrySet()) {
            this.setHeader(e.getKey(), e.getValue().toString());
        }
        try {
            String passThroughHeaders = req.getHeader("x-response-headers");
            if (passThroughHeaders != null) {
                ObjectMap m = servlet.getUrlEncodingParser().parseParameter((CharSequence)passThroughHeaders, ObjectMap.class);
                for (Map.Entry<String, Object> e : m.entrySet()) {
                    this.setHeader(e.getKey(), e.getValue().toString());
                }
            }
        }
        catch (Exception e1) {
            throw new RestException(400, "Invalid format for header 'x-response-headers'.  Must be in URL-encoded format.", new Object[0]).initCause(e1);
        }
    }

    final void init(ObjectMap properties, String defaultCharset, SerializerGroup mSerializers, UrlEncodingSerializer mUrlEncodingSerializer, EncoderGroup encoders) {
        this.properties = properties;
        this.serializerGroup = mSerializers;
        this.urlEncodingSerializer = mUrlEncodingSerializer;
        this.encoders = encoders;
        String h = this.request.getHeader("accept-charset");
        String charset = null;
        if (h == null) {
            charset = defaultCharset;
        } else {
            for (MediaRange r : MediaRange.parse(h)) {
                if (!(r.getQValue().floatValue() > 0.0f)) continue;
                if (r.getType().equals("*")) {
                    charset = defaultCharset;
                } else if (RestServlet.availableCharsets.containsKey(r.getType())) {
                    charset = r.getType();
                }
                if (charset != null) break;
            }
        }
        if (charset == null) {
            throw new RestException(406, "No supported charsets in header ''Accept-Charset'': ''{0}''", this.request.getHeader("Accept-Charset"));
        }
        super.setCharacterEncoding(charset);
    }

    public SerializerGroup getSerializerGroup() {
        return this.serializerGroup;
    }

    public List<String> getSupportedMediaTypes() {
        return this.serializerGroup.getSupportedMediaTypes();
    }

    public List<String> getSupportedEncodings() throws RestServletException {
        return this.servlet.getEncoders().getSupportedEncodings();
    }

    public RestResponse setOutput(Object output) {
        this.output = output;
        this.isNullOutput = output == null;
        return this;
    }

    public RestResponse setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public RestResponse setOutputs(Object ... output) {
        this.output = output;
        return this;
    }

    public Object getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null || this.isNullOutput;
    }

    public RestResponse sendPlainText(String text) throws IOException {
        this.setContentType("text/plain");
        this.getNegotiatedWriter().write(text);
        return this;
    }

    public ServletOutputStream getNegotiatedOutputStream() throws IOException {
        if (this.os == null) {
            Encoder encoder = null;
            String ae = this.request.getHeader("Accept-Encoding");
            if (ae != null && !ae.isEmpty()) {
                String match;
                String string = match = this.encoders != null ? this.encoders.findMatch(ae) : null;
                if (match == null) {
                    if (ae.matches(".*(identity|\\*)\\s*;\\s*q\\s*=\\s*(0(?!\\.)|0\\.0).*")) {
                        throw new RestException(406, "Unsupported encoding in request header ''Accept-Encoding'': ''{0}''\n\tSupported codings: {1}", ae, this.encoders.getSupportedEncodings());
                    }
                } else {
                    encoder = this.encoders.getEncoder(match);
                    if (!match.equals("identity")) {
                        this.setHeader("content-encoding", match);
                    }
                }
            }
            this.os = this.getOutputStream();
            if (encoder != null) {
                final OutputStream os2 = encoder.getOutputStream((OutputStream)this.os);
                this.os = new ServletOutputStream(){

                    public final void write(byte[] b, int off, int len) throws IOException {
                        os2.write(b, off, len);
                    }

                    public final void write(int b) throws IOException {
                        os2.write(b);
                    }

                    public final void flush() throws IOException {
                        os2.flush();
                    }

                    public final void close() throws IOException {
                        os2.close();
                    }
                };
            }
        }
        return this.os;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = super.getOutputStream();
        }
        return this.os;
    }

    public boolean getOutputStreamCalled() {
        return this.os != null;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(true);
    }

    public PrintWriter getDirectWriter(String contentType) throws IOException {
        this.setContentType(contentType);
        this.setHeader("x-content-type-options", "nosniff");
        return this.getWriter();
    }

    public PrintWriter getNegotiatedWriter() throws IOException {
        return this.getWriter(false);
    }

    private PrintWriter getWriter(boolean raw) throws IOException {
        if (this.request.isPlainText()) {
            this.setHeader("Content-Type", "text/plain");
        }
        try {
            ServletOutputStream out = raw ? this.getOutputStream() : this.getNegotiatedOutputStream();
            return new PrintWriter(new OutputStreamWriter((OutputStream)out, this.getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            String ce = this.getCharacterEncoding();
            this.setCharacterEncoding("UTF-8");
            throw new RestException(406, "Unsupported charset in request header ''Accept-Charset'': ''{0}''", ce);
        }
    }

    public String getMediaType() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        int i = contentType.indexOf(59);
        if (i == -1) {
            return contentType;
        }
        return contentType.substring(0, i).trim();
    }

    public void sendRedirect(String uri) throws IOException {
        char c;
        char c2 = c = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (c != '/' && uri.indexOf("://") == -1) {
            uri = this.request.getContextPath() + '/' + uri;
        }
        super.sendRedirect(uri);
    }

    public UrlEncodingSerializer getUrlEncodingSerializer() {
        return this.urlEncodingSerializer;
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            super.setContentType(value);
        } else {
            super.setHeader(name, value);
        }
    }
}

