/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CharSequenceReader;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.server.ReaderResource;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestServlet;
import org.apache.juneau.server.RestUtils;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.MessageBundle;

public final class RestRequest
extends HttpServletRequestWrapper {
    private final RestServlet servlet;
    private String method;
    private String pathRemainder;
    private String body;
    Method javaMethod;
    private ObjectMap properties;
    private SerializerGroup serializerGroup;
    private ParserGroup parserGroup;
    private Encoder encoder;
    private int contentLength;
    private final boolean debug;
    private UrlEncodingParser urlEncodingParser;
    private BeanContext beanContext;
    private VarResolverSession varSession;
    private Map<String, String[]> queryParams;
    private Map<String, String> defaultServletHeaders;
    private Map<String, String> defaultMethodHeaders;
    private Map<String, String> overriddenHeaders;
    private Map<String, String> overriddenQueryParams;
    private Map<String, String> overriddenFormDataParams;
    private Map<String, String> pathParameters;
    private boolean isPost;
    private String servletURI;
    private String relativeServletURI;
    private String charset;
    private String defaultCharset;
    private ObjectMap headers;
    private ConfigFile cf;
    private Swagger swagger;
    private Swagger fileSwagger;

    RestRequest(RestServlet servlet, HttpServletRequest req) throws ServletException {
        super(req);
        try {
            this.servlet = servlet;
            this.isPost = req.getMethod().equalsIgnoreCase("POST");
            this.queryParams = this.isPost ? servlet.getUrlEncodingParser().parseIntoSimpleMap(this.getQueryString()) : req.getParameterMap();
            this.method = super.getMethod();
            String m = this.getQueryParameter("method");
            if (!StringUtils.isEmpty(m) && (servlet.context.allowMethodParams.contains(m) || servlet.context.allowMethodParams.contains("*"))) {
                this.method = m;
            }
            if (servlet.context.allowBodyParam) {
                this.body = this.getQueryParameter("body");
            }
            this.defaultServletHeaders = servlet.getDefaultRequestHeaders();
            this.debug = "true".equals(this.getQueryParameter("debug", "false"));
            if (this.debug) {
                servlet.log(Level.INFO, this.toString(), new Object[0]);
            }
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    final void init(Method javaMethod, String pathRemainder, ObjectMap properties, Map<String, String> mDefaultRequestHeaders, String defaultCharset, SerializerGroup mSerializers, ParserGroup mParsers, UrlEncodingParser mUrlEncodingParser) {
        this.javaMethod = javaMethod;
        this.pathRemainder = pathRemainder;
        this.properties = properties;
        this.defaultMethodHeaders = mDefaultRequestHeaders;
        this.serializerGroup = mSerializers;
        this.parserGroup = mParsers;
        this.urlEncodingParser = mUrlEncodingParser;
        this.beanContext = this.urlEncodingParser.getBeanContext();
        this.defaultCharset = defaultCharset;
    }

    public String getDescription() {
        String qs = this.getQueryString();
        return "HTTP " + this.getMethod() + " " + this.getRequestURI() + (qs == null ? "" : "?" + qs);
    }

    RestRequest setProperties(ObjectMap properties) {
        this.properties = properties;
        return this;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public void setHeader(String name, String value) {
        if (this.overriddenHeaders == null) {
            this.overriddenHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenHeaders.put(name, value);
    }

    public String getHeader(String name) {
        return this.getHeader(name, (String)null);
    }

    public String getHeader(String name, String def) {
        String h = this.getOverriddenHeader(name);
        if (h != null) {
            return h;
        }
        h = super.getHeader(name);
        if (h != null && !h.isEmpty()) {
            return h;
        }
        if (this.defaultMethodHeaders != null && (h = this.defaultMethodHeaders.get(name)) != null) {
            return h;
        }
        h = this.defaultServletHeaders.get(name);
        if (h != null) {
            return h;
        }
        return def;
    }

    public <T> T getHeader(String name, Class<T> c, T def) {
        String h = this.getHeader(name);
        if (h == null) {
            return def;
        }
        return this.beanContext.convertToType((Object)h, c);
    }

    public <T> T getHeader(String name, Class<T> c) {
        String h = this.getHeader(name);
        return this.beanContext.convertToType((Object)h, c);
    }

    public <T> T getHeader(String name, Type c) {
        String h = this.getHeader(name);
        return this.beanContext.convertToType(null, (Object)h, this.beanContext.getClassMeta(c));
    }

    public ObjectMap getHeaders() {
        if (this.headers == null) {
            this.headers = new ObjectMap();
            Enumeration e = this.getHeaderNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.headers.put(key, this.getHeader(key));
            }
        }
        return this.headers;
    }

    public Enumeration<String> getHeaders(String name) {
        String h = this.getOverriddenHeader(name);
        if (h != null) {
            return Collections.enumeration(Collections.singleton(h));
        }
        return super.getHeaders(name);
    }

    public String getMediaType() {
        String cm = this.getHeader("Content-Type");
        if (cm == null) {
            if (this.body != null) {
                return "text/uon";
            }
            return "text/json";
        }
        int j = cm.indexOf(59);
        if (j != -1) {
            cm = cm.substring(0, j);
        }
        return cm;
    }

    public List<String> getSupportedMediaTypes() {
        return this.parserGroup.getSupportedMediaTypes();
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            int i;
            String h = this.getHeader("Content-Type");
            if (h != null && (i = h.indexOf(";charset=")) > 0) {
                this.charset = h.substring(i + 9).trim();
            }
            if (this.charset == null) {
                this.charset = this.defaultCharset;
            }
            if (!RestServlet.availableCharsets.containsKey(this.charset)) {
                throw new RestException(415, "Unsupported charset in header ''Content-Type'': ''{0}''", h);
            }
        }
        return this.charset;
    }

    public Locale getLocale() {
        MediaRange[] mr;
        String h = this.getOverriddenHeader("Accept-Language");
        if (h != null && (mr = MediaRange.parse(h)).length > 0) {
            return this.toLocale(mr[0].getType());
        }
        return super.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        MediaRange[] mr;
        String h = this.getOverriddenHeader("Accept-Language");
        if (h != null && (mr = MediaRange.parse(h)).length > 0) {
            ArrayList<Locale> l = new ArrayList<Locale>(mr.length);
            for (MediaRange r : mr) {
                l.add(this.toLocale(r.getType()));
            }
            return Collections.enumeration(l);
        }
        return super.getLocales();
    }

    public void setQueryParameter(String name, Object value) {
        if (this.overriddenQueryParams == null) {
            this.overriddenQueryParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenQueryParams.put(name, value == null ? null : value.toString());
    }

    public String getQueryParameter(String name) {
        String s = null;
        if (this.overriddenQueryParams != null) {
            s = this.overriddenQueryParams.get(name);
        }
        if (s != null) {
            return s;
        }
        String[] v = this.queryParams.get(name);
        if (v == null || v.length == 0) {
            return null;
        }
        if (v.length == 1 && v[0] != null && v[0].isEmpty() && this.queryParams.containsKey(name)) {
            return null;
        }
        return v[0];
    }

    public String getQueryParameter(String name, String def) {
        String s = this.getQueryParameter(name);
        return s == null ? def : s;
    }

    public <T> T getQueryParameter(String name, Class<T> c, T def) throws ParseException {
        return this.getQueryParameter(name, this.beanContext.getClassMeta(c), def);
    }

    public <T> T getQueryParameter(String name, ClassMeta<T> cm, T def) throws ParseException {
        String val = this.getQueryParameter(name);
        if (val == null) {
            return def;
        }
        return this.parseParameter(val, cm);
    }

    public <T> T getQueryParameter(String name, Class<T> c) throws ParseException {
        return this.getQueryParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getQueryParameters(String name, Class<T> c) throws ParseException {
        return this.getQueryParameters(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getQueryParameter(String name, Type c) throws ParseException {
        return this.getQueryParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getQueryParameters(String name, Type c) throws ParseException {
        return this.getQueryParameters(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getQueryParameter(String name, ClassMeta<T> cm) throws ParseException {
        String val = this.getQueryParameter(name);
        if (cm.isPrimitive() && (val == null || val.isEmpty())) {
            return cm.getPrimitiveDefault();
        }
        return this.parseParameter(val, cm);
    }

    public <T> T getQueryParameters(String name, ClassMeta<T> cm) throws ParseException {
        String[] p = this.getQueryParameters(name);
        if (p == null) {
            return null;
        }
        if (cm.isArray()) {
            ArrayList c = new ArrayList();
            for (int i = 0; i < p.length; ++i) {
                c.add(this.parseParameter(p[i], cm.getElementType()));
            }
            return (T)ArrayUtils.toArray(c, cm.getElementType().getInnerClass());
        }
        if (cm.isCollection()) {
            try {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parseParameter(p[i], cm.getElementType()));
                }
                return (T)c;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Invalid call to getQueryParameters(String, ClassMeta).  Class type must be a Collection or array.", new Object[0]);
    }

    public String[] getQueryParameters(String name) {
        return this.queryParams.get(name);
    }

    public boolean hasQueryParameter(String name) {
        return this.queryParams.containsKey(name);
    }

    public boolean hasAnyQueryParameters(String ... params) {
        for (String p : params) {
            if (!this.hasQueryParameter(p)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String[]> getQueryParameterMap() {
        return this.queryParams;
    }

    public Iterator<String> getQueryParameterNames() {
        return this.queryParams.keySet().iterator();
    }

    public void setFormDataParameter(String name, Object value) {
        if (this.overriddenFormDataParams == null) {
            this.overriddenFormDataParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.overriddenFormDataParams.put(name, value == null ? null : value.toString());
    }

    public String getFormDataParameter(String name) {
        String s = null;
        if (this.overriddenFormDataParams != null) {
            s = this.overriddenFormDataParams.get(name);
        }
        if (s != null) {
            return s;
        }
        return super.getParameter(name);
    }

    public String getFormDataParameter(String name, String def) {
        String val = this.getParameter(name);
        if (val == null || val.isEmpty()) {
            return def;
        }
        return val;
    }

    public <T> T getFormDataParameter(String name, Class<T> c, T def) throws ParseException {
        return this.getFormDataParameter(name, this.beanContext.getClassMeta(c), def);
    }

    public <T> T getFormDataParameter(String name, ClassMeta<T> cm, T def) throws ParseException {
        String val = this.getParameter(name);
        if (val == null) {
            return def;
        }
        return this.parseParameter(val, cm);
    }

    public <T> T getFormDataParameter(String name, Class<T> c) throws ParseException {
        return this.getFormDataParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getFormDataParameters(String name, Class<T> c) throws ParseException {
        return this.getFormDataParameters(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getFormDataParameter(String name, Type c) throws ParseException {
        return this.getFormDataParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getFormDataParameters(String name, Type c) throws ParseException {
        return this.getFormDataParameters(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getFormDataParameter(String name, ClassMeta<T> cm) throws ParseException {
        String val = this.getParameter(name);
        if (cm.isPrimitive() && (val == null || val.isEmpty())) {
            return cm.getPrimitiveDefault();
        }
        return this.parseParameter(val, cm);
    }

    public <T> T getFormDataParameters(String name, ClassMeta<T> cm) throws ParseException {
        String[] p = this.getParameterValues(name);
        if (p == null) {
            return null;
        }
        if (cm.isArray()) {
            ArrayList c = new ArrayList();
            for (int i = 0; i < p.length; ++i) {
                c.add(this.parseParameter(p[i], cm.getElementType()));
            }
            return (T)ArrayUtils.toArray(c, cm.getElementType().getInnerClass());
        }
        if (cm.isCollection()) {
            try {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parseParameter(p[i], cm.getElementType()));
                }
                return (T)c;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Invalid call to getParameters(String, ClassMeta).  Class type must be a Collection or array.", new Object[0]);
    }

    public boolean hasFormDataParameter(String name) {
        return this.getParameterMap().containsKey(name);
    }

    public void setPathParameter(String name, String value) {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.pathParameters.put(name, value == null ? null : value.toString());
    }

    public String getPathParameter(String name) {
        return this.pathParameters == null ? null : this.pathParameters.get(name);
    }

    public <T> T getPathParameter(String name, Class<T> c) throws ParseException {
        return this.getPathParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getPathParameter(String name, Type c) throws ParseException {
        return this.getPathParameter(name, this.beanContext.getClassMeta(c));
    }

    public <T> T getPathParameter(String name, ClassMeta<T> cm) throws ParseException {
        String attr = this.getPathParameter(name);
        T t = null;
        if (attr != null) {
            t = this.urlEncodingParser.parseParameter((CharSequence)attr.toString(), cm);
        }
        if (t == null && cm.isPrimitive()) {
            return cm.getPrimitiveDefault();
        }
        return t;
    }

    public <T> T getBody(Class<T> type) throws IOException, ParseException {
        return this.getBody(this.beanContext.getClassMeta(type));
    }

    public <T> T getBody(Type type) {
        return this.getBody(this.beanContext.getClassMeta(type));
    }

    public <T> T getBody(ClassMeta<T> type) throws RestException {
        try {
            if (type.isReader()) {
                return (T)this.getReader();
            }
            if (type.isInputStream()) {
                return (T)this.getInputStream();
            }
            String mediaType = this.getMediaType();
            Parser p = this.getParser();
            if (p != null) {
                try {
                    this.properties.append("mediaType", mediaType).append("characterEncoding", this.getCharacterEncoding());
                    if (!p.isReaderParser()) {
                        InputStreamParser p2 = (InputStreamParser)p;
                        ParserSession session = p2.createSession(this.getInputStream(), this.properties, this.getJavaMethod(), (Object)this.getServlet());
                        return p2.parse(session, type);
                    }
                    ReaderParser p2 = (ReaderParser)p;
                    ParserSession session = p2.createSession(this.getUnbufferedReader(), this.properties, this.getJavaMethod(), (Object)this.getServlet());
                    return p2.parse(session, type);
                }
                catch (ParseException e) {
                    throw new RestException(400, "Could not convert request body content to class type ''{0}'' using parser ''{1}''.", type, p.getClass().getName()).initCause(e);
                }
            }
            throw new RestException(415, "Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", this.getHeader("Content-Type"), this.parserGroup.getSupportedMediaTypes());
        }
        catch (IOException e) {
            throw new RestException(500, "I/O exception occurred while attempting to handle request ''{0}''.", this.getDescription()).initCause(e);
        }
    }

    public String getBodyAsString() throws IOException {
        if (this.body != null) {
            return this.body;
        }
        this.body = IOUtils.read(this.getReader()).toString();
        return this.body;
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        int len = this.getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (this.body != null) {
            return new CharSequenceReader(this.body);
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding());
    }

    public ServletInputStream getInputStream() throws IOException {
        Encoder enc = this.getEncoder();
        ServletInputStream is = super.getInputStream();
        if (enc != null) {
            final InputStream is2 = enc.getInputStream((InputStream)is);
            return new ServletInputStream(){

                public final int read() throws IOException {
                    return is2.read();
                }

                public final void close() throws IOException {
                    is2.close();
                }
            };
        }
        return is;
    }

    public String getPathInfoUndecoded() {
        return RestUtils.getPathInfoUndecoded((HttpServletRequest)this);
    }

    public String[] getPathInfoParts() {
        String s = this.getPathInfoUndecoded();
        if (s == null || s.isEmpty() || s.equals("/")) {
            return new String[0];
        }
        if ((s = s.substring(1)).endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        boolean needsDecode = s.indexOf(37) != -1 || s.indexOf(43) != -1;
        String[] l = s.split("/", Integer.MAX_VALUE);
        try {
            if (needsDecode) {
                for (int i = 0; i < l.length; ++i) {
                    l[i] = URLDecoder.decode(l[i], "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return l;
    }

    public URL getURL(String path) throws MalformedURLException {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return new URL(path);
        }
        if (StringUtils.startsWith(path, '/')) {
            return new URL(this.getScheme(), this.getLocalName(), this.getLocalPort(), path);
        }
        return new URL(this.getScheme(), this.getLocalName(), this.getLocalPort(), this.getContextPath() + this.getServletPath() + (StringUtils.isEmpty(path) ? "" : '/' + path));
    }

    public String getServletParentURI() {
        String s = this.getServletURI();
        return s.substring(0, s.lastIndexOf(47));
    }

    public String getPathRemainder() {
        return RestUtils.decode(this.pathRemainder);
    }

    public String getPathRemainderUndecoded() {
        return this.pathRemainder;
    }

    public String getRequestParentURI() {
        String uri = this.getRequestURI();
        while (StringUtils.endsWith(uri, '/')) {
            uri = uri.substring(0, uri.length() - 1);
        }
        int i = uri.lastIndexOf(47);
        if (i <= 0) {
            return "/";
        }
        return uri.substring(0, i);
    }

    public String getTrimmedRequestURI() {
        return RestUtils.trimTrailingSlashes(this.getRequestURI());
    }

    public StringBuffer getTrimmedRequestURL() {
        return RestUtils.trimTrailingSlashes(this.getRequestURL());
    }

    public String getServletURI() {
        if (this.servletURI == null) {
            this.servletURI = this.getServletURIBuilder().toString();
        }
        return this.servletURI;
    }

    public String getRelativeServletURI() {
        if (this.relativeServletURI == null) {
            this.relativeServletURI = this.getContextPath() + this.getServletPath();
        }
        return this.relativeServletURI;
    }

    public StringBuffer getServletURIBuilder() {
        return RestUtils.trimPathInfo(this.getRequestURL(), this.getContextPath(), this.getServletPath());
    }

    public String getServletTitle() {
        return this.servlet.getTitle(this);
    }

    public String getServletDescription() {
        return this.servlet.getDescription(this);
    }

    public String getMethodSummary() {
        return this.servlet.getMethodSummary(this.javaMethod.getName(), this);
    }

    public String getMethodDescription() {
        return this.servlet.getMethodDescription(this.javaMethod.getName(), this);
    }

    public SerializerGroup getSerializerGroup() {
        return this.serializerGroup;
    }

    public ParserGroup getParserGroup() {
        return this.parserGroup;
    }

    public Parser getParser() {
        String mediaType = this.getMediaType();
        Parser p = this.parserGroup.getParser(mediaType);
        if (p == null && mediaType.equals("application/x-www-form-urlencoded")) {
            p = this.urlEncodingParser;
        }
        return p;
    }

    public ReaderParser getReaderParser() {
        Parser p = this.getParser();
        if (p.isReaderParser()) {
            return (ReaderParser)p;
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? super.getContentLength() : this.contentLength;
    }

    public boolean isPlainText() {
        return "true".equals(this.getQueryParameter("plainText", "false"));
    }

    public String getMessage(String key, Object ... args) {
        return this.servlet.getMessage(this.getLocale(), key, args);
    }

    public MessageBundle getResourceBundle() {
        return this.servlet.getMessages(this.getLocale());
    }

    public RestServlet getServlet() {
        return this.servlet;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public VarResolverSession getVarResolverSession() {
        if (this.varSession == null) {
            this.varSession = this.servlet.getVarResolver().createSession(this.servlet.getSessionObjects(this));
        }
        return this.varSession;
    }

    public String resolveVars(String input) {
        return this.getVarResolverSession().resolve(input);
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars, String contentType) throws IOException {
        String s = this.servlet.getResourceAsString(name, this.getLocale());
        if (s == null) {
            return null;
        }
        ReaderResource rr = new ReaderResource(s, contentType);
        if (resolveVars) {
            rr.setVarSession(this.getVarResolverSession());
        }
        return rr;
    }

    public ReaderResource getReaderResource(String name, boolean resolveVars) throws IOException {
        return this.getReaderResource(name, resolveVars, this.servlet.getMimetypesFileTypeMap().getContentType(name));
    }

    public ReaderResource getReaderResource(String name) throws IOException {
        return this.getReaderResource(name, false, this.servlet.getMimetypesFileTypeMap().getContentType(name));
    }

    public ConfigFile getConfig() {
        if (this.cf == null) {
            this.cf = this.servlet.getConfig().getResolving(this.getVarResolverSession());
        }
        return this.cf;
    }

    public Swagger getSwagger() {
        if (this.swagger == null) {
            this.swagger = this.servlet.getSwagger(this);
        }
        return this.swagger;
    }

    protected Swagger getSwaggerFromFile() {
        if (this.fileSwagger == null) {
            this.fileSwagger = this.servlet.getSwaggerFromFile(this.getLocale());
        }
        if (this.fileSwagger == null) {
            this.fileSwagger = Swagger.NULL;
        }
        return this.fileSwagger == Swagger.NULL ? null : this.fileSwagger;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n").append(this.getDescription()).append("\n");
        sb.append("---Headers---\n");
        Enumeration e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            sb.append("\t").append(string).append(": ").append(this.getHeader(string)).append("\n");
        }
        sb.append("---Default Servlet Headers---\n");
        for (Map.Entry entry : this.defaultServletHeaders.entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        if (this.method.equals("PUT") || this.method.equals("POST")) {
            sb.append("---Body---\n");
            try {
                sb.append(this.getBodyAsString()).append("\n");
            }
            catch (Exception e1) {
                sb.append(e1.getLocalizedMessage());
                this.servlet.log(Level.WARNING, e1, "Error occurred while trying to read debug input.", new Object[0]);
            }
        }
        return sb.toString();
    }

    private <T> T parseParameter(String val, ClassMeta<T> c) throws ParseException {
        char x;
        if (val == null) {
            return null;
        }
        if (c.getInnerClass() == String.class && val.length() > 0 && (x = val.charAt(0)) != '(' && x != '$' && x != '\u0000' && val.indexOf(126) == -1) {
            return (T)val;
        }
        return this.urlEncodingParser.parseParameter((CharSequence)val, c);
    }

    private Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    private Encoder getEncoder() {
        if (this.encoder == null) {
            String ce = this.getHeader("content-encoding");
            if (ce != null && !ce.isEmpty()) {
                ce = ce.trim();
                this.encoder = this.servlet.getEncoders().getEncoder(ce);
                if (this.encoder == null) {
                    throw new RestException(415, "Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", this.getHeader("content-encoding"), this.servlet.getEncoders().getSupportedEncodings());
                }
            }
            if (this.encoder != null) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    private String getOverriddenHeader(String name) {
        String h = null;
        if (this.servlet.context.allowHeaderParams) {
            h = this.getQueryParameter(name);
        }
        if (h != null) {
            return h;
        }
        if (this.overriddenHeaders != null && (h = this.overriddenHeaders.get(name)) != null) {
            return h;
        }
        return h;
    }
}

