/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.text.MessageFormat;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public final class Redirect {
    private int httpResponseCode;
    private String url;
    private Object[] args;

    public Redirect(CharSequence url, Object ... args) {
        this.url = url == null ? null : url.toString();
        this.args = args;
    }

    public Redirect(Object url) {
        this.url = url == null ? null : url.toString();
    }

    public Redirect(int httpResponseCode, CharSequence url, Object ... args) {
        this.httpResponseCode = httpResponseCode;
        this.url = url == null ? null : url.toString();
        this.args = args;
    }

    public Redirect() {
    }

    public String toUrl(UrlEncodingSerializer s) {
        if (this.url != null && this.args != null && this.args.length > 0) {
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = s.serializeUrlPart(this.args[i]);
            }
            this.url = MessageFormat.format(this.url, this.args);
        }
        return this.url;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }
}

