/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Writable;
import org.apache.juneau.svl.VarResolverSession;

public class ReaderResource
implements Writable {
    private String contents;
    private String mediaType;
    private VarResolverSession varSession;
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    protected ReaderResource(String contents, String mediaType) {
        this.contents = contents;
        this.mediaType = mediaType;
    }

    public ReaderResource setHeader(String name, Object value) {
        this.headers.put(name, value == null ? "" : value.toString());
        return this;
    }

    public ReaderResource setVarSession(VarResolverSession varSession) {
        this.varSession = varSession;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void writeTo(Writer w) throws IOException {
        if (this.varSession != null) {
            this.varSession.resolveTo(this.contents, w);
        } else {
            w.write(this.contents);
        }
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        if (this.varSession != null) {
            return this.varSession.resolve(this.contents);
        }
        return this.contents;
    }
}

