/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.server;

import java.lang.reflect.Method;
import org.apache.juneau.internal.VersionRange;
import org.apache.juneau.server.RestMatcherReflecting;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.RestServlet;
import org.apache.juneau.server.annotation.RestMethod;

public class ClientVersionMatcher
extends RestMatcherReflecting {
    private final String clientVersionHeader;
    private final VersionRange range;

    protected ClientVersionMatcher(RestServlet servlet, Method javaMethod) {
        super(servlet, javaMethod);
        this.clientVersionHeader = servlet.getClientVersionHeader();
        RestMethod m = javaMethod.getAnnotation(RestMethod.class);
        this.range = new VersionRange(m.clientVersion());
    }

    @Override
    public boolean matches(RestRequest req) {
        return this.range.matches(req.getHeader(this.clientVersionHeader));
    }

    @Override
    public boolean mustMatch() {
        return true;
    }
}

