/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.internal.StringUtils;

public class SerializerWriter
extends Writer {
    protected final Writer out;
    protected final boolean useIndentation;
    protected final boolean useWhitespace;
    protected final boolean trimStrings;
    protected final char quoteChar;
    protected final String relativeUriBase;
    protected final String absolutePathUriBase;

    public SerializerWriter(Writer out, boolean useIndentation, boolean useWhitespace, boolean trimStrings, char quoteChar, String relativeUriBase, String absolutePathUriBase) {
        this.out = out;
        this.useIndentation = useIndentation;
        this.useWhitespace = useWhitespace;
        this.trimStrings = trimStrings;
        this.quoteChar = quoteChar;
        this.relativeUriBase = relativeUriBase;
        this.absolutePathUriBase = absolutePathUriBase;
    }

    public SerializerWriter cr(int depth) throws IOException {
        if (this.useIndentation) {
            return this.nl().i(depth);
        }
        return this;
    }

    public SerializerWriter appendln(int indent, String text) throws IOException {
        return this.append(indent, true, text);
    }

    public SerializerWriter appendln(String text) throws IOException {
        return this.append(0, true, text);
    }

    public SerializerWriter append(int indent, String text) throws IOException {
        return this.append(indent, false, text);
    }

    public SerializerWriter append(int indent, char c) throws IOException {
        return this.i(indent).append(c);
    }

    private SerializerWriter append(int indent, boolean newline, String text) throws IOException {
        this.i(indent);
        this.out.write(text);
        if (newline) {
            this.nl();
        }
        return this;
    }

    public SerializerWriter appendUri(Object uri) throws IOException {
        String s = uri.toString();
        if (s.indexOf("://") == -1) {
            if (StringUtils.startsWith(s, '/')) {
                if (this.absolutePathUriBase != null) {
                    this.append(this.absolutePathUriBase);
                }
            } else if (this.relativeUriBase != null) {
                this.append(this.relativeUriBase);
                if (!this.relativeUriBase.equals("/")) {
                    this.append("/");
                }
            }
        }
        return this.append(s);
    }

    public SerializerWriter s() throws IOException {
        if (this.useWhitespace) {
            this.out.write(32);
        }
        return this;
    }

    public SerializerWriter q() throws IOException {
        this.out.write(this.quoteChar);
        return this;
    }

    public SerializerWriter i(int indent) throws IOException {
        if (this.useIndentation) {
            for (int i = 0; i < indent; ++i) {
                this.out.write(9);
            }
        }
        return this;
    }

    public SerializerWriter nl() throws IOException {
        if (this.useIndentation) {
            this.out.write(10);
        }
        return this;
    }

    public SerializerWriter append(Object text) throws IOException {
        this.out.append(text == null ? null : text.toString());
        return this;
    }

    public SerializerWriter append(String text) throws IOException {
        if (text != null) {
            this.out.append(text);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean b, String text) throws IOException {
        if (b) {
            this.out.write(text);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean b, char c) throws IOException {
        if (b) {
            this.out.write(c);
        }
        return this;
    }

    @Override
    public SerializerWriter append(char c) throws IOException {
        this.out.write(c);
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

