/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Session;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.transform.PojoSwap;

public class SerializerSession
extends Session {
    private static JuneauLogger logger = JuneauLogger.getLogger(SerializerSession.class);
    private final int maxDepth;
    private final int initialDepth;
    private final boolean debug;
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;
    private final boolean useIndentation;
    private final boolean addBeanTypeProperties;
    private final boolean trimNulls;
    private final boolean trimEmptyCollections;
    private final boolean trimEmptyMaps;
    private final boolean trimStrings;
    private final boolean sortCollections;
    private final boolean sortMaps;
    private final char quoteChar;
    private final String relativeUriBase;
    private final String absolutePathUriBase;
    private final ObjectMap overrideProperties;
    public int indent;
    private boolean closed;
    private final Map<Object, Object> set;
    private final LinkedList<StackElement> stack = new LinkedList();
    private boolean isBottom;
    private final List<String> warnings = new LinkedList<String>();
    private final BeanContext beanContext;
    private final Method javaMethod;
    private final Object output;
    private OutputStream outputStream;
    private Writer writer;
    private Writer flushOnlyWriter;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;

    public SerializerSession(SerializerContext ctx, BeanContext beanContext, Object output, ObjectMap op, Method javaMethod) {
        super(ctx);
        this.beanContext = beanContext;
        this.javaMethod = javaMethod;
        this.output = output;
        if (op == null || op.isEmpty()) {
            this.overrideProperties = new ObjectMap();
            this.maxDepth = ctx.maxDepth;
            this.initialDepth = ctx.initialDepth;
            this.debug = ctx.debug;
            this.detectRecursions = ctx.detectRecursions;
            this.ignoreRecursions = ctx.ignoreRecursions;
            this.useIndentation = ctx.useIndentation;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
            this.trimNulls = ctx.trimNulls;
            this.trimEmptyCollections = ctx.trimEmptyCollections;
            this.trimEmptyMaps = ctx.trimEmptyMaps;
            this.trimStrings = ctx.trimStrings;
            this.quoteChar = ctx.quoteChar;
            this.relativeUriBase = ctx.relativeUriBase;
            this.absolutePathUriBase = ctx.absolutePathUriBase;
            this.sortCollections = ctx.sortCollections;
            this.sortMaps = ctx.sortMaps;
        } else {
            this.overrideProperties = op;
            this.maxDepth = op.getInt("Serializer.maxDepth", ctx.maxDepth);
            this.initialDepth = op.getInt("Serializer.initialDepth", ctx.initialDepth);
            this.debug = op.getBoolean("Serializer.debug", ctx.debug);
            this.detectRecursions = op.getBoolean("Serializer.detectRecursions", ctx.detectRecursions);
            this.ignoreRecursions = op.getBoolean("Serializer.ignoreRecursions", ctx.ignoreRecursions);
            this.useIndentation = op.getBoolean("Serializer.useIndentation", ctx.useIndentation);
            this.addBeanTypeProperties = op.getBoolean("Serializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
            this.trimNulls = op.getBoolean("Serializer.trimNullProperties", ctx.trimNulls);
            this.trimEmptyCollections = op.getBoolean("Serializer.trimEmptyLists", ctx.trimEmptyCollections);
            this.trimEmptyMaps = op.getBoolean("Serializer.trimEmptyMaps", ctx.trimEmptyMaps);
            this.trimStrings = op.getBoolean("Serializer.trimStrings", ctx.trimStrings);
            this.quoteChar = op.getString("Serializer.quoteChar", "" + ctx.quoteChar).charAt(0);
            this.relativeUriBase = op.getString("Serializer.relativeUriBase", ctx.relativeUriBase);
            this.absolutePathUriBase = op.getString("Serializer.absolutePathUriBase", ctx.absolutePathUriBase);
            this.sortCollections = op.getBoolean("Serializer.sortCollections", ctx.sortMaps);
            this.sortMaps = op.getBoolean("Serializer.sortMaps", ctx.sortMaps);
        }
        this.indent = this.initialDepth;
        this.set = this.detectRecursions || this.debug ? new IdentityHashMap<Object, Object>() : Collections.emptyMap();
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.output == null) {
            throw new SerializeException("Output cannot be null.", new Object[0]);
        }
        if (this.output instanceof OutputStream) {
            return (OutputStream)this.output;
        }
        if (this.output instanceof File) {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream((File)this.output));
            }
            return this.outputStream;
        }
        throw new SerializeException("Cannot convert object of type {0} to an OutputStream.", this.output.getClass().getName());
    }

    public Writer getWriter() throws Exception {
        if (this.output == null) {
            throw new SerializeException("Output cannot be null.", new Object[0]);
        }
        if (this.output instanceof Writer) {
            return (Writer)this.output;
        }
        if (this.output instanceof OutputStream) {
            if (this.flushOnlyWriter == null) {
                this.flushOnlyWriter = new OutputStreamWriter((OutputStream)this.output, IOUtils.UTF8);
            }
            return this.flushOnlyWriter;
        }
        if (this.output instanceof File) {
            if (this.writer == null) {
                this.writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream((File)this.output)));
            }
            return this.writer;
        }
        throw new SerializeException("Cannot convert object of type {0} to a Writer.", this.output.getClass().getName());
    }

    protected Object getOutput() {
        return this.output;
    }

    public void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    public void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    public final BeanContext getBeanContext() {
        return this.beanContext;
    }

    public final Method getJavaMethod() {
        return this.javaMethod;
    }

    public final ObjectMap getProperties() {
        return this.overrideProperties;
    }

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final int getInitialDepth() {
        return this.initialDepth;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final boolean isDetectRecursions() {
        return this.detectRecursions;
    }

    public final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    public final boolean isUseIndentation() {
        return this.useIndentation;
    }

    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    public final char getQuoteChar() {
        return this.quoteChar;
    }

    public final boolean isTrimNulls() {
        return this.trimNulls;
    }

    public final boolean isTrimEmptyCollections() {
        return this.trimEmptyCollections;
    }

    public final boolean isTrimEmptyMaps() {
        return this.trimEmptyMaps;
    }

    public final boolean isTrimStrings() {
        return this.trimStrings;
    }

    public final boolean isSortCollections() {
        return this.sortCollections;
    }

    public final boolean isSortMaps() {
        return this.sortMaps;
    }

    public final String getRelativeUriBase() {
        return this.relativeUriBase;
    }

    public final String getAbsolutePathUriBase() {
        return this.absolutePathUriBase;
    }

    public ClassMeta<?> push(String attrName, Object o, ClassMeta<?> eType) throws SerializeException {
        ClassMeta<?> cm;
        ++this.indent;
        this.isBottom = true;
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassMeta<?> classMeta = cm = eType != null && c == eType.getInnerClass() ? eType : this.beanContext.getClassMeta(c);
        if (cm.isCharSequence() || cm.isNumber() || cm.isBoolean()) {
            return cm;
        }
        if (this.detectRecursions || this.debug) {
            if (this.stack.size() > this.maxDepth) {
                return null;
            }
            if (this.willRecurse(attrName, o, cm)) {
                return null;
            }
            this.isBottom = false;
            this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
            if (this.debug) {
                logger.info(this.getStack(false));
            }
            this.set.put(o, o);
        }
        return cm;
    }

    public boolean willRecurse(String attrName, Object o, ClassMeta<?> cm) throws SerializeException {
        if (!this.detectRecursions && !this.debug) {
            return false;
        }
        if (!this.set.containsKey(o)) {
            return false;
        }
        if (this.ignoreRecursions && !this.debug) {
            return true;
        }
        this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
        throw new SerializeException("Recursion occurred, stack={0}", this.getStack(true));
    }

    public void pop() {
        Object o;
        Object o2;
        --this.indent;
        if ((this.detectRecursions || this.debug) && !this.isBottom && (o2 = this.set.remove(o = this.stack.removeLast().o)) == null) {
            this.addWarning("Couldn't remove object of type ''{0}'' on attribute ''{1}'' from object stack.", o.getClass().getName(), this.stack);
        }
        this.isBottom = false;
    }

    public int getIndent() {
        return this.indent;
    }

    public void addWarning(String msg, Object ... args) {
        logger.warning(msg, args);
        msg = args.length == 0 ? msg : MessageFormat.format(msg, args);
        this.warnings.add(this.warnings.size() + 1 + ": " + msg);
    }

    public void addBeanGetterWarning(BeanPropertyMeta p, Throwable t) {
        String prefix = this.debug ? this.getStack(false) + ": " : "";
        this.addWarning("{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", prefix, p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage());
    }

    public final String trim(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    public final Object generalize(Object o, ClassMeta<?> type) throws SerializeException {
        PojoSwap<?, ?> f;
        if (o == null) {
            return null;
        }
        PojoSwap<?, ?> pojoSwap = f = type == null || type.isObject() ? this.getBeanContext().getClassMeta(o.getClass()).getPojoSwap() : type.getPojoSwap();
        if (f == null) {
            return o;
        }
        return f.swap(o, this.getBeanContext());
    }

    public final boolean canIgnoreValue(ClassMeta<?> cm, String attrName, Object value) throws SerializeException {
        if (this.trimNulls && value == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (cm == null) {
            cm = this.getBeanContext().object();
        }
        if (this.trimEmptyCollections) {
            if ((cm.isArray() || cm.isObject() && value.getClass().isArray()) && ((Object[])value).length == 0) {
                return true;
            }
            if ((cm.isCollection() || cm.isObject() && ClassUtils.isParentClass(Collection.class, value.getClass())) && ((Collection)value).isEmpty()) {
                return true;
            }
        }
        if (this.trimEmptyMaps && (cm.isMap() || cm.isObject() && ClassUtils.isParentClass(Map.class, value.getClass())) && ((Map)value).isEmpty()) {
            return true;
        }
        return this.trimNulls && this.willRecurse(attrName, value, cm);
    }

    public final <K, V> Map<K, V> sort(Map<K, V> m) {
        if (this.sortMaps && m != null && !m.isEmpty() && m.keySet().iterator().next() instanceof Comparable) {
            return new TreeMap<K, V>(m);
        }
        return m;
    }

    public final <E> Collection<E> sort(Collection<E> c) {
        if (this.sortCollections && c != null && !c.isEmpty() && c.iterator().next() instanceof Comparable) {
            return new TreeSet<E>(c);
        }
        return c;
    }

    public String resolveUri(String uri) {
        if (uri.indexOf("://") != -1 || this.absolutePathUriBase == null && this.relativeUriBase == null) {
            return uri;
        }
        StringBuilder sb = new StringBuilder(uri.length() + (this.absolutePathUriBase == null ? 0 : this.absolutePathUriBase.length()) + 1 + (this.relativeUriBase == null ? 0 : this.relativeUriBase.length()));
        if (StringUtils.startsWith(uri, '/')) {
            if (this.absolutePathUriBase != null) {
                sb.append(this.absolutePathUriBase);
            }
        } else if (this.relativeUriBase != null) {
            sb.append(this.relativeUriBase);
            if (!uri.equals("/")) {
                sb.append("/");
            }
        }
        sb.append(uri);
        return sb.toString();
    }

    public String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Class.class) {
            return ClassUtils.getReadableClassName((Class)o);
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    public void close() throws SerializeException {
        if (this.closed) {
            throw new SerializeException("Attempt to close SerializerSession more than once.", new Object[0]);
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.flushOnlyWriter != null) {
                this.flushOnlyWriter.flush();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        if (this.debug && this.warnings.size() > 0) {
            throw new SerializeException("Warnings occurred during serialization: \n" + StringUtils.join(this.warnings, "\n"), new Object[0]);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            throw new RuntimeException("SerializerSession was not closed.");
        }
    }

    private String getStack(boolean full) {
        StringBuilder sb = new StringBuilder();
        for (StackElement e : this.stack) {
            if (full) {
                sb.append("\n\t");
                for (int i = 1; i < e.depth; ++i) {
                    sb.append("  ");
                }
                if (e.depth > 0) {
                    sb.append("->");
                }
                sb.append(e.toString(false));
                continue;
            }
            sb.append(" > ").append(e.toString(true));
        }
        return sb.toString();
    }

    public Map<String, Object> getLastLocation() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass);
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        if (this.stack != null && !this.stack.isEmpty()) {
            m.put("stack", this.stack);
        }
        return m;
    }

    public BeanPropertyValue createBeanTypeNameProperty(BeanMap<?> m) {
        BeanMeta<?> bm = m.getMeta();
        String name = bm.getClassMeta().getDictionaryName();
        if (name == null) {
            return null;
        }
        return new BeanPropertyValue(bm.getTypeProperty(), name, null);
    }

    private static class StackElement {
        private int depth;
        private String name;
        private Object o;
        private ClassMeta<?> aType;

        private StackElement(int depth, String name, Object o, ClassMeta<?> aType) {
            this.depth = depth;
            this.name = name;
            this.o = o;
            this.aType = aType;
        }

        private String toString(boolean simple) {
            StringBuilder sb = new StringBuilder().append('[').append(this.depth).append(']');
            sb.append(StringUtils.isEmpty(this.name) ? "<noname>" : this.name).append(':');
            sb.append(this.aType.toString(simple));
            if (this.aType != this.aType.getSerializedClassMeta()) {
                sb.append('/').append(this.aType.getSerializedClassMeta().toString(simple));
            }
            return sb.toString();
        }
    }
}

