/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.Lockable;
import org.apache.juneau.LockedException;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.serializer.Serializer;

public final class SerializerGroup
extends Lockable {
    private final Map<String, Serializer> serializerMap = new ConcurrentHashMap<String, Serializer>();
    private final Map<String, String> mediaTypeMappings = new ConcurrentHashMap<String, String>();
    private final CopyOnWriteArrayList<Serializer> serializers = new CopyOnWriteArrayList();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock rl = this.lock.readLock();
    private final Lock wl = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializerGroup append(Class<? extends Serializer> ... s) throws Exception {
        this.checkLock();
        this.wl.lock();
        try {
            this.serializerMap.clear();
            this.mediaTypeMappings.clear();
            for (Class<? extends Serializer> ss : ArrayUtils.reverse(s)) {
                try {
                    this.append(ss);
                }
                catch (NoClassDefFoundError e) {
                    System.err.println(e);
                }
            }
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    public SerializerGroup append(Class<? extends Serializer> c) throws Exception {
        this.checkLock();
        this.wl.lock();
        try {
            this.serializerMap.clear();
            this.mediaTypeMappings.clear();
            this.serializers.add(0, c.newInstance());
        }
        catch (NoClassDefFoundError e) {
            System.err.println(e);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    public Serializer getSerializer(String mediaType) {
        Serializer s = this.serializerMap.get(mediaType);
        if (s == null) {
            s = this.serializerMap.get(this.findMatch(mediaType));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMatch(String acceptHeader) {
        this.rl.lock();
        try {
            String mt = this.mediaTypeMappings.get(acceptHeader);
            if (mt != null) {
                String string = mt;
                return string;
            }
            MediaRange[] mr = MediaRange.parse(acceptHeader);
            if (mr.length == 0) {
                mr = MediaRange.parse("*/*");
            }
            for (MediaRange a : mr) {
                for (Serializer s : this.serializers) {
                    for (MediaRange a2 : s.getMediaRanges()) {
                        if (!a.matches(a2)) continue;
                        mt = a2.getMediaType();
                        this.mediaTypeMappings.put(acceptHeader, mt);
                        this.serializerMap.put(mt, s);
                        String string = mt;
                        return string;
                    }
                }
            }
            MediaRange[] mediaRangeArray = null;
            return mediaRangeArray;
        }
        finally {
            this.rl.unlock();
        }
    }

    public List<String> getSupportedMediaTypes() {
        ArrayList<String> l = new ArrayList<String>();
        for (Serializer s : this.serializers) {
            for (String mt : s.getMediaTypes()) {
                if (l.contains(mt)) continue;
                l.add(mt);
            }
        }
        return l;
    }

    public SerializerGroup setProperty(String property, Object value) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.setProperty(property, value);
        }
        return this;
    }

    public SerializerGroup setProperties(ObjectMap properties) {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.setProperties(properties);
        }
        return this;
    }

    public SerializerGroup addNotBeanClasses(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.addNotBeanClasses((Class[])classes);
        }
        return this;
    }

    public SerializerGroup addBeanFilters(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.addBeanFilters((Class[])classes);
        }
        return this;
    }

    public SerializerGroup addPojoSwaps(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.addPojoSwaps((Class[])classes);
        }
        return this;
    }

    public SerializerGroup addToDictionary(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.addToDictionary((Class[])classes);
        }
        return this;
    }

    public <T> SerializerGroup addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        this.checkLock();
        for (Serializer s : this.serializers) {
            s.addImplClass((Class)interfaceClass, (Class)implClass);
        }
        return this;
    }

    @Override
    public SerializerGroup lock() {
        super.lock();
        for (Serializer s : this.serializers) {
            s.lock();
        }
        return this;
    }

    @Override
    public SerializerGroup clone() throws CloneNotSupportedException {
        SerializerGroup g = new SerializerGroup();
        ArrayList<Serializer> l = new ArrayList<Serializer>(this.serializers.size());
        for (Serializer s : this.serializers) {
            l.add(s.clone());
        }
        g.serializers.addAll(l);
        return g;
    }
}

