/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import org.apache.juneau.Context;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.internal.StringUtils;

public class SerializerContext
extends Context {
    public static final String SERIALIZER_maxDepth = "Serializer.maxDepth";
    public static final String SERIALIZER_initialDepth = "Serializer.initialDepth";
    public static final String SERIALIZER_detectRecursions = "Serializer.detectRecursions";
    public static final String SERIALIZER_ignoreRecursions = "Serializer.ignoreRecursions";
    public static final String SERIALIZER_debug = "Serializer.debug";
    public static final String SERIALIZER_useIndentation = "Serializer.useIndentation";
    public static final String SERIALIZER_addBeanTypeProperties = "Serializer.addBeanTypeProperties";
    public static final String SERIALIZER_quoteChar = "Serializer.quoteChar";
    public static final String SERIALIZER_trimNullProperties = "Serializer.trimNullProperties";
    public static final String SERIALIZER_trimEmptyCollections = "Serializer.trimEmptyLists";
    public static final String SERIALIZER_trimEmptyMaps = "Serializer.trimEmptyMaps";
    public static final String SERIALIZER_trimStrings = "Serializer.trimStrings";
    public static final String SERIALIZER_relativeUriBase = "Serializer.relativeUriBase";
    public static final String SERIALIZER_absolutePathUriBase = "Serializer.absolutePathUriBase";
    public static final String SERIALIZER_sortCollections = "Serializer.sortCollections";
    public static final String SERIALIZER_sortMaps = "Serializer.sortMaps";
    final int maxDepth;
    final int initialDepth;
    final boolean debug;
    final boolean detectRecursions;
    final boolean ignoreRecursions;
    final boolean useIndentation;
    final boolean addBeanTypeProperties;
    final boolean trimNulls;
    final boolean trimEmptyCollections;
    final boolean trimEmptyMaps;
    final boolean trimStrings;
    final boolean sortCollections;
    final boolean sortMaps;
    final char quoteChar;
    final String relativeUriBase;
    final String absolutePathUriBase;

    public SerializerContext(ContextFactory cf) {
        super(cf);
        this.maxDepth = cf.getProperty(SERIALIZER_maxDepth, Integer.TYPE, 100);
        this.initialDepth = cf.getProperty(SERIALIZER_initialDepth, Integer.TYPE, 0);
        this.debug = cf.getProperty(SERIALIZER_debug, Boolean.TYPE, false);
        this.detectRecursions = cf.getProperty(SERIALIZER_detectRecursions, Boolean.TYPE, false);
        this.ignoreRecursions = cf.getProperty(SERIALIZER_ignoreRecursions, Boolean.TYPE, false);
        this.useIndentation = cf.getProperty(SERIALIZER_useIndentation, Boolean.TYPE, false);
        this.addBeanTypeProperties = cf.getProperty(SERIALIZER_addBeanTypeProperties, Boolean.TYPE, false);
        this.trimNulls = cf.getProperty(SERIALIZER_trimNullProperties, Boolean.TYPE, true);
        this.trimEmptyCollections = cf.getProperty(SERIALIZER_trimEmptyCollections, Boolean.TYPE, false);
        this.trimEmptyMaps = cf.getProperty(SERIALIZER_trimEmptyMaps, Boolean.TYPE, false);
        this.trimStrings = cf.getProperty(SERIALIZER_trimStrings, Boolean.TYPE, false);
        this.sortCollections = cf.getProperty(SERIALIZER_sortCollections, Boolean.TYPE, false);
        this.sortMaps = cf.getProperty(SERIALIZER_sortMaps, Boolean.TYPE, false);
        this.quoteChar = cf.getProperty(SERIALIZER_quoteChar, String.class, "\"").charAt(0);
        this.relativeUriBase = this.resolveRelativeUriBase(cf.getProperty(SERIALIZER_relativeUriBase, String.class, ""));
        this.absolutePathUriBase = this.resolveAbsolutePathUriBase(cf.getProperty(SERIALIZER_absolutePathUriBase, String.class, ""));
    }

    private String resolveRelativeUriBase(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        if (s.equals("/")) {
            return s;
        }
        if (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String resolveAbsolutePathUriBase(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        if (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

