/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.juneau.CoreApi;
import org.apache.juneau.LockedException;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerSession;

public abstract class Serializer
extends CoreApi {
    private final String[] mediaTypes;
    private final MediaRange[] mediaRanges;
    private final String contentType;

    Serializer() {
        Produces p = ReflectionUtils.getAnnotation(Produces.class, this.getClass());
        if (p == null) {
            throw new RuntimeException(MessageFormat.format("Class ''{0}'' is missing the @Produces annotation", this.getClass().getName()));
        }
        this.mediaTypes = StringUtils.split(p.value(), ',');
        for (int i = 0; i < this.mediaTypes.length; ++i) {
            this.mediaTypes[i] = this.mediaTypes[i].toLowerCase(Locale.ENGLISH);
        }
        LinkedList<MediaRange> l = new LinkedList<MediaRange>();
        for (int i = 0; i < this.mediaTypes.length; ++i) {
            l.addAll(Arrays.asList(MediaRange.parse(this.mediaTypes[i])));
        }
        this.mediaRanges = l.toArray(new MediaRange[l.size()]);
        String ct = p.contentType().isEmpty() ? this.mediaTypes[0] : p.contentType();
        this.contentType = ct.isEmpty() ? null : ct;
    }

    public abstract boolean isWriterSerializer();

    protected abstract void doSerialize(SerializerSession var1, Object var2) throws Exception;

    public abstract Object serialize(Object var1) throws SerializeException;

    public final void serialize(SerializerSession session, Object o) throws SerializeException {
        try {
            this.doSerialize(session, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException(session, "Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the SerializerContext.SERIALIZER_detectRecursions setting to help locate the loop.", new Object[0]).initCause(e);
        }
        catch (Exception e) {
            throw new SerializeException(session, e);
        }
        finally {
            session.close();
        }
    }

    public final void serialize(Object o, Object output) throws SerializeException {
        SerializerSession session = this.createSession(output);
        this.serialize(session, o);
    }

    public SerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new SerializerSession(this.getContext(SerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    protected SerializerSession createSession(Object output) {
        return this.createSession(output, null, null);
    }

    protected final List<Object> toList(Class<?> type, Object array) {
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            int l = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    public String[] getMediaTypes() {
        return this.mediaTypes;
    }

    public MediaRange[] getMediaRanges() {
        return this.mediaRanges;
    }

    public ObjectMap getResponseHeaders(ObjectMap properties) {
        return new ObjectMap(this.getBeanContext());
    }

    public String getResponseContentType() {
        return this.contentType;
    }

    @Override
    public Serializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public Serializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses(classes);
        return this;
    }

    @Override
    public Serializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters(classes);
        return this;
    }

    @Override
    public Serializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps(classes);
        return this;
    }

    @Override
    public Serializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary(classes);
        return this;
    }

    @Override
    public <T> Serializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public Serializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public Serializer lock() {
        super.lock();
        return this;
    }

    @Override
    public Serializer clone() throws CloneNotSupportedException {
        Serializer c = (Serializer)super.clone();
        return c;
    }
}

