/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.Lockable;
import org.apache.juneau.LockedException;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.parser.Parser;

public final class ParserGroup
extends Lockable {
    private final Map<String, Parser> parserMap = new ConcurrentHashMap<String, Parser>();
    private final Map<String, String> mediaTypeMappings = new ConcurrentHashMap<String, String>();
    private final CopyOnWriteArrayList<Parser> parsers = new CopyOnWriteArrayList();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock rl = this.lock.readLock();
    private final Lock wl = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParserGroup append(Class<? extends Parser> ... p) throws Exception {
        this.checkLock();
        this.wl.lock();
        try {
            for (Class<? extends Parser> c : ArrayUtils.reverse(p)) {
                this.parserMap.clear();
                this.mediaTypeMappings.clear();
                try {
                    this.append(c);
                }
                catch (NoClassDefFoundError e) {
                    System.err.println(e);
                }
            }
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    public ParserGroup append(Class<? extends Parser> p) throws Exception {
        this.checkLock();
        this.wl.lock();
        try {
            this.parserMap.clear();
            this.mediaTypeMappings.clear();
            this.parsers.add(0, p.newInstance());
        }
        catch (NoClassDefFoundError e) {
            System.err.println(e);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    public Parser getParser(String mediaType) {
        String mt;
        Parser p = this.parserMap.get(mediaType);
        if (p == null && (mt = this.findMatch(mediaType)) != null) {
            p = this.parserMap.get(mt);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMatch(String contentTypeHeader) {
        this.rl.lock();
        try {
            String mt = this.mediaTypeMappings.get(contentTypeHeader);
            if (mt != null) {
                String string = mt;
                return string;
            }
            MediaRange[] mr = MediaRange.parse(contentTypeHeader);
            if (mr.length == 0) {
                mr = MediaRange.parse("*/*");
            }
            for (MediaRange a : mr) {
                for (Parser p : this.parsers) {
                    for (MediaRange a2 : p.getMediaRanges()) {
                        if (!a.matches(a2)) continue;
                        mt = a2.getMediaType();
                        this.mediaTypeMappings.put(contentTypeHeader, mt);
                        this.parserMap.put(mt, p);
                        String string = mt;
                        return string;
                    }
                }
            }
            MediaRange[] mediaRangeArray = null;
            return mediaRangeArray;
        }
        finally {
            this.rl.unlock();
        }
    }

    public List<String> getSupportedMediaTypes() {
        ArrayList<String> l = new ArrayList<String>();
        for (Parser p : this.parsers) {
            for (String mt : p.getMediaTypes()) {
                if (l.contains(mt)) continue;
                l.add(mt);
            }
        }
        return l;
    }

    public ParserGroup setProperty(String property, Object value) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.setProperty(property, value);
        }
        return this;
    }

    public ParserGroup setProperties(ObjectMap properties) {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.setProperties(properties);
        }
        return this;
    }

    public ParserGroup addNotBeanClasses(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.addNotBeanClasses((Class[])classes);
        }
        return this;
    }

    public ParserGroup addBeanFilters(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.addBeanFilters((Class[])classes);
        }
        return this;
    }

    public ParserGroup addPojoSwaps(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.addPojoSwaps((Class[])classes);
        }
        return this;
    }

    public ParserGroup addToDictionary(Class<?> ... classes) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.addToDictionary((Class[])classes);
        }
        return this;
    }

    public <T> ParserGroup addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        this.checkLock();
        for (Parser p : this.parsers) {
            p.addImplClass((Class)interfaceClass, (Class)implClass);
        }
        return this;
    }

    @Override
    public ParserGroup lock() {
        super.lock();
        for (Parser p : this.parsers) {
            p.lock();
        }
        return this;
    }

    @Override
    public ParserGroup clone() throws CloneNotSupportedException {
        ParserGroup g = new ParserGroup();
        ArrayList<Parser> l = new ArrayList<Parser>(this.parsers.size());
        for (Parser p : this.parsers) {
            l.add(p.clone());
        }
        g.parsers.addAll(l);
        return g;
    }
}

