/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.CoreApi;
import org.apache.juneau.LockedException;
import org.apache.juneau.MediaRange;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.transform.PojoSwap;

public abstract class Parser
extends CoreApi {
    private final List<ParserListener> listeners = new LinkedList<ParserListener>();
    private final String[] mediaTypes;
    private final MediaRange[] mediaRanges;

    Parser() {
        Consumes c = ReflectionUtils.getAnnotation(Consumes.class, this.getClass());
        if (c == null) {
            throw new RuntimeException(MessageFormat.format("Class ''{0}'' is missing the @Consumes annotation", this.getClass().getName()));
        }
        this.mediaTypes = StringUtils.split(c.value(), ',');
        for (int i = 0; i < this.mediaTypes.length; ++i) {
            this.mediaTypes[i] = this.mediaTypes[i].toLowerCase(Locale.ENGLISH);
        }
        LinkedList<MediaRange> l = new LinkedList<MediaRange>();
        for (int i = 0; i < this.mediaTypes.length; ++i) {
            l.addAll(Arrays.asList(MediaRange.parse(this.mediaTypes[i])));
        }
        this.mediaRanges = l.toArray(new MediaRange[l.size()]);
    }

    protected abstract <T> T doParse(ParserSession var1, ClassMeta<T> var2) throws Exception;

    public abstract boolean isReaderParser();

    public final <T> T parse(ParserSession session, ClassMeta<T> type) throws ParseException {
        try {
            T t = this.doParse(session, type);
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(session, "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(session, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        catch (Exception e) {
            throw new ParseException(session, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage()).initCause(e);
        }
        finally {
            session.close();
        }
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException {
        ParserSession session = this.createSession(input);
        return this.parse(session, type);
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException {
        ClassMeta<T> cm = this.getBeanContext().getClassMeta(type);
        return this.parse(input, cm);
    }

    public final <K, V, T extends Map<K, V>> T parseMap(Object input, Class<T> mapClass, Class<K> keyClass, Class<V> valueClass) throws ParseException {
        ClassMeta<T> cm = this.getBeanContext().getMapClassMeta(mapClass, keyClass, valueClass);
        return (T)((Map)this.parse(input, cm));
    }

    public final <E, T extends Collection<E>> T parseCollection(Object input, Class<T> collectionClass, Class<E> entryClass) throws ParseException, IOException {
        ClassMeta<T> cm = this.getBeanContext().getCollectionClassMeta(collectionClass, entryClass);
        return (T)((Collection)this.parse(input, cm));
    }

    public ParserSession createSession(Object input, ObjectMap properties, Method javaMethod, Object outer) {
        return new ParserSession(this.getContext(ParserContext.class), this.getBeanContext(), input, properties, javaMethod, outer);
    }

    protected final ParserSession createSession(Object input) {
        return this.createSession(input, null, null, null);
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        ParserSession session = this.createSession(input);
        try {
            Map<K, V> map = this.doParseIntoMap(session, m, keyType, valueType);
            return map;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        ParserSession session = this.createSession(input);
        try {
            Collection<E> collection = this.doParseIntoCollection(session, c, elementType);
            return collection;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final Object[] parseArgs(Object input, ClassMeta<?>[] argTypes) throws ParseException {
        if (argTypes == null || argTypes.length == 0) {
            return new Object[0];
        }
        ParserSession session = this.createSession(input);
        try {
            Object[] objectArray = this.doParseArgs(session, argTypes);
            return objectArray;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session, e);
        }
        finally {
            session.close();
        }
    }

    protected Object[] doParseArgs(ParserSession session, ClassMeta<?>[] argTypes) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public Parser addListener(ParserListener listener) throws LockedException {
        this.checkLock();
        this.listeners.add(listener);
        return this;
    }

    public List<ParserListener> getListeners() {
        return this.listeners;
    }

    protected <T> T convertAttrToType(ParserSession session, Object outer, String s, ClassMeta<T> type) throws Exception {
        if (s == null) {
            return null;
        }
        if (type == null) {
            type = this.object();
        }
        PojoSwap<T, Object> transform = type.getPojoSwap();
        ClassMeta<?> sType = type.getSerializedClassMeta();
        Object o = s;
        if (sType.isChar()) {
            o = Character.valueOf(s.charAt(0));
        } else if (sType.isNumber()) {
            o = type.canCreateNewInstanceFromNumber(outer) ? type.newInstanceFromNumber(outer, StringUtils.parseNumber(s, type.getNewInstanceFromNumberClass())) : StringUtils.parseNumber(s, sType.getInnerClass());
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(s);
        } else if (!sType.isCharSequence() && !sType.isObject()) {
            if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, s);
            } else {
                throw new ParseException(session, "Invalid conversion from string to class ''{0}''", type);
            }
        }
        if (transform != null) {
            o = transform.unswap(o, type, session.getBeanContext());
        }
        return (T)o;
    }

    protected void setParent(ClassMeta<?> cm, Object o, Object parent) throws Exception {
        Method m = cm.getParentProperty();
        if (m != null) {
            m.invoke(o, parent);
        }
    }

    protected void setName(ClassMeta<?> cm, Object o, Object name) throws Exception {
        Method m;
        if (cm != null && (m = cm.getNameProperty()) != null) {
            m.invoke(o, name);
        }
    }

    protected <T> void onUnknownProperty(ParserSession session, String propertyName, BeanMap<T> beanMap, int line, int col) throws ParseException {
        BeanContext bc = session.getBeanContext();
        if (propertyName.equals("type") || propertyName.equals(bc.getBeanTypePropertyName())) {
            return;
        }
        if (!session.getBeanContext().isIgnoreUnknownBeanProperties()) {
            throw new ParseException(session, "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", propertyName, beanMap.getClassMeta());
        }
        if (this.listeners.size() > 0) {
            for (ParserListener listener : this.listeners) {
                listener.onUnknownProperty(propertyName, beanMap.getClassMeta().getInnerClass(), beanMap.getBean(), line, col);
            }
        }
    }

    public String[] getMediaTypes() {
        return this.mediaTypes;
    }

    public MediaRange[] getMediaRanges() {
        return this.mediaRanges;
    }

    @Override
    public Parser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public Parser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses(classes);
        return this;
    }

    @Override
    public Parser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters(classes);
        return this;
    }

    @Override
    public Parser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps(classes);
        return this;
    }

    @Override
    public Parser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary(classes);
        return this;
    }

    @Override
    public <T> Parser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public Parser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public Parser lock() {
        super.lock();
        return this;
    }

    @Override
    public Parser clone() throws CloneNotSupportedException {
        Parser c = (Parser)super.clone();
        return c;
    }
}

