/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.msgpack.MsgPackOutputStream;
import org.apache.juneau.msgpack.MsgPackSerializerContext;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.transform.PojoSwap;

@Produces(value="octal/msgpack")
public class MsgPackSerializer
extends OutputStreamSerializer {
    public static final MsgPackSerializer DEFAULT = new MsgPackSerializer().lock();

    MsgPackOutputStream serializeAnything(MsgPackSerializerSession session, MsgPackOutputStream out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        BeanContext bc = session.getBeanContext();
        if (o == null) {
            return out.appendNull();
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        boolean addTypeProperty = session.isAddBeanTypeProperties() && !eType.equals(aType);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(o, bc);
            if (sType.isObject()) {
                sType = bc.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendNull();
        } else if (sType.isBoolean()) {
            out.appendBoolean((Boolean)o);
        } else if (sType.isNumber()) {
            out.appendNumber((Number)o);
        } else if (sType.hasToObjectMapMethod()) {
            this.serializeMap(session, out, sType.toObjectMap(o), sType);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, bc.forBean(o), addTypeProperty);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendString(session.resolveUri(o.toString()));
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, addTypeProperty);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, this.toList(sType.getInnerClass(), o), eType);
        } else {
            out.appendString(session.toString(o));
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private void serializeMap(MsgPackSerializerSession session, MsgPackOutputStream out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = session.sort(m);
        ArrayList<SimpleMapEntry> entries = new ArrayList<SimpleMapEntry>(m.size());
        for (Map.Entry entry : m.entrySet()) {
            entries.add(new SimpleMapEntry(entry.getKey(), entry.getValue()));
        }
        out.startMap(entries.size());
        for (SimpleMapEntry simpleMapEntry : entries) {
            Object value = simpleMapEntry.value;
            Object key = session.generalize(simpleMapEntry.key, keyType);
            this.serializeAnything(session, out, key, keyType, null, null);
            this.serializeAnything(session, out, value, valueType, null, null);
        }
    }

    private void serializeBeanMap(MsgPackSerializerSession session, MsgPackOutputStream out, BeanMap<?> m, boolean addTypeProperty) throws Exception {
        List<BeanPropertyValue> values = m.getValues(session.isTrimNulls(), addTypeProperty ? session.createBeanTypeNameProperty(m) : null);
        int size = values.size();
        for (BeanPropertyValue p : values) {
            if (p.getThrown() == null) continue;
            --size;
        }
        out.startMap(size);
        for (BeanPropertyValue p : values) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
                continue;
            }
            this.serializeAnything(session, out, key, null, null, null);
            this.serializeAnything(session, out, value, cMeta, key, pMeta);
        }
    }

    private void serializeCollection(MsgPackSerializerSession session, MsgPackOutputStream out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        ArrayList l = new ArrayList(c.size());
        c = session.sort(c);
        l.addAll(c);
        out.startArray(l.size());
        for (Object o : l) {
            this.serializeAnything(session, out, o, elementType, "<iterator>", null);
        }
    }

    @Override
    public MsgPackSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new MsgPackSerializerSession(this.getContext(MsgPackSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        MsgPackSerializerSession s = (MsgPackSerializerSession)session;
        this.serializeAnything(s, s.getOutputStream(), o, null, "root", null);
    }

    @Override
    public MsgPackSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public MsgPackSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public MsgPackSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public MsgPackSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public MsgPackSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public MsgPackSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> MsgPackSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public MsgPackSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public MsgPackSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public MsgPackSerializer clone() {
        try {
            MsgPackSerializer c = (MsgPackSerializer)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SimpleMapEntry {
        final Object key;
        final Object value;

        private SimpleMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

