/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.juneau.microservice.resources.LogEntryFormatter;

public class LogParser
implements Iterable<Entry>,
Iterator<Entry> {
    private BufferedReader br;
    private LogEntryFormatter formatter;
    private Date start;
    private Date end;
    private Set<String> loggerFilter;
    private Set<String> severityFilter;
    private String threadFilter;
    private Entry next;

    public LogParser(LogEntryFormatter formatter, File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        String line;
        this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));
        this.formatter = formatter;
        this.start = start;
        this.end = end;
        this.threadFilter = thread;
        if (loggers != null) {
            this.loggerFilter = new HashSet<String>(Arrays.asList(loggers));
        }
        if (severity != null) {
            this.severityFilter = new HashSet<String>(Arrays.asList(severity));
        }
        while (this.next == null && (line = this.br.readLine()) != null) {
            Entry e = new Entry(line);
            if (!e.matches()) continue;
            this.next = e;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Entry next() {
        Entry current = this.next;
        Entry prev = this.next;
        try {
            this.next = null;
            String line = null;
            while (this.next == null && (line = this.br.readLine()) != null) {
                Entry e = new Entry(line);
                if (e.isRecord) {
                    if (e.matches()) {
                        this.next = e;
                    }
                    prev = null;
                    continue;
                }
                if (prev == null) continue;
                prev.addText(e.line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return current;
    }

    @Override
    public void remove() {
        throw new NoSuchMethodError();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }

    public void close() throws IOException {
        this.br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer w) throws IOException {
        try {
            if (!this.hasNext()) {
                w.append("[EMPTY]");
            } else {
                for (Entry le : this) {
                    le.append(w);
                }
            }
        }
        finally {
            this.close();
        }
    }

    private String toHtml(String s) {
        if (s.indexOf(60) != -1) {
            return s.replaceAll("<", "&lt;");
        }
        return s;
    }

    public class Entry {
        public Date date;
        public String severity;
        public String logger;
        protected String line;
        protected String text;
        protected String thread;
        protected List<String> additionalText;
        protected boolean isRecord;

        Entry(String line) throws IOException {
            try {
                this.line = line;
                Matcher m = LogParser.this.formatter.getLogEntryPattern().matcher(line);
                if (m.matches()) {
                    this.isRecord = true;
                    String s = LogParser.this.formatter.getField("date", m);
                    if (s != null) {
                        this.date = LogParser.this.formatter.getDateFormat().parse(s);
                    }
                    this.thread = LogParser.this.formatter.getField("thread", m);
                    this.severity = LogParser.this.formatter.getField("level", m);
                    this.logger = LogParser.this.formatter.getField("logger", m);
                    this.text = LogParser.this.formatter.getField("msg", m);
                    if (this.logger != null && this.logger.indexOf(46) > -1) {
                        this.logger = this.logger.substring(this.logger.lastIndexOf(46) + 1);
                    }
                }
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }

        private void addText(String t) {
            if (this.additionalText == null) {
                this.additionalText = new LinkedList<String>();
            }
            this.additionalText.add(t);
        }

        public String getText() {
            if (this.additionalText == null) {
                return this.text;
            }
            int i = this.text.length();
            for (String s : this.additionalText) {
                i += s.length() + 1;
            }
            StringBuilder sb = new StringBuilder(i);
            sb.append(this.text);
            for (String s : this.additionalText) {
                sb.append('\n').append(s);
            }
            return sb.toString();
        }

        public String getThread() {
            return this.thread;
        }

        public Writer appendHtml(Writer w) throws IOException {
            w.append(LogParser.this.toHtml(this.line)).append("<br>");
            if (this.additionalText != null) {
                for (String t : this.additionalText) {
                    w.append(LogParser.this.toHtml(t)).append("<br>");
                }
            }
            return w;
        }

        protected Writer append(Writer w) throws IOException {
            w.append(this.line).append('\n');
            if (this.additionalText != null) {
                for (String t : this.additionalText) {
                    w.append(t).append('\n');
                }
            }
            return w;
        }

        private boolean matches() {
            if (!this.isRecord) {
                return false;
            }
            if (LogParser.this.start != null && this.date.before(LogParser.this.start)) {
                return false;
            }
            if (LogParser.this.end != null && this.date.after(LogParser.this.end)) {
                return false;
            }
            if (LogParser.this.threadFilter != null && !LogParser.this.threadFilter.equals(this.thread)) {
                return false;
            }
            if (LogParser.this.loggerFilter != null && !LogParser.this.loggerFilter.contains(this.logger)) {
                return false;
            }
            return LogParser.this.severityFilter == null || LogParser.this.severityFilter.contains(this.severity);
        }
    }
}

