/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigMgr;
import org.apache.juneau.microservice.Resource;
import org.apache.juneau.server.ReaderResource;
import org.apache.juneau.server.RestException;
import org.apache.juneau.server.RestRequest;
import org.apache.juneau.server.annotation.Body;
import org.apache.juneau.server.annotation.FormData;
import org.apache.juneau.server.annotation.Parameter;
import org.apache.juneau.server.annotation.Path;
import org.apache.juneau.server.annotation.Property;
import org.apache.juneau.server.annotation.RestMethod;
import org.apache.juneau.server.annotation.RestResource;

@RestResource(path="/config", title="Configuration", description="Contents of configuration file.", properties={@Property(name="HtmlDocSerializer.links.map", value="{up:'$R{requestParentURI}',options:'$R{servletURI}?method=OPTIONS',edit:'$R{servletURI}/edit'}")})
public class ConfigResource
extends Resource {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/", description="Show contents of config file.")
    public ConfigFile getConfigContents() throws Exception {
        return this.getConfig();
    }

    @RestMethod(name="GET", path="/edit", description="Show config file edit page.")
    public ReaderResource getConfigEditPage(RestRequest req) throws Exception {
        req.setAttribute("contents", this.getConfig().toString().replaceAll("\\$", "\\\\\\$"));
        return req.getReaderResource("ConfigEdit.html", true);
    }

    @RestMethod(name="GET", path="/{section}", description="Show config file section.", parameters={@Parameter(in="path", name="section", description="Section name.")})
    public ObjectMap getConfigSection(@Path(value="section") String section) throws Exception {
        return this.getSection(section);
    }

    @RestMethod(name="GET", path="/{section}/{key}", description="Show config file entry.", parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="path", name="key", description="Entry name.")})
    public String getConfigEntry(@Path(value="section") String section, @Path(value="key") String key) throws Exception {
        return this.getSection(section).getString(key);
    }

    @RestMethod(name="POST", path="/", description="Sets contents of config file from a FORM post.", parameters={@Parameter(in="formData", name="contents", description="New contents in INI file format.")})
    public ConfigFile setConfigContentsFormPost(@FormData(value="contents") String contents) throws Exception {
        return this.setConfigContents(new StringReader(contents));
    }

    @RestMethod(name="PUT", path="/", description="Sets contents of config file.", parameters={@Parameter(in="body", description="New contents in INI file format.")})
    public ConfigFile setConfigContents(@Body Reader contents) throws Exception {
        ConfigFile cf2 = ConfigMgr.DEFAULT.create().load(contents);
        return this.getConfig().merge(cf2).save();
    }

    @RestMethod(name="PUT", path="/{section}", description="Add or overwrite a config file section.", parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="body", description="New contents for section as a simple map with string keys and values.")})
    public ObjectMap setConfigSection(@Path(value="section") String section, @Body Map<String, String> contents) throws Exception {
        this.getConfig().setSection(section, contents);
        return this.getSection(section);
    }

    @RestMethod(name="PUT", path="/{section}/{key}", description="Add or overwrite a config file entry.", parameters={@Parameter(in="path", name="section", description="Section name."), @Parameter(in="path", name="key", description="Entry name."), @Parameter(in="body", description="New value as a string.")})
    public String setConfigSection(@Path(value="section") String section, @Path(value="key") String key, @Body String value) throws Exception {
        this.getConfig().put(section, key, value, false);
        return this.getSection(section).getString(key);
    }

    private ObjectMap getSection(String name) {
        ObjectMap m = this.getConfig().getSectionMap(name);
        if (m == null) {
            throw new RestException(404, "Section not found.", new Object[0]);
        }
        return m;
    }
}

