/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Method;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.json.JsonSerializerContext;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializerSession;

public final class JsonSerializerSession
extends SerializerSession {
    private final boolean simpleMode;
    private final boolean useWhitespace;
    private final boolean escapeSolidus;

    protected JsonSerializerSession(JsonSerializerContext ctx, BeanContext beanContext, Object output, ObjectMap op, Method javaMethod) {
        super(ctx, beanContext, output, op, javaMethod);
        if (op == null || op.isEmpty()) {
            this.simpleMode = ctx.simpleMode;
            this.useWhitespace = ctx.useWhitespace;
            this.escapeSolidus = ctx.escapeSolidus;
        } else {
            this.simpleMode = op.getBoolean("JsonSerializer.simpleMode", ctx.simpleMode);
            this.useWhitespace = op.getBoolean("JsonSerializer.useWhitespace", ctx.useWhitespace);
            this.escapeSolidus = op.getBoolean("JsonSerializer.escapeSolidus", ctx.escapeSolidus);
        }
    }

    public final boolean isSimpleMode() {
        return this.simpleMode;
    }

    public final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    public final boolean isEscapeSolidus() {
        return this.escapeSolidus;
    }

    @Override
    public JsonWriter getWriter() throws Exception {
        Object output = this.getOutput();
        if (output instanceof JsonWriter) {
            return (JsonWriter)output;
        }
        return new JsonWriter(super.getWriter(), this.isUseIndentation(), this.isUseWhitespace(), this.isEscapeSolidus(), this.getQuoteChar(), this.isSimpleMode(), this.isTrimStrings(), this.getRelativeUriBase(), this.getAbsolutePathUriBase());
    }
}

