/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonSchemaSerializer;
import org.apache.juneau.json.JsonSerializerContext;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;

@Produces(value="application/json,text/json")
public class JsonSerializer
extends WriterSerializer {
    public static final JsonSerializer DEFAULT = new JsonSerializer().lock();
    public static final JsonSerializer DEFAULT_READABLE = new Readable().lock();
    public static final JsonSerializer DEFAULT_LAX = new Simple().lock();
    public static final JsonSerializer DEFAULT_LAX_READABLE = new SimpleReadable().lock();
    public static final JsonSerializer DEFAULT_LAX_READABLE_SAFE = new SimpleReadableSafe().lock();

    SerializerWriter serializeAnything(JsonSerializerSession session, JsonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        String wrapperAttr;
        ClassMeta<Object> aType;
        boolean isRecursion;
        BeanContext bc = session.getBeanContext();
        if (o == null) {
            out.append("null");
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = session.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType.getSerializedClassMeta();
        boolean addTypeProperty = session.isAddBeanTypeProperties() && !eType.equals(aType);
        PojoSwap<Object, ?> swap = aType.getPojoSwap();
        if (swap != null) {
            o = swap.swap(o, bc);
            if (sType.isObject()) {
                sType = bc.getClassMetaForObject(o);
            }
        }
        if ((wrapperAttr = sType.getExtendedMeta(JsonClassMeta.class).getWrapperAttr()) != null) {
            out.append('{').cr(session.indent).attr(wrapperAttr).append(':').s();
            ++session.indent;
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.append("null");
        } else if (sType.isNumber() || sType.isBoolean()) {
            out.append(o);
        } else if (sType.hasToObjectMapMethod()) {
            this.serializeMap(session, out, sType.toObjectMap(o), sType);
        } else if (sType.isBean()) {
            this.serializeBeanMap(session, out, bc.forBean(o), addTypeProperty);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.q().appendUri(o).q();
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(session, out, (BeanMap)o, addTypeProperty);
            } else {
                this.serializeMap(session, out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(session, out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(session, out, this.toList(sType.getInnerClass(), o), eType);
        } else {
            out.stringValue(session.toString(o));
        }
        if (wrapperAttr != null) {
            --session.indent;
            out.cr(session.indent - 1).append('}');
        }
        if (!isRecursion) {
            session.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(JsonSerializerSession session, JsonWriter out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = session.sort(m);
        int depth = session.getIndent();
        out.append('{');
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = session.generalize(e.getKey(), keyType);
            out.cr(depth).attr(session.toString(key)).append(':').s();
            this.serializeAnything(session, out, value, valueType, key == null ? null : session.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.append(',').s();
        }
        out.cr(depth - 1).append('}');
        return out;
    }

    private SerializerWriter serializeBeanMap(JsonSerializerSession session, JsonWriter out, BeanMap<?> m, boolean addTypeProperty) throws Exception {
        int depth = session.getIndent();
        out.append('{');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), addTypeProperty ? session.createBeanTypeNameProperty(m) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',').s();
            }
            out.cr(depth).attr(key).append(':').s();
            this.serializeAnything(session, out, value, cMeta, key, pMeta);
            addComma = true;
        }
        out.cr(depth - 1).append('}');
        return out;
    }

    private SerializerWriter serializeCollection(JsonSerializerSession session, JsonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = session.sort(c);
        out.append('[');
        int depth = session.getIndent();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            out.cr(depth);
            this.serializeAnything(session, out, value, elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',').s();
        }
        out.cr(depth - 1).append(']');
        return out;
    }

    public JsonSchemaSerializer getSchemaSerializer() {
        JsonSchemaSerializer s = new JsonSchemaSerializer(this.getContextFactory());
        return s;
    }

    @Override
    public JsonSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new JsonSerializerSession(this.getContext(JsonSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        JsonSerializerSession s = (JsonSerializerSession)session;
        this.serializeAnything(s, s.getWriter(), o, null, "root", null);
    }

    @Override
    public JsonSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public JsonSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public JsonSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public JsonSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public JsonSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public JsonSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> JsonSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public JsonSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public JsonSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public JsonSerializer clone() {
        try {
            JsonSerializer c = (JsonSerializer)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SimpleReadableSafe
    extends SimpleReadable {
        public SimpleReadableSafe() {
            this.setProperty("Serializer.detectRecursions", true);
        }
    }

    public static class SimpleReadable
    extends Simple {
        public SimpleReadable() {
            this.setProperty("JsonSerializer.useWhitespace", true);
            this.setProperty("Serializer.useIndentation", true);
        }
    }

    @Produces(value="application/json+simple,text/json+simple", contentType="application/json")
    public static class Simple
    extends JsonSerializer {
        public Simple() {
            this.setProperty("JsonSerializer.simpleMode", true);
            this.setProperty("Serializer.quoteChar", Character.valueOf('\''));
        }
    }

    public static class Readable
    extends JsonSerializer {
        public Readable() {
            this.setProperty("JsonSerializer.useWhitespace", true);
            this.setProperty("Serializer.useIndentation", true);
        }
    }
}

