/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.transform.PojoSwap;

@Produces(value="application/json+schema,text/json+schema", contentType="application/json")
public final class JsonSchemaSerializer
extends JsonSerializer {
    public JsonSchemaSerializer() {
        this.setProperty("Serializer.detectRecursions", true);
        this.setProperty("Serializer.ignoreRecursions", true);
    }

    public JsonSchemaSerializer(ContextFactory config) {
        this.getContextFactory().copyFrom(config);
        this.setProperty("Serializer.detectRecursions", true);
        this.setProperty("Serializer.ignoreRecursions", true);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        JsonSerializerSession s = (JsonSerializerSession)session;
        ObjectMap schema = this.getSchema(s, s.getBeanContext().getClassMetaForObject(o), "root", null);
        this.serializeAnything(s, s.getWriter(), schema, null, "root", null);
    }

    private ObjectMap getSchema(JsonSerializerSession session, ClassMeta<?> eType, String attrName, String[] pNames) throws Exception {
        ObjectMap out = new ObjectMap();
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<?> aType = session.push(attrName, eType, null);
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        String type = null;
        type = sType.isEnum() || sType.isCharSequence() || sType.isChar() ? "string" : (sType.isNumber() ? "number" : (sType.isBoolean() ? "boolean" : (sType.isBean() || sType.isMap() ? "object" : (sType.isCollection() || sType.isArray() ? "array" : "any"))));
        out.put("type", type);
        out.put("description", eType.toString());
        PojoSwap<Object, ?> f = eType.getPojoSwap();
        if (f != null) {
            out.put("transform", f);
        }
        if (aType != null) {
            if (sType.isEnum()) {
                out.put("enum", this.getEnumStrings(sType.getInnerClass()));
            } else if (sType.isCollection() || sType.isArray()) {
                ClassMeta<?> componentType = sType.getElementType();
                if (sType.isCollection() && ClassUtils.isParentClass(Set.class, sType.getInnerClass())) {
                    out.put("uniqueItems", true);
                }
                out.put("items", this.getSchema(session, componentType, "items", pNames));
            } else if (sType.isBean()) {
                ObjectMap properties = new ObjectMap();
                BeanMeta<?> bm = session.getBeanContext().getBeanMeta(sType.getInnerClass());
                if (pNames != null) {
                    bm = new BeanMetaFiltered(bm, pNames);
                }
                for (BeanPropertyMeta p : bm.getPropertyMetas()) {
                    properties.put(p.getName(), this.getSchema(session, p.getClassMeta(), p.getName(), p.getProperties()));
                }
                out.put("properties", properties);
            }
        }
        session.pop();
        return out;
    }

    private List<String> getEnumStrings(Class<? extends Enum> c) {
        LinkedList<String> l = new LinkedList<String>();
        for (Object e : EnumSet.allOf(c)) {
            l.add(e.toString());
        }
        return l;
    }

    @Override
    public JsonSchemaSerializer lock() {
        super.lock();
        return this;
    }
}

