/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.xml.Namespace;

public final class RdfSerializerContext
extends SerializerContext
implements RdfCommonContext {
    public static final String RDF_addLiteralTypes = "RdfSerializer.addLiteralTypes";
    public static final String RDF_addRootProperty = "RdfSerializer.addRootProperty";
    public static final String RDF_autoDetectNamespaces = "RdfSerializer.autoDetectNamespaces";
    public static final String RDF_namespaces = "RdfSerializer.namespaces.list";
    final boolean addLiteralTypes;
    final boolean addRootProperty;
    final boolean useXmlNamespaces;
    final boolean looseCollections;
    final boolean autoDetectNamespaces;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();
    final Namespace[] namespaces;

    public RdfSerializerContext(ContextFactory cf) {
        super(cf);
        this.addLiteralTypes = cf.getProperty(RDF_addLiteralTypes, Boolean.TYPE, false);
        this.addRootProperty = cf.getProperty(RDF_addRootProperty, Boolean.TYPE, false);
        this.useXmlNamespaces = cf.getProperty("Rdf.useXmlNamespaces", Boolean.TYPE, true);
        this.looseCollections = cf.getProperty("Rdf.looseCollections", Boolean.TYPE, false);
        this.autoDetectNamespaces = cf.getProperty(RDF_autoDetectNamespaces, Boolean.TYPE, true);
        this.rdfLanguage = cf.getProperty("Rdf.language", String.class, "RDF/XML-ABBREV");
        this.juneauNs = cf.getProperty("Rdf.juneauNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = cf.getProperty("Rdf.juneauBpNs", Namespace.class, new Namespace("jp", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = cf.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, RdfCollectionFormat.DEFAULT);
        this.namespaces = cf.getProperty(RDF_namespaces, Namespace[].class, new Namespace[0]);
    }
}

