/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfSerializerContext;
import org.apache.juneau.jena.RdfSerializerSession;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanPropertyMeta;

@Produces(value="text/xml+rdf+abbrev", contentType="text/xml+rdf")
public class RdfSerializer
extends WriterSerializer {
    public static final RdfSerializer DEFAULT_XML = new Xml().lock();
    public static final RdfSerializer DEFAULT_XMLABBREV = new XmlAbbrev().lock();
    public static final RdfSerializer DEFAULT_TURTLE = new Turtle().lock();
    public static final RdfSerializer DEFAULT_NTRIPLE = new NTriple().lock();
    public static final RdfSerializer DEFAULT_N3 = new N3().lock();

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        RdfSerializerSession s = (RdfSerializerSession)session;
        Model model = s.getModel();
        Resource r = null;
        ClassMeta<Object> cm = s.getBeanContext().getClassMetaForObject(o);
        if (s.isLooseCollections() && cm != null && (cm.isCollection() || cm.isArray())) {
            Collection c = s.sort(cm.isCollection() ? (List<Object>)o : this.toList(cm.getInnerClass(), o));
            for (Object o2 : c) {
                this.serializeAnything(s, o2, false, this.object(), "root", null, null);
            }
        } else {
            RDFNode n = this.serializeAnything(s, o, false, this.object(), "root", null, null);
            if (n.isLiteral()) {
                r = model.createResource();
                r.addProperty(s.getValueProperty(), n);
            } else {
                r = n.asResource();
            }
            if (s.isAddRootProp()) {
                r.addProperty(s.getRootProp(), "true");
            }
        }
        s.getRdfWriter().write(model, session.getWriter(), "http://unknown/");
    }

    private RDFNode serializeAnything(RdfSerializerSession session, Object o, boolean isURI, ClassMeta<?> eType, String attrName, BeanPropertyMeta bpm, Resource parentResource) throws SerializeException {
        Model m = session.getModel();
        BeanContext bc = session.getBeanContext();
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        aType = session.push(attrName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType.getSerializedClassMeta();
            PojoSwap<Object, ?> swap = aType.getPojoSwap();
            if (swap != null) {
                o = swap.swap(o, bc);
                if (sType.isObject()) {
                    sType = bc.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta();
        }
        Resource n = null;
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            if (bpm != null) {
                if (!session.isTrimNulls()) {
                    n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                }
            } else {
                n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            }
        } else if (sType.isUri() || isURI) {
            n = m.createResource(this.getUri(session, o, null));
        } else if (sType.isCharSequence() || sType.isChar()) {
            n = m.createLiteral(session.encodeTextInvalidChars(o));
        } else if (sType.isNumber() || sType.isBoolean()) {
            n = !session.isAddLiteralTypes() ? m.createLiteral(o.toString()) : m.createTypedLiteral(o);
        } else if (sType.isMap() || wType != null && wType.isMap()) {
            if (o instanceof BeanMap) {
                BeanMap bm = (BeanMap)o;
                Object uri = null;
                RdfBeanMeta rbm = bm.getMeta().getExtendedMeta(RdfBeanMeta.class);
                if (rbm.hasBeanUri()) {
                    uri = rbm.getBeanUriProperty().get(bm);
                }
                String uri2 = this.getUri(session, uri, null);
                n = m.createResource(uri2);
                this.serializeBeanMap(session, bm, n);
            } else {
                Map m2 = (Map)o;
                n = m.createResource();
                this.serializeMap(session, m2, n, sType);
            }
        } else if (sType.hasToObjectMapMethod()) {
            ObjectMap m2 = sType.toObjectMap(o);
            n = m.createResource();
            this.serializeMap(session, m2, n, sType);
        } else if (sType.isBean()) {
            BeanMap<Object> bm = bc.forBean(o);
            Object uri = null;
            RdfBeanMeta rbm = bm.getMeta().getExtendedMeta(RdfBeanMeta.class);
            if (rbm.hasBeanUri()) {
                uri = rbm.getBeanUriProperty().get(bm);
            }
            String uri2 = this.getUri(session, uri, null);
            n = m.createResource(uri2);
            this.serializeBeanMap(session, bm, n);
        } else if (sType.isCollection() || sType.isArray() || wType != null && wType.isCollection()) {
            Collection c = session.sort(sType.isCollection() ? (List<Object>)o : this.toList(sType.getInnerClass(), o));
            RdfCollectionFormat f = session.getCollectionFormat();
            RdfClassMeta rcm = sType.getExtendedMeta(RdfClassMeta.class);
            if (rcm.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = rcm.getCollectionFormat();
            }
            if (bpm != null && bpm.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = bpm.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat();
            }
            switch (f) {
                case BAG: {
                    n = this.serializeToContainer(session, c, sType, (Container)m.createBag());
                    break;
                }
                case LIST: {
                    n = this.serializeToList(session, c, sType);
                    break;
                }
                case MULTI_VALUED: {
                    this.serializeToMultiProperties(session, c, sType, bpm, attrName, parentResource);
                    break;
                }
                default: {
                    n = this.serializeToContainer(session, c, sType, (Container)m.createSeq());
                    break;
                }
            }
        } else {
            n = m.createLiteral(session.encodeTextInvalidChars(session.toString(o)));
        }
        if (session.isAddBeanTypeProperties() && n != null && n.isResource()) {
            if (o != null && !eType.equals(aType)) {
                n.asResource().addProperty(session.getClassProperty(), aType.toString());
            } else if (o == null) {
                n.asResource().addProperty(session.getClassProperty(), eType.toString());
            }
        }
        session.pop();
        return n;
    }

    private String getUri(RdfSerializerSession session, Object uri, Object uri2) {
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        if ((s == null || s.isEmpty()) && uri2 != null) {
            s = uri2.toString();
        }
        if (s == null) {
            return null;
        }
        if (s.indexOf("://") == -1) {
            String aUri = session.getAbsolutePathUriBase();
            String rUri = session.getRelativeUriBase();
            if (StringUtils.startsWith(s, '/')) {
                if (aUri != null) {
                    return aUri + s;
                }
            } else if (rUri != null) {
                if (rUri.equals("/")) {
                    return '/' + s;
                }
                return rUri + '/' + s;
            }
        }
        return s;
    }

    private void serializeMap(RdfSerializerSession session, Map m, Resource r, ClassMeta<?> type) throws SerializeException {
        m = session.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        ArrayList l = new ArrayList(m.entrySet());
        Collections.reverse(l);
        for (Map.Entry me : l) {
            Object value = me.getValue();
            Object key = session.generalize(me.getKey(), keyType);
            Namespace ns = session.getJuneauBpNs();
            Model model = session.getModel();
            Property p = model.createProperty(ns.getUri(), session.encodeElementName(session.toString(key)));
            RDFNode n = this.serializeAnything(session, value, false, valueType, key == null ? null : session.toString(key), null, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private void serializeBeanMap(RdfSerializerSession session, BeanMap<?> m, Resource r) throws SerializeException {
        List<BeanPropertyValue> l = m.getValues(session.isTrimNulls(), new BeanPropertyValue[0]);
        Collections.reverse(l);
        for (BeanPropertyValue bpv : l) {
            BeanPropertyMeta pMeta = bpv.getMeta();
            ClassMeta<?> cMeta = pMeta.getClassMeta();
            if (pMeta.getExtendedMeta(RdfBeanPropertyMeta.class).isBeanUri()) continue;
            String key = bpv.getName();
            Object value = bpv.getValue();
            Throwable t = bpv.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            BeanPropertyMeta bpm = bpv.getMeta();
            Namespace ns = bpm.getExtendedMeta(RdfBeanPropertyMeta.class).getNamespace();
            if (ns == null && session.isUseXmlNamespaces()) {
                ns = bpm.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
            }
            if (ns == null) {
                ns = session.getJuneauBpNs();
            } else if (session.isAutoDetectNamespaces()) {
                session.addModelPrefix(ns);
            }
            Property p = session.getModel().createProperty(ns.getUri(), session.encodeElementName(key));
            RDFNode n = this.serializeAnything(session, value, pMeta.isUri(), cMeta, key, pMeta, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private Container serializeToContainer(RdfSerializerSession session, Collection c, ClassMeta<?> type, Container list) throws SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        for (Object e : c) {
            RDFNode n = this.serializeAnything(session, e, false, elementType, null, null, null);
            list = list.add(n);
        }
        return list;
    }

    private RDFList serializeToList(RdfSerializerSession session, Collection c, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        ArrayList<RDFNode> l = new ArrayList<RDFNode>(c.size());
        for (Object e : c) {
            l.add(this.serializeAnything(session, e, false, elementType, null, null, null));
        }
        return session.getModel().createList(l.iterator());
    }

    private void serializeToMultiProperties(RdfSerializerSession session, Collection c, ClassMeta<?> sType, BeanPropertyMeta bpm, String attrName, Resource parentResource) throws SerializeException {
        ClassMeta<?> elementType = sType.getElementType();
        for (Object e : c) {
            Namespace ns = null;
            if (bpm != null && (ns = bpm.getExtendedMeta(RdfBeanPropertyMeta.class).getNamespace()) == null && session.isUseXmlNamespaces()) {
                ns = bpm.getExtendedMeta(XmlBeanPropertyMeta.class).getNamespace();
            }
            if (ns == null) {
                ns = session.getJuneauBpNs();
            } else if (session.isAutoDetectNamespaces()) {
                session.addModelPrefix(ns);
            }
            RDFNode n2 = this.serializeAnything(session, e, false, elementType, null, null, null);
            Property p = session.getModel().createProperty(ns.getUri(), session.encodeElementName(attrName));
            parentResource.addProperty(p, n2);
        }
    }

    @Override
    public RdfSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new RdfSerializerSession(this.getContext(RdfSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    public RdfSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public RdfSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public RdfSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public RdfSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public RdfSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public RdfSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> RdfSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public RdfSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public RdfSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public RdfSerializer clone() {
        try {
            return (RdfSerializer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Produces(value="text/n3")
    public static class N3
    extends RdfSerializer {
        public N3() {
            this.setProperty("Rdf.language", "N3");
        }
    }

    @Produces(value="text/turtle")
    public static class Turtle
    extends RdfSerializer {
        public Turtle() {
            this.setProperty("Rdf.language", "TURTLE");
        }
    }

    @Produces(value="text/n-triple")
    public static class NTriple
    extends RdfSerializer {
        public NTriple() {
            this.setProperty("Rdf.language", "N-TRIPLE");
        }
    }

    @Produces(value="text/xml+rdf+abbrev", contentType="text/xml+rdf")
    public static class XmlAbbrev
    extends RdfSerializer {
        public XmlAbbrev() {
            this.setProperty("Rdf.language", "RDF/XML-ABBREV");
        }
    }

    @Produces(value="text/xml+rdf")
    public static class Xml
    extends RdfSerializer {
        public Xml() {
            this.setProperty("Rdf.language", "RDF/XML");
        }
    }
}

