/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.xml.Namespace;

public final class RdfParserContext
extends ParserContext
implements RdfCommonContext {
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace";
    final boolean trimWhitespace;
    final boolean looseCollections;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();

    public RdfParserContext(ContextFactory cf) {
        super(cf);
        this.trimWhitespace = cf.getProperty(RDF_trimWhitespace, Boolean.TYPE, false);
        this.looseCollections = cf.getProperty("Rdf.looseCollections", Boolean.TYPE, false);
        this.rdfLanguage = cf.getProperty("Rdf.language", String.class, "RDF/XML-ABBREV");
        this.juneauNs = cf.getProperty("Rdf.juneauNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = cf.getProperty("Rdf.juneauBpNs", Namespace.class, new Namespace("j", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = cf.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, RdfCollectionFormat.DEFAULT);
    }
}

