/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParserContext;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;

@Consumes(value="text/xml+rdf")
public class RdfParser
extends ReaderParser {
    public static final RdfParser DEFAULT_XML = new Xml().lock();
    public static final RdfParser DEFAULT_TURTLE = new Turtle().lock();
    public static final RdfParser DEFAULT_NTRIPLE = new NTriple().lock();
    public static final RdfParser DEFAULT_N3 = new N3().lock();

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        RdfParserSession s = (RdfParserSession)session;
        type = session.getBeanContext().normalizeClassMeta(type);
        Model model = s.getModel();
        RDFReader r = s.getRdfReader();
        r.read(model, session.getReader(), null);
        BeanContext bc = session.getBeanContext();
        List<Resource> roots = this.getRoots(s, model);
        if (s.isLooseCollections() && (type.isCollection() || type.isArray())) {
            Collection c = null;
            c = type.isArray() ? new ArrayList() : (type.canCreateNewInstance(session.getOuter()) ? (Collection)type.newInstance(session.getOuter()) : new ObjectList(bc));
            for (Resource resource : roots) {
                c.add(this.parseAnything(s, type.getElementType(), (RDFNode)resource, session.getOuter()));
            }
            if (type.isArray()) {
                return (T)bc.toArray(type, c);
            }
            return (T)c;
        }
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() > 1) {
            throw new ParseException(session, "Too many root nodes found in model:  {0}", roots.size());
        }
        Resource resource = roots.get(0);
        return this.parseAnything(s, type, (RDFNode)resource, session.getOuter());
    }

    private List<Resource> getRoots(RdfParserSession session, Model m) {
        LinkedList<Resource> l = new LinkedList<Resource>();
        Property root = m.createProperty(session.getJuneauNsUri(), "root");
        ResIterator i = m.listResourcesWithProperty(root);
        while (i.hasNext()) {
            l.add((Resource)i.next());
        }
        if (!l.isEmpty()) {
            return l;
        }
        HashSet<RDFNode> objects = new HashSet<RDFNode>();
        StmtIterator i2 = m.listStatements();
        while (i2.hasNext()) {
            Statement st = (Statement)i2.next();
            Resource subject = st.getSubject();
            RDFNode object = st.getObject();
            if (!object.isResource() || object.equals(subject)) continue;
            objects.add(object);
        }
        i2 = m.listSubjects();
        while (i2.hasNext()) {
            Resource r = (Resource)i2.next();
            if (objects.contains(r)) continue;
            l.add(r);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBeanMap(RdfParserSession session, Resource r2, BeanMap<T> m) throws Exception {
        BeanMeta<T> bm = m.getMeta();
        RdfBeanMeta rbm = bm.getExtendedMeta(RdfBeanMeta.class);
        if (rbm.hasBeanUri() && r2.getURI() != null) {
            rbm.getBeanUriProperty().set(m, r2.getURI());
        }
        Property subTypeIdProperty = null;
        BeanPropertyMeta stp = bm.getSubTypeProperty();
        if (stp != null) {
            subTypeIdProperty = session.getProperty(stp.getName());
            Statement st = r2.getProperty(subTypeIdProperty);
            if (st == null) {
                throw new ParseException(session, "Could not find subtype ID property for bean of type ''{0}''", m.getClassMeta());
            }
            String subTypeId = st.getLiteral().getString();
            stp.set(m, subTypeId);
        }
        StmtIterator i = r2.listProperties();
        while (i.hasNext()) {
            RDFNode o;
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            if (p.equals(subTypeIdProperty)) continue;
            String key = session.decodeString(p.getLocalName());
            BeanPropertyMeta pMeta = m.getPropertyMeta(key);
            session.setCurrentProperty(pMeta);
            if (pMeta != null) {
                o = st.getObject();
                ClassMeta<?> cm = pMeta.getClassMeta();
                if ((cm.isArray() || cm.isCollection()) && this.isMultiValuedCollections(session, pMeta)) {
                    ClassMeta<?> et = cm.getElementType();
                    Object value = this.parseAnything(session, et, o, m.getBean(false));
                    this.setName(et, value, key);
                    pMeta.add(m, value);
                } else {
                    Object value = this.parseAnything(session, cm, o, m.getBean(false));
                    this.setName(cm, value, key);
                    pMeta.set(m, value);
                }
            } else if (!(p.equals(session.getRootProperty()) || p.equals(session.getClassProperty()) || p.equals(subTypeIdProperty))) {
                if (bm.isSubTyped()) {
                    o = st.getObject();
                    Object value = this.parseAnything(session, this.object(), o, m.getBean(false));
                    m.put(key, value);
                } else {
                    this.onUnknownProperty(session, key, m, -1, -1);
                }
            }
            session.setCurrentProperty(null);
        }
        return m;
    }

    private boolean isMultiValuedCollections(RdfParserSession session, BeanPropertyMeta pMeta) {
        if (pMeta != null && pMeta.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
            return pMeta.getExtendedMeta(RdfBeanPropertyMeta.class).getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
        }
        return session.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(RdfParserSession session, ClassMeta<T> eType, RDFNode n, Object outer) throws Exception {
        Statement st;
        BeanContext bc = session.getBeanContext();
        if (eType == null) {
            eType = this.object();
        }
        PojoSwap<Object, Object> transform = eType.getPojoSwap();
        ClassMeta<?> sType = eType.getSerializedClassMeta();
        session.setCurrentClass(sType);
        if (!sType.canCreateNewInstance(outer) && n.isResource() && (st = n.asResource().getProperty(session.getClassProperty())) != null) {
            String c = st.getLiteral().getString();
            eType = bc.getClassMetaFromString(c);
            sType = eType;
        }
        Collection o = null;
        if (!n.isResource() || n.asResource().getURI() == null || !n.asResource().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
            Resource r;
            if (sType.isObject()) {
                if (n.isLiteral()) {
                    o = n.asLiteral().getValue();
                    if (o instanceof String) {
                        o = session.decodeString(o);
                    }
                } else {
                    if (!n.isResource()) throw new ParseException(session, "Unrecognized node type ''{0}'' for object", n);
                    r = n.asResource();
                    if (session.wasAlreadyProcessed(r)) {
                        o = r.getURI();
                    } else if (r.getProperty(session.getValueProperty()) != null) {
                        o = this.parseAnything(session, this.object(), n.asResource().getProperty(session.getValueProperty()).getObject(), outer);
                    } else if (this.isSeq(session, (RDFNode)r)) {
                        o = new ObjectList(bc);
                        this.parseIntoCollection(session, (Container)r.as(Seq.class), o, sType.getElementType());
                    } else if (this.isBag(session, (RDFNode)r)) {
                        o = new ObjectList(bc);
                        this.parseIntoCollection(session, (Container)r.as(Bag.class), o, sType.getElementType());
                    } else if (r.canAs(RDFList.class)) {
                        o = new ObjectList(bc);
                        this.parseIntoCollection(session, (RDFList)r.as(RDFList.class), o, sType.getElementType());
                    } else {
                        String string = r.getURI();
                        if (string != null && !r.listProperties().hasNext()) {
                            o = r.getURI();
                        } else {
                            o = new ObjectMap(bc);
                            this.parseIntoMap(session, r, (Map)((Object)o), null, null);
                        }
                    }
                }
            } else if (sType.isBoolean()) {
                o = bc.convertToType(this.getValue(session, n, outer), Boolean.TYPE);
            } else if (sType.isCharSequence()) {
                o = session.decodeString(this.getValue(session, n, outer));
            } else if (sType.isChar()) {
                o = Character.valueOf(session.decodeString(this.getValue(session, n, outer)).charAt(0));
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber(this.getValue(session, n, outer).toString(), sType.getInnerClass());
            } else if (sType.isMap()) {
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(bc);
                o = this.parseIntoMap(session, r, map, eType.getKeyType(), eType.getValueType());
            } else if (sType.isCollection() || sType.isArray()) {
                o = sType.isArray() ? new ArrayList() : (sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(bc));
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                if (this.isSeq(session, (RDFNode)r)) {
                    this.parseIntoCollection(session, (Container)r.as(Seq.class), o, sType.getElementType());
                } else if (this.isBag(session, (RDFNode)r)) {
                    this.parseIntoCollection(session, (Container)r.as(Bag.class), o, sType.getElementType());
                } else {
                    if (!r.canAs(RDFList.class)) throw new ParseException("Unrecognized node type ''{0}'' for collection", n);
                    this.parseIntoCollection(session, (RDFList)r.as(RDFList.class), o, sType.getElementType());
                }
                if (sType.isArray()) {
                    o = bc.toArray(sType, o);
                }
            } else if (sType.canCreateNewInstanceFromObjectMap(outer)) {
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                ObjectMap objectMap = new ObjectMap(bc);
                this.parseIntoMap(session, r, objectMap, eType.getKeyType(), eType.getValueType());
                o = sType.newInstanceFromObjectMap(outer, objectMap);
            } else if (sType.canCreateNewBean(outer)) {
                r = n.asResource();
                if (session.wasAlreadyProcessed(r)) {
                    return null;
                }
                BeanMap<?> beanMap = bc.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBeanMap(session, r, beanMap).getBean();
            } else if (sType.isUri() && n.isResource()) {
                o = sType.newInstanceFromString(outer, session.decodeString(n.asResource().getURI()));
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, session.decodeString(this.getValue(session, n, outer)));
            } else {
                if (!sType.canCreateNewInstanceFromNumber(outer)) throw new ParseException("Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                o = sType.newInstanceFromNumber(outer, StringUtils.parseNumber(this.getValue(session, n, outer).toString(), sType.getNewInstanceFromNumberClass()));
            }
        }
        if (transform != null && o != null) {
            o = transform.unswap(o, eType, bc);
        }
        if (outer == null) return (T)o;
        this.setParent(eType, o, outer);
        return (T)o;
    }

    private boolean isSeq(RdfParserSession session, RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(session.getTypeProperty())) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".equals(st.getResource().getURI());
        }
        return false;
    }

    private boolean isBag(RdfParserSession session, RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(session.getTypeProperty())) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".equals(st.getResource().getURI());
        }
        return false;
    }

    private Object getValue(RdfParserSession session, RDFNode n, Object outer) throws Exception {
        Statement st;
        if (n.isLiteral()) {
            return n.asLiteral().getValue();
        }
        if (n.isResource() && (st = n.asResource().getProperty(session.getValueProperty())) != null) {
            n = st.getObject();
            if (n.isLiteral()) {
                return n.asLiteral().getValue();
            }
            return this.parseAnything(session, this.object(), st.getObject(), outer);
        }
        throw new ParseException(session, "Unknown value type for node ''{0}''", n);
    }

    private <K, V> Map<K, V> parseIntoMap(RdfParserSession session, Resource r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType) throws Exception {
        if (r.getURI() != null) {
            K uri = this.convertAttrToType(session, m, "uri", keyType);
            V value = this.convertAttrToType(session, m, r.getURI(), valueType);
            m.put(uri, value);
        }
        StmtIterator i = r.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = p.getLocalName();
            if (key.equals("root") && p.getURI().equals(session.getJuneauNsUri())) continue;
            key = session.decodeString(key);
            RDFNode o = st.getObject();
            K key2 = this.convertAttrToType(session, m, key, keyType);
            V value = this.parseAnything(session, valueType, o, m);
            this.setName(valueType, value, key);
            m.put(key2, value);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(RdfParserSession session, Container c, Collection<E> l, ClassMeta<E> et) throws Exception {
        NodeIterator ni = c.iterator();
        while (ni.hasNext()) {
            E e = this.parseAnything(session, et, ni.next(), l);
            l.add(e);
        }
        return l;
    }

    private <E> Collection<E> parseIntoCollection(RdfParserSession session, RDFList list, Collection<E> l, ClassMeta<E> et) throws Exception {
        ExtendedIterator ni = list.iterator();
        while (ni.hasNext()) {
            E e = this.parseAnything(session, et, (RDFNode)ni.next(), l);
            l.add(e);
        }
        return l;
    }

    @Override
    public RdfParserSession createSession(Object input, ObjectMap op, Method javaMethod, Object outer) {
        return new RdfParserSession(this.getContext(RdfParserContext.class), this.getBeanContext(), input, op, javaMethod, outer);
    }

    @Override
    public RdfParser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public RdfParser setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public RdfParser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public RdfParser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public RdfParser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public RdfParser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> RdfParser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public RdfParser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public RdfParser lock() {
        super.lock();
        return this;
    }

    @Override
    public RdfParser clone() {
        try {
            RdfParser c = (RdfParser)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Consumes(value="text/n3")
    public static class N3
    extends RdfParser {
        public N3() {
            this.setProperty("Rdf.language", "N3");
        }
    }

    @Consumes(value="text/turtle")
    public static class Turtle
    extends RdfParser {
        public Turtle() {
            this.setProperty("Rdf.language", "TURTLE");
        }
    }

    @Consumes(value="text/n-triple")
    public static class NTriple
    extends RdfParser {
        public NTriple() {
            this.setProperty("Rdf.language", "N-TRIPLE");
        }
    }

    @Consumes(value="text/xml+rdf")
    public static class Xml
    extends RdfParser {
        public Xml() {
            this.setProperty("Rdf.language", "RDF/XML");
        }
    }
}

