/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FileUtils;

public final class ReflectionUtils {
    public static <T extends Annotation> T getAnnotation(Class<T> a, Class<?> c) {
        if (c == null) {
            return null;
        }
        T t = ReflectionUtils.getDeclaredAnnotation(a, c);
        if (t != null) {
            return t;
        }
        t = ReflectionUtils.getAnnotation(a, c.getSuperclass());
        if (t != null) {
            return t;
        }
        for (Class<?> c2 : c.getInterfaces()) {
            t = ReflectionUtils.getAnnotation(a, c2);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<T> a, Class<?> c) {
        for (Annotation a2 : c.getDeclaredAnnotations()) {
            if (a2.annotationType() != a) continue;
            return (T)a2;
        }
        return null;
    }

    public static <T extends Annotation> List<T> findAnnotations(Class<T> a, Class<?> c) {
        LinkedList l = new LinkedList();
        ReflectionUtils.appendAnnotations(a, c, l);
        return l;
    }

    public static <T extends Annotation> List<T> findAnnotationsParentFirst(Class<T> a, Class<?> c) {
        List<T> l = ReflectionUtils.findAnnotations(a, c);
        Collections.reverse(l);
        return l;
    }

    public static <T extends Annotation> LinkedHashMap<Class<?>, T> findAnnotationsMap(Class<T> a, Class<?> c) {
        LinkedHashMap m = new LinkedHashMap();
        ReflectionUtils.findAnnotationsMap(a, c, m);
        return m;
    }

    private static <T extends Annotation> void findAnnotationsMap(Class<T> a, Class<?> c, Map<Class<?>, T> m) {
        if (c == null) {
            return;
        }
        T t = ReflectionUtils.getDeclaredAnnotation(a, c);
        if (t != null) {
            m.put(c, t);
        }
        ReflectionUtils.findAnnotationsMap(a, c.getSuperclass(), m);
        for (Class<?> c2 : c.getInterfaces()) {
            ReflectionUtils.findAnnotationsMap(a, c2, m);
        }
    }

    public static <T extends Annotation> void appendAnnotations(Class<T> a, Class<?> c, List<T> l) {
        if (c == null) {
            return;
        }
        CollectionUtils.addIfNotNull(l, ReflectionUtils.getDeclaredAnnotation(a, c));
        if (c.getPackage() != null) {
            CollectionUtils.addIfNotNull(l, c.getPackage().getAnnotation(a));
        }
        ReflectionUtils.appendAnnotations(a, c.getSuperclass(), l);
        for (Class<?> c2 : c.getInterfaces()) {
            ReflectionUtils.appendAnnotations(a, c2, l);
        }
    }

    public static InputStream getResource(Class<?> c, String name) {
        while (c != null) {
            InputStream is = c.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static InputStream getLocalizedResource(Class<?> c, String name, Locale locale) {
        if (locale == null || locale.toString().isEmpty()) {
            return ReflectionUtils.getResource(c, name);
        }
        while (c != null) {
            for (String n : FileUtils.getCandidateFileNames(name, locale)) {
                InputStream is = c.getResourceAsStream(n);
                if (is == null) continue;
                return is;
            }
            c = c.getSuperclass();
        }
        return null;
    }
}

