/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.utils.IOPipe;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static String readFile(String path) throws IOException {
        return IOUtils.read(new File(path));
    }

    public static String read(File in) throws IOException {
        if (in == null || !in.exists()) {
            return null;
        }
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(in), Charset.defaultCharset());
        return IOUtils.read(r, 0, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(File out, Reader in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charset.defaultCharset());
        try {
            int n = IOPipe.create(in, w).closeOut().run();
            return n;
        }
        finally {
            ((Writer)w).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(File out, InputStream in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        FileOutputStream os = new FileOutputStream(out);
        try {
            int n = IOPipe.create(in, os).closeOut().run();
            return n;
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static String read(Reader in) throws IOException {
        return IOUtils.read(in, 0, 1024);
    }

    public static String read(InputStream in, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, cs));
    }

    public static String read(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in, int bufferSize) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream(bufferSize);
        byte[] b = new byte[Math.min(bufferSize, 8192)];
        try {
            int nRead;
            while ((nRead = in.read(b, 0, b.length)) != -1) {
                buff.write(b, 0, nRead);
            }
            buff.flush();
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] readBytes(File f) throws IOException {
        if (f == null || !f.exists() || !f.canRead()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            byte[] byArray = IOUtils.readBytes(fis, (int)f.length());
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader in, int length, int bufferSize) throws IOException {
        if (in == null) {
            return null;
        }
        length = length <= 0 ? bufferSize : length;
        StringBuilder sb = new StringBuilder(length);
        try {
            char[] buf = new char[Math.min(bufferSize, length)];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                sb.append(buf, 0, i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static void pipe(Reader in, Writer out) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        IOPipe.create(in, out).run();
    }

    public static Reader getBufferedReader(Reader r) {
        if (r instanceof BufferedReader || r instanceof StringReader) {
            return r;
        }
        return new BufferedReader(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(InputStream is) throws IOException {
        ThrowableUtils.assertFieldNotNull(is, "is");
        long c = 0L;
        try {
            long i;
            while ((i = is.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            is.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Reader r) throws IOException {
        ThrowableUtils.assertFieldNotNull(r, "r");
        long c = 0L;
        try {
            long i;
            while ((i = r.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            r.close();
        }
        return c;
    }

    public static int getBufferSize(String contentLength) {
        try {
            if (!StringUtils.isEmpty(contentLength)) {
                long l = Long.decode(contentLength);
                if (l > 0x100000L) {
                    return 0x100000;
                }
                if (l <= 0L) {
                    return 8192;
                }
                return (int)l;
            }
        }
        catch (Exception e) {
            return 8192;
        }
        return 8192;
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... o) {
        for (Object o2 : o) {
            if (o2 instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)o2);
            }
            if (o2 instanceof OutputStream) {
                IOUtils.closeQuietly((OutputStream)o2);
            }
            if (o2 instanceof Reader) {
                IOUtils.closeQuietly((Reader)o2);
            }
            if (!(o2 instanceof Writer)) continue;
            IOUtils.closeQuietly((Writer)o2);
        }
    }
}

