/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectList;
import org.apache.juneau.internal.StringUtils;

public final class ClassUtils {
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();

    public static ObjectList getReadableClassNames(Object[] o) {
        ObjectList l = new ObjectList();
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i] == null ? "null" : ClassUtils.getReadableClassName(o[i].getClass()));
        }
        return l;
    }

    public static String getReadableClassName(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(c.getName());
    }

    public static String getReadableClassNameForObject(Object o) {
        if (o == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(o.getClass().getName());
    }

    public static String getReadableClassName(String className) {
        String c;
        if (className == null) {
            return null;
        }
        if (!StringUtils.startsWith(className, '[')) {
            return className;
        }
        int depth = 0;
        for (int i = 0; i < className.length() && className.charAt(i) == '['; ++i) {
            ++depth;
        }
        char type = className.charAt(depth);
        switch (type) {
            case 'Z': {
                c = "boolean";
                break;
            }
            case 'B': {
                c = "byte";
                break;
            }
            case 'C': {
                c = "char";
                break;
            }
            case 'D': {
                c = "double";
                break;
            }
            case 'F': {
                c = "float";
                break;
            }
            case 'I': {
                c = "int";
                break;
            }
            case 'J': {
                c = "long";
                break;
            }
            case 'S': {
                c = "short";
                break;
            }
            default: {
                c = className.substring(depth + 1, className.length() - 1);
            }
        }
        StringBuilder sb = new StringBuilder(c.length() + 2 * depth).append(c);
        for (int i = 0; i < depth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static Class<?> getClassFromReadableName(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.loadClass(name);
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child, boolean strict) {
        return parent.isAssignableFrom(child) && (!strict || !parent.equals(child));
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child) {
        return ClassUtils.isParentClass(parent, child, false);
    }

    public static String getMethodSignature(Method m) {
        StringBuilder sb = new StringBuilder(m.getName());
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length > 0) {
            sb.append('(');
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ClassUtils.getReadableClassName(pt[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static Class<?> getPrimitiveWrapper(Class<?> c) {
        return pmap1.get(c);
    }

    public static Class<?> getPrimitiveForWrapper(Class<?> c) {
        return pmap2.get(c);
    }

    public static Class<?> getWrapperIfPrimitive(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        return pmap1.get(c);
    }

    public static boolean isNotDeprecated(Class<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Method m) {
        return !m.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Constructor<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isStatic(Class<?> c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean isPublic(Constructor<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
    }

    public static final class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Class<?> object1, Class<?> object2) {
            return object1.getName().compareTo(object2.getName());
        }
    }
}

