/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileImpl;
import org.apache.juneau.ini.Encoder;
import org.apache.juneau.ini.XorEncoder;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.Args;

public class ConfigMgr {
    public static final ConfigMgr DEFAULT = new ConfigMgr(false, new XorEncoder(), JsonSerializer.DEFAULT, JsonParser.DEFAULT, Charset.defaultCharset(), new String[]{"."});
    private ConcurrentHashMap<String, File> files = new ConcurrentHashMap();
    private ConcurrentHashMap<File, ConfigFile> configs = new ConcurrentHashMap();
    private final WriterSerializer serializer;
    private final ReaderParser parser;
    private final Encoder encoder;
    private final boolean readOnly;
    private final Charset charset;
    private final List<File> searchPaths = new LinkedList<File>();

    public ConfigMgr(boolean readOnly, Encoder encoder, WriterSerializer serializer, ReaderParser parser, Charset charset, String[] searchPaths) {
        this.readOnly = readOnly;
        this.encoder = encoder;
        this.serializer = serializer;
        this.parser = parser;
        this.charset = charset;
        if (searchPaths != null) {
            for (String p : searchPaths) {
                this.searchPaths.add(new File(p));
            }
        }
    }

    public ConfigFile get(String path) throws IOException {
        return this.get(path, false);
    }

    public ConfigFile get(String path, boolean create) throws IOException {
        File f = this.resolve(path, create);
        ConfigFile cf = this.configs.get(f);
        if (cf != null) {
            return cf;
        }
        cf = new ConfigFileImpl(f, this.readOnly, this.encoder, this.serializer, this.parser, this.charset);
        this.configs.putIfAbsent(f, cf);
        return this.configs.get(f);
    }

    public ConfigFile create() throws IOException {
        return new ConfigFileImpl(null, false, this.encoder, this.serializer, this.parser, this.charset);
    }

    public ConfigFile create(File f) throws IOException {
        return new ConfigFileImpl(f, false, this.encoder, this.serializer, this.parser, this.charset);
    }

    public ConfigFile create(Reader r) throws IOException {
        return new ConfigFileImpl(null, false, this.encoder, this.serializer, this.parser, this.charset).load(r);
    }

    public void loadIfModified() throws IOException {
        for (ConfigFile cf : this.configs.values()) {
            cf.loadIfModified();
        }
    }

    public void deleteAll() {
        for (File f : Collections.list(this.configs.keys())) {
            FileUtils.delete(f);
        }
        this.files.clear();
        this.configs.clear();
    }

    private File resolve(String path, boolean create) throws IOException {
        File f = this.files.get(path);
        if (f != null) {
            return f;
        }
        f = new File(path);
        if (f.isAbsolute()) {
            if (create) {
                FileUtils.create(f);
            }
            if (f.exists()) {
                return this.addFile(path, f);
            }
            throw new FileNotFoundException("Could not find config file '" + path + "'");
        }
        if (this.searchPaths.isEmpty()) {
            throw new FileNotFoundException("No search paths specified on ConfigMgr.");
        }
        for (File sf : this.searchPaths) {
            f = new File(sf.getAbsolutePath() + "/" + path);
            if (!f.exists()) continue;
            return this.addFile(path, f);
        }
        if (create) {
            f = new File(this.searchPaths.get(0).getAbsolutePath() + "/" + path);
            FileUtils.create(f);
            return this.addFile(path, f);
        }
        throw new FileNotFoundException("Could not find config file '" + path + "'");
    }

    private File addFile(String path, File f) {
        this.files.putIfAbsent(path, f);
        return this.files.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            Args a = new Args(args);
            String command = a.getArg(0);
            String configFile = a.getArg("configFile");
            String envFile = a.getArg("envFile");
            List<String> vals = a.getArgs("vals");
            if (command == null || !command.equals("createBatchEnvFile") && !command.equals("createShellEnvFile") && !command.equals("setVals")) {
                ConfigMgr.printUsageAndExit();
            } else if (configFile.isEmpty()) {
                ConfigMgr.printUsageAndExit();
            } else if (command.equals("setVals") && vals.isEmpty()) {
                ConfigMgr.printUsageAndExit();
            } else if ((command.equals("createBatchEnvFile") || command.equals("createShellEnvFile")) && envFile.isEmpty()) {
                ConfigMgr.printUsageAndExit();
            } else {
                try {
                    ConfigFile cf = DEFAULT.get(configFile);
                    if (command.equalsIgnoreCase("setVals")) {
                        for (String val : vals) {
                            String[] x = val.split("\\=");
                            if (x.length != 2) {
                                throw new RuntimeException("Invalid format for value: '" + val + "'.  Must be in the format 'key=value'");
                            }
                            cf.put(x[0], x[1]);
                        }
                        cf.save();
                        return;
                    }
                    if (command.equalsIgnoreCase("createBatchEnvFile")) {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(envFile), Charset.defaultCharset());
                        try {
                            cf.serializeTo(fw, ConfigFileFormat.BATCH);
                        }
                        finally {
                            ((Writer)fw).close();
                        }
                        return;
                    }
                    if (!command.equalsIgnoreCase("createShellEnvFile")) break block21;
                    OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(envFile), Charset.defaultCharset());
                    try {
                        cf.serializeTo(fw, ConfigFileFormat.SHELL);
                    }
                    finally {
                        ((Writer)fw).close();
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println("---Usage---");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile createBatchEnvFile -configFile <configFile> -envFile <envFile> [-verbose]");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile createShellEnvFile -configFile <configFile> -envFile <envFile> [-verbose]");
        System.err.println("java -cp juneau.jar org.apache.juneau.ini.ConfigFile setVals -configFile <configFile> -vals [var1 val1 [var2 val2...]] [-verbose]");
        int rc = Integer.getInteger("exit.2", 2);
        if (rc != 0) {
            System.exit(rc);
        }
    }
}

