/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Writable;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.ConfigUtils;
import org.apache.juneau.ini.Section;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public abstract class ConfigFile
implements Map<String, Section> {
    public abstract String get(String var1, String var2);

    public abstract String put(String var1, String var2, Object var3, boolean var4);

    public abstract String remove(String var1, String var2);

    public abstract Set<String> getSectionKeys(String var1);

    public abstract ConfigFile loadIfModified() throws IOException;

    public abstract ConfigFile load() throws IOException;

    public abstract ConfigFile load(Reader var1) throws IOException;

    public abstract ConfigFile addLines(String var1, String ... var2);

    public abstract ConfigFile addHeaderComments(String var1, String ... var2);

    public abstract ConfigFile clearHeaderComments(String var1);

    protected abstract WriterSerializer getSerializer() throws SerializeException;

    protected abstract ReaderParser getParser() throws ParseException;

    protected abstract void readLock();

    protected abstract void readUnlock();

    public final String getString(String key, String def) {
        ThrowableUtils.assertFieldNotNull(key, "key");
        String s = this.get(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key));
        return StringUtils.isEmpty(s) && def != null ? def : s;
    }

    public final String removeString(String key) {
        ThrowableUtils.assertFieldNotNull(key, "key");
        return this.remove(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key));
    }

    public final <T> T getObject(Class<T> c, String key) throws ParseException {
        ThrowableUtils.assertFieldNotNull(c, "c");
        return this.getObject(c, key, c.isArray() ? Array.newInstance(c.getComponentType(), 0) : null);
    }

    public final <T> T getObject(Class<T> c, String key, T def) throws ParseException {
        ThrowableUtils.assertFieldNotNull(c, "c");
        ThrowableUtils.assertFieldNotNull(key, "key");
        return this.getObject(c, ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), def);
    }

    public <T> T getObject(Class<T> c, String sectionName, String sectionKey, T def) throws ParseException {
        String s = this.get(sectionName, sectionKey);
        if (s == null) {
            return def;
        }
        if (c == String.class) {
            return (T)s;
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (T)(StringUtils.isEmpty(s) ? def : Integer.valueOf(this.parseIntWithSuffix(s)));
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return (T)(StringUtils.isEmpty(s) ? def : Boolean.valueOf(Boolean.parseBoolean(s)));
        }
        if (c == String[].class) {
            String[] r = StringUtils.isEmpty(s) ? new String[]{} : StringUtils.split(s, ',');
            return (T)(r.length == 0 ? def : r);
        }
        if (c.isArray()) {
            Class<?> ce = c.getComponentType();
            if (StringUtils.isEmpty(s)) {
                return def;
            }
            String[] r = StringUtils.split(s, ',');
            Object o = Array.newInstance(ce, r.length);
            for (int i = 0; i < r.length; ++i) {
                Array.set(o, i, this.getParser().parse((Object)r[i], ce));
            }
            return (T)o;
        }
        if (StringUtils.isEmpty(s)) {
            return def;
        }
        return this.getParser().parse((Object)s, c);
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final String[] getStringArray(String key) {
        return this.getStringArray(key, new String[0]);
    }

    public final String[] getStringArray(String key, String[] def) {
        String s = this.getString(key);
        if (s == null) {
            return def;
        }
        String[] r = StringUtils.isEmpty(s) ? new String[]{} : StringUtils.split(s, ',');
        return r.length == 0 ? def : r;
    }

    public final int getInt(String key) {
        return this.getInt(key, 0);
    }

    public final int getInt(String key, int def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty(s)) {
            return def;
        }
        return this.parseIntWithSuffix(s);
    }

    public final boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public final boolean getBoolean(String key, boolean def) {
        String s = this.getString(key);
        return StringUtils.isEmpty(s) ? def : Boolean.parseBoolean(s);
    }

    @Override
    public final String put(String key, Object value) throws SerializeException {
        return this.put(key, value, this.isEncoded(key));
    }

    public final String put(String key, Object value, boolean encoded) throws SerializeException {
        Class<Collection> c;
        ThrowableUtils.assertFieldNotNull(key, "key");
        if (value == null) {
            value = "";
        }
        if (this.isSimpleType(c = value.getClass())) {
            return this.put(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), value.toString(), encoded);
        }
        if (c.isAssignableFrom(Collection.class)) {
            Collection c2 = (Collection)value;
            Object[] r = new String[c2.size()];
            int i = 0;
            for (Object o2 : c2) {
                boolean isSimpleType = o2 == null ? true : this.isSimpleType(o2.getClass());
                r[i++] = isSimpleType ? Array.get(value, i).toString() : this.getSerializer().toString(Array.get(value, i));
            }
            return this.put(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), StringUtils.join(r, ','), encoded);
        }
        if (c.isArray()) {
            boolean isSimpleType = this.isSimpleType(c.getComponentType());
            Object[] r = new String[Array.getLength(value)];
            for (int i = 0; i < r.length; ++i) {
                r[i] = isSimpleType ? Array.get(value, i).toString() : this.getSerializer().toString(Array.get(value, i));
            }
            return this.put(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), StringUtils.join(r, ','), encoded);
        }
        return this.put(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), this.getSerializer().toString(value), encoded);
    }

    private final boolean isSimpleType(Class<?> c) {
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectMap getSectionMap(String sectionName) {
        this.readLock();
        try {
            Set<String> keys = this.getSectionKeys(sectionName);
            if (keys == null) {
                ObjectMap objectMap = null;
                return objectMap;
            }
            ObjectMap m = new ObjectMap();
            for (String key : keys) {
                m.put(key, this.get(sectionName, key));
            }
            ObjectMap objectMap = m;
            return objectMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectMap writeProperties(String sectionName, Object bean, boolean ignoreUnknownProperties, Class<?> ... permittedPropertyTypes) throws ParseException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ThrowableUtils.assertFieldNotNull(bean, "bean");
        ObjectMap om = new ObjectMap();
        this.readLock();
        try {
            Set<String> keys = this.getSectionKeys(sectionName);
            if (keys == null) {
                throw new IllegalArgumentException("Section not found");
            }
            keys = new LinkedHashSet<String>(keys);
            for (Method m : bean.getClass().getMethods()) {
                String propName;
                Object value;
                int mod = m.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || !m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
                Class<?> pt = m.getParameterTypes()[0];
                if (permittedPropertyTypes != null && permittedPropertyTypes.length != 0 && !ArrayUtils.contains(pt, permittedPropertyTypes) || (value = this.getObject(pt, sectionName, propName = Introspector.decapitalize(m.getName().substring(3)), null)) == null) continue;
                m.invoke(bean, value);
                om.put(propName, value);
                keys.remove(propName);
            }
            if (!ignoreUnknownProperties && !keys.isEmpty()) {
                throw new ParseException("Invalid properties found in config file section [" + sectionName + "]: " + JsonSerializer.DEFAULT_LAX.toString(keys), new Object[0]);
            }
            ObjectMap objectMap = om;
            return objectMap;
        }
        finally {
            this.readUnlock();
        }
    }

    public final <T> T getSectionAsBean(String sectionName, Class<T> c) throws ParseException {
        return this.getSectionAsBean(sectionName, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getSectionAsBean(String sectionName, Class<T> c, boolean ignoreUnknownProperties) throws ParseException {
        ThrowableUtils.assertFieldNotNull(c, "c");
        this.readLock();
        try {
            BeanMap<T> bm = this.getParser().getBeanContext().newBeanMap(c);
            for (String k : this.getSectionKeys(sectionName)) {
                BeanPropertyMeta bpm = bm.getPropertyMeta(k);
                if (bpm == null) {
                    if (ignoreUnknownProperties) continue;
                    throw new ParseException("Unknown property {0} encountered", k);
                }
                bm.put(k, this.getObject(bpm.getClassMeta().getInnerClass(), sectionName + '/' + k));
            }
            Iterator<String> iterator = bm.getBean();
            return (T)iterator;
        }
        finally {
            this.readUnlock();
        }
    }

    public final boolean containsNonEmptyValue(String key) {
        return !StringUtils.isEmpty(this.getString(key, null));
    }

    protected abstract Section getSection(String var1);

    protected abstract Section getSection(String var1, boolean var2);

    public abstract ConfigFile addSection(String var1);

    public abstract ConfigFile setSection(String var1, Map<String, String> var2);

    public abstract ConfigFile removeSection(String var1);

    public abstract boolean isEncoded(String var1);

    public abstract ConfigFile save() throws IOException;

    public final ConfigFile serializeTo(Writer out) throws IOException {
        return this.serializeTo(out, ConfigFileFormat.INI);
    }

    public abstract ConfigFile serializeTo(Writer var1, ConfigFileFormat var2) throws IOException;

    public abstract ConfigFile addListener(ConfigFileListener var1);

    public abstract ConfigFile merge(ConfigFile var1);

    public abstract String toString();

    public abstract ConfigFile getResolving(VarResolver var1);

    public abstract ConfigFile getResolving(VarResolverSession var1);

    public abstract ConfigFile getResolving();

    public abstract Writable toWritable();

    protected VarResolver getVarResolver() {
        return null;
    }

    private int parseIntWithSuffix(String s) {
        ThrowableUtils.assertFieldNotNull(s, "s");
        int m = 1;
        if (s.endsWith("M")) {
            m = 0x100000;
            s = s.substring(0, s.length() - 1).trim();
        } else if (s.endsWith("K")) {
            m = 1024;
            s = s.substring(0, s.length() - 1).trim();
        }
        return Integer.parseInt(s) * m;
    }
}

