/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.juneau.xml.annotation.XmlFormat;

@Produces(value="text/html")
public class HtmlSerializer
extends XmlSerializer {
    public static final HtmlSerializer DEFAULT = new HtmlSerializer().lock();
    public static final HtmlSerializer DEFAULT_SQ = new Sq().lock();
    public static final HtmlSerializer DEFAULT_SQ_READABLE = new SqReadable().lock();

    private HtmlWriter doSerialize(HtmlSerializerSession session, Object o, HtmlWriter w) throws Exception {
        this.serializeAnything(session, w, o, null, null, session.getInitialDepth() - 1, null);
        return w;
    }

    protected void serializeAnything(HtmlSerializerSession session, HtmlWriter out, Object o, ClassMeta<?> eType, String name, int indent, BeanPropertyMeta pMeta) throws Exception {
        BeanContext bc = session.getBeanContext();
        ClassMeta<Object> aType = null;
        ClassMeta<Object> sType = this.object();
        if (eType == null) {
            eType = this.object();
        }
        if ((aType = session.push(name, o, eType)) == null) {
            o = null;
            aType = this.object();
        }
        session.indent += indent;
        int i = session.indent;
        if (o == null || aType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.tag(i, "null").nl();
        } else {
            HtmlClassMeta html;
            PojoSwap<Object, ?> swap;
            sType = aType.getSerializedClassMeta();
            String typeName = null;
            if (session.isAddBeanTypeProperties() && !eType.equals(aType)) {
                typeName = aType.getDictionaryName();
            }
            if ((swap = aType.getPojoSwap()) != null) {
                o = swap.swap(o, bc);
                if (sType.isObject()) {
                    sType = bc.getClassMetaForObject(o);
                }
            }
            if ((html = sType.getExtendedMeta(HtmlClassMeta.class)).isAsXml() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsXml()) {
                super.serializeAnything(session, out, o, null, null, null, false, XmlFormat.NORMAL, null);
            } else if (html.isAsPlainText() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsPlainText()) {
                out.write(o == null ? "null" : o.toString());
            } else if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
                out.tag(i, "null").nl();
            } else if (sType.hasToObjectMapMethod()) {
                this.serializeMap(session, out, sType.toObjectMap(o), eType, typeName, pMeta);
            } else if (sType.isBean()) {
                this.serializeBeanMap(session, out, bc.forBean(o), pMeta);
            } else if (sType.isNumber()) {
                out.sTag(i, "number").append(o).eTag("number").nl();
            } else if (sType.isBoolean()) {
                out.sTag(i, "boolean").append(o).eTag("boolean").nl();
            } else if (sType.isMap()) {
                if (o instanceof BeanMap) {
                    this.serializeBeanMap(session, out, (BeanMap)o, pMeta);
                } else {
                    this.serializeMap(session, out, (Map)o, eType, typeName, pMeta);
                }
            } else if (sType.isCollection()) {
                this.serializeCollection(session, out, (Collection)o, eType, name, pMeta);
            } else if (sType.isArray()) {
                this.serializeCollection(session, out, this.toList(sType.getInnerClass(), o), eType, name, pMeta);
            } else if (session.isUri(sType, pMeta, o)) {
                String label = session.getAnchorText(pMeta, o);
                out.oTag(i, "a").attrUri("href", o).append('>');
                out.append(label);
                out.eTag("a").nl();
            } else {
                out.sTag(i, "string").encodeText(session.toString(o)).eTag("string").nl();
            }
        }
        session.pop();
        session.indent -= indent;
    }

    private void serializeMap(HtmlSerializerSession session, HtmlWriter out, Map m, ClassMeta<?> type, String typeName, BeanPropertyMeta ppMeta) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        ClassMeta<Map> aType = session.getBeanContext().getClassMetaForObject(m);
        BeanContext bc = session.getBeanContext();
        int i = session.getIndent();
        if (typeName == null) {
            typeName = "object";
        }
        out.oTag(i, "table").attr(bc.getBeanTypePropertyName(), typeName);
        out.appendln(">");
        if (!(!session.isAddKeyValueTableHeaders() || aType.getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl();
            out.sTag(i + 2, "th").nl().appendln(i + 3, "<string>key</string>").eTag(i + 2, "th").nl();
            out.sTag(i + 2, "th").nl().appendln(i + 3, "<string>value</string>").eTag(i + 2, "th").nl();
            out.eTag(i + 1, "tr").nl();
        }
        for (Map.Entry e : m.entrySet()) {
            Object key = session.generalize(e.getKey(), keyType);
            Object value = null;
            try {
                value = e.getValue();
            }
            catch (StackOverflowError t) {
                throw t;
            }
            catch (Throwable t) {
                session.addWarning("Could not call getValue() on property ''{0}'', {1}", e.getKey(), t.getLocalizedMessage());
            }
            out.sTag(i + 1, "tr").nl();
            out.sTag(i + 2, "td").nl();
            this.serializeAnything(session, out, key, keyType, null, 2, null);
            out.eTag(i + 2, "td").nl();
            out.sTag(i + 2, "td").nl();
            this.serializeAnything(session, out, value, valueType, key == null ? "_x0000_" : key.toString(), 2, null);
            out.eTag(i + 2, "td").nl();
            out.eTag(i + 1, "tr").nl();
        }
        out.eTag(i, "table").nl();
    }

    private void serializeBeanMap(HtmlSerializerSession session, HtmlWriter out, BeanMap<?> m, BeanPropertyMeta ppMeta) throws Exception {
        int i = session.getIndent();
        BeanContext bc = session.getBeanContext();
        Object o = m.getBean();
        Class<?> c = o.getClass();
        if (c.isAnnotationPresent(HtmlLink.class)) {
            HtmlLink h = o.getClass().getAnnotation(HtmlLink.class);
            Object urlProp = m.get(h.hrefProperty());
            Object nameProp = m.get(h.nameProperty());
            out.oTag(i, "a").attrUri("href", urlProp).append('>').encodeText(nameProp).eTag("a").nl();
            return;
        }
        String typeName = m.getMeta().getDictionaryName();
        if (typeName == null) {
            typeName = "object";
        }
        out.oTag(i, "table").attr(bc.getBeanTypePropertyName(), typeName);
        out.append('>').nl();
        if (!(!session.isAddKeyValueTableHeaders() || m.getClassMeta().getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl();
            out.sTag(i + 2, "th").nl().appendln(i + 3, "<string>key</string>").eTag(i + 2, "th").nl();
            out.sTag(i + 2, "th").nl().appendln(i + 3, "<string>value</string>").eTag(i + 2, "th").nl();
            out.eTag(i + 1, "tr").nl();
        }
        for (BeanPropertyValue p : m.getValues(session.isTrimNulls(), new BeanPropertyValue[0])) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                session.addBeanGetterWarning(pMeta, t);
            }
            if (session.canIgnoreValue(cMeta, key, value)) continue;
            out.sTag(i + 1, "tr").nl();
            out.sTag(i + 2, "td").nl();
            out.sTag(i + 3, "string").encodeText(key).eTag("string").nl();
            out.eTag(i + 2, "td").nl();
            out.sTag(i + 2, "td").nl();
            try {
                this.serializeAnything(session, out, value, cMeta, key, 2, pMeta);
            }
            catch (SerializeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                session.addBeanGetterWarning(pMeta, e);
            }
            out.eTag(i + 2, "td").nl();
            out.eTag(i + 1, "tr").nl();
        }
        out.eTag(i, "table").nl();
    }

    private void serializeCollection(HtmlSerializerSession session, HtmlWriter out, Collection c, ClassMeta<?> type, String name, BeanPropertyMeta ppMeta) throws Exception {
        BeanContext bc = session.getBeanContext();
        ClassMeta<Object> elementType = type.getElementType();
        if (elementType == null) {
            elementType = bc.object();
        }
        int i = session.getIndent();
        if (c.isEmpty()) {
            out.appendln(i, "<ul></ul>");
            return;
        }
        String[] th = this.getTableHeaders(session, c = session.sort(c), ppMeta);
        if (th != null) {
            out.oTag(i, "table").attr(bc.getBeanTypePropertyName(), "array");
            out.append('>').nl();
            out.sTag(i + 1, "tr").nl();
            for (String key : th) {
                out.sTag(i + 2, "th").append(key).eTag("th").nl();
            }
            out.eTag(i + 1, "tr").nl();
            for (Object o : c) {
                BeanMap m2;
                ClassMeta<Object> cm = bc.getClassMetaForObject(o);
                if (cm != null && cm.getPojoSwap() != null) {
                    PojoSwap f = cm.getPojoSwap();
                    o = f.swap(o, bc);
                    cm = cm.getSerializedClassMeta();
                }
                if (cm != null && session.isAddBeanTypeProperties() && elementType.getInnerClass() != o.getClass()) {
                    out.oTag(i + 1, "tr").attr(bc.getBeanTypePropertyName(), cm.getDictionaryName()).append('>').nl();
                } else {
                    out.sTag(i + 1, "tr").nl();
                }
                if (cm == null) {
                    this.serializeAnything(session, out, o, null, null, 1, null);
                } else if (cm.isMap() && !cm.isBeanMap()) {
                    m2 = session.sort((Map)o);
                    for (String k : th) {
                        out.sTag(i + 2, "td").nl();
                        this.serializeAnything(session, out, m2.get(k), elementType, k, 2, null);
                        out.eTag(i + 2, "td").nl();
                    }
                } else {
                    m2 = null;
                    m2 = o instanceof BeanMap ? (BeanMap)o : bc.forBean(o);
                    for (String k : th) {
                        BeanMapEntry p = m2.getProperty(k);
                        BeanPropertyMeta pMeta = p.getMeta();
                        out.sTag(i + 2, "td").nl();
                        this.serializeAnything(session, out, p.getValue(), pMeta.getClassMeta(), p.getKey().toString(), 2, pMeta);
                        out.eTag(i + 2, "td").nl();
                    }
                }
                out.eTag(i + 1, "tr").nl();
            }
            out.eTag(i, "table").nl();
        } else {
            out.sTag(i, "ul").nl();
            for (Object o : c) {
                out.sTag(i + 1, "li").nl();
                this.serializeAnything(session, out, o, elementType, name, 1, null);
                out.eTag(i + 1, "li").nl();
            }
            out.eTag(i, "ul").nl();
        }
    }

    private String[] getTableHeaders(SerializerSession session, Collection c, BeanPropertyMeta pMeta) throws Exception {
        String[] th;
        LinkedHashSet<String> set;
        BeanContext bc = session.getBeanContext();
        if (c.size() == 0) {
            return null;
        }
        c = session.sort(c);
        TreeSet<String> s = new TreeSet<String>();
        HashSet<ClassMeta<Object>> prevC = new HashSet<ClassMeta<Object>>();
        Object o1 = null;
        for (Object o : c) {
            if (o == null) continue;
            o1 = o;
            break;
        }
        if (o1 == null) {
            return null;
        }
        ClassMeta<Object> cm = bc.getClassMetaForObject(o1);
        if (cm.getPojoSwap() != null) {
            PojoSwap<Object, ?> f = cm.getPojoSwap();
            o1 = f.swap(o1, bc);
            cm = cm.getSerializedClassMeta();
        }
        if (cm == null || !cm.isMap() && !cm.isBean()) {
            return null;
        }
        if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
            return null;
        }
        HtmlClassMeta h = cm.getExtendedMeta(HtmlClassMeta.class);
        if (h.isNoTables() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTables()) {
            return null;
        }
        if (h.isNoTableHeaders() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders()) {
            return new String[0];
        }
        if (session.canIgnoreValue(cm, null, o1)) {
            return null;
        }
        if (cm.isMap() && !cm.isBeanMap()) {
            set = new LinkedHashSet();
            for (Object o : c) {
                if (session.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                Map m = session.sort((Map)o);
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    if (entry.getValue() == null) continue;
                    set.add(entry.getKey() == null ? null : entry.getKey().toString());
                }
            }
            th = set.toArray(new String[set.size()]);
        } else {
            set = new LinkedHashSet<String>();
            for (Object o : c) {
                if (session.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                BeanMap bm = o instanceof BeanMap ? (BeanMap)o : bc.forBean(o);
                for (Map.Entry<String, Object> entry : bm.entrySet()) {
                    if (entry.getValue() == null) continue;
                    set.add(entry.getKey());
                }
            }
            th = set.toArray(new String[set.size()]);
        }
        prevC.add(cm);
        s.addAll(Arrays.asList(th));
        for (Object o : c) {
            if (o == null) continue;
            cm = bc.getClassMetaForObject(o);
            if (cm != null && cm.getPojoSwap() != null) {
                PojoSwap<Object, ?> f = cm.getPojoSwap();
                o = f.swap(o);
                cm = cm.getSerializedClassMeta();
            }
            if (prevC.contains(cm)) continue;
            if (cm == null || !cm.isMap() && !cm.isBean()) {
                return null;
            }
            if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
                return null;
            }
            if (session.canIgnoreValue(cm, null, o)) {
                return null;
            }
            if (cm.isMap() && !cm.isBeanMap()) {
                Map m = (Map)o;
                if (th.length != m.keySet().size()) {
                    return null;
                }
                for (Object k : m.keySet()) {
                    if (s.contains(k.toString())) continue;
                    return null;
                }
                continue;
            }
            BeanMap bm = o instanceof BeanMap ? (BeanMap)o : bc.forBean(o);
            int l = 0;
            for (String string : bm.keySet()) {
                if (!s.contains(string)) {
                    return null;
                }
                ++l;
            }
            if (s.size() == l) continue;
            return null;
        }
        return th;
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        try {
            return new HtmlSchemaDocSerializer(this.getContextFactory().clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HtmlSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new HtmlSerializerSession(this.getContext(HtmlSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        HtmlSerializerSession s = (HtmlSerializerSession)session;
        this.doSerialize(s, o, s.getWriter());
    }

    @Override
    public HtmlSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public HtmlSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public HtmlSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public HtmlSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public HtmlSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public HtmlSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> HtmlSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public HtmlSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public HtmlSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public HtmlSerializer clone() {
        HtmlSerializer c = (HtmlSerializer)super.clone();
        return c;
    }

    public static class SqReadable
    extends Sq {
        public SqReadable() {
            this.setProperty("Serializer.useIndentation", true);
        }
    }

    public static class Sq
    extends HtmlSerializer {
        public Sq() {
            this.setProperty("Serializer.quoteChar", Character.valueOf('\''));
        }
    }
}

