/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.Reader;
import java.lang.reflect.Method;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlParserContext;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSession;

public final class HtmlParserSession
extends ParserSession {
    private XMLEventReader xmlEventReader;

    public HtmlParserSession(HtmlParserContext ctx, BeanContext beanContext, Object input, ObjectMap op, Method javaMethod, Object outer) {
        super(ctx, beanContext, input, op, javaMethod, outer);
    }

    final XMLEventReader getXmlEventReader() throws Exception {
        Reader r = IOUtils.getBufferedReader(super.getReader());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        this.xmlEventReader = factory.createXMLEventReader(r);
        return this.xmlEventReader;
    }

    @Override
    public void close() throws ParseException {
        if (this.xmlEventReader != null) {
            try {
                this.xmlEventReader.close();
            }
            catch (XMLStreamException e) {
                throw new ParseException(e);
            }
        }
        super.close();
    }
}

