/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionary;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.html.HtmlParserContext;
import org.apache.juneau.html.HtmlParserSession;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.transform.PojoSwap;

@Consumes(value="text/html,text/html+stripped")
public final class HtmlParser
extends ReaderParser {
    public static final HtmlParser DEFAULT = new HtmlParser().lock();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(HtmlParserSession session, ClassMeta<T> eType22, XMLEventReader r, Object outer, BeanPropertyMeta pMeta) throws Exception {
        void var10_46;
        void var10_44;
        void eType22;
        BeanContext bc = session.getBeanContext();
        if (eType22 == null) {
            eType22 = this.object();
        }
        PojoSwap transform = eType22.getPojoSwap();
        ClassMeta<?> sType = eType22.getSerializedClassMeta();
        session.setCurrentClass(sType);
        BeanDictionary bd = pMeta == null ? bc.getBeanDictionary() : pMeta.getBeanDictionary();
        Object var10_14 = null;
        XMLEvent event = r.nextEvent();
        while (!(event.isStartElement() || event.isCharacters() && !event.asCharacters().isWhiteSpace() || event.isEndDocument())) {
            event = r.nextEvent();
        }
        if (event.isEndDocument()) {
            throw new XMLStreamException("Unexpected end of stream in parseAnything for type '" + eType22 + "'", event.getLocation());
        }
        if (event.isCharacters()) {
            String text = this.parseCharacters(event, (XMLEventReader)r);
            if (sType.isObject()) {
                String string = text;
            } else if (sType.isCharSequence()) {
                String string = text;
            } else if (sType.isNumber()) {
                Number number = StringUtils.parseNumber(text, eType22.getInnerClass());
            } else if (sType.isChar()) {
                Character c = Character.valueOf(text.charAt(0));
            } else if (sType.isBoolean()) {
                Boolean bl = Boolean.parseBoolean(text);
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                Object obj = sType.newInstanceFromString(outer, text);
            } else {
                if (!sType.canCreateNewInstanceFromNumber(outer)) throw new XMLStreamException("Unexpected characters '" + event.asCharacters().getData() + "' for type '" + eType22 + "'", event.getLocation());
                Object obj = sType.newInstanceFromNumber(outer, StringUtils.parseNumber(text, sType.getNewInstanceFromNumberClass()));
            }
        } else {
            Tag tag = Tag.forString(event.asStartElement().getName().getLocalPart(), false);
            String typeName = "object";
            String text = "";
            if (tag.isOneOf(Tag.STRING, Tag.NUMBER, Tag.BOOLEAN, Tag.BR, Tag.FF, Tag.BS, Tag.TB)) {
                text = this.parseCharacters(event, (XMLEventReader)r);
            }
            if (tag == Tag.TABLE) {
                Map<String, String> attrs = this.getAttributes(event);
                typeName = attrs.get(bc.getBeanTypePropertyName());
                if (bd.hasName(typeName)) {
                    ClassMeta<?> eType22 = bd.getClassMeta(typeName);
                    sType = eType22;
                }
                if (!typeName.equals("array")) {
                    typeName = "object";
                }
            }
            boolean isValid = true;
            if (tag == Tag.NULL) {
                this.nextTag((XMLEventReader)r, Tag.xNULL);
            } else if (tag == Tag.A) {
                T t = this.parseAnchor(session, event, (XMLEventReader)r, (ClassMeta<T>)eType22);
            } else if (sType.isObject()) {
                if (tag == Tag.STRING) {
                    String string = text;
                } else if (tag == Tag.NUMBER) {
                    Number number = StringUtils.parseNumber(text, null);
                } else if (tag == Tag.BOOLEAN) {
                    Boolean bl = Boolean.parseBoolean(text);
                } else if (tag == Tag.TABLE) {
                    if (typeName.equals("object")) {
                        Map<String, Object> map = this.parseIntoMap(session, (XMLEventReader)r, new ObjectMap(bc), sType.getKeyType(), sType.getValueType(), (BeanPropertyMeta)pMeta);
                    } else if (typeName.equals("array")) {
                        Collection<Object> collection = this.parseTableIntoCollection(session, (XMLEventReader)r, new ObjectList(bc), sType.getElementType(), (BeanPropertyMeta)pMeta);
                    } else {
                        isValid = false;
                    }
                } else if (tag == Tag.UL) {
                    Collection<Object> collection = this.parseIntoCollection(session, (XMLEventReader)r, new ObjectList(bc), null, (BeanPropertyMeta)pMeta);
                }
            } else if (tag == Tag.STRING && sType.isCharSequence()) {
                String string = text;
            } else if (tag == Tag.STRING && sType.isChar()) {
                Character c = Character.valueOf(text.charAt(0));
            } else if (tag == Tag.STRING && sType.canCreateNewInstanceFromString(outer)) {
                Object obj = sType.newInstanceFromString(outer, text);
            } else if (tag == Tag.NUMBER && sType.isNumber()) {
                Number number = StringUtils.parseNumber(text, sType.getInnerClass());
            } else if (tag == Tag.NUMBER && sType.canCreateNewInstanceFromNumber(outer)) {
                Object obj = sType.newInstanceFromNumber(outer, StringUtils.parseNumber(text, sType.getNewInstanceFromNumberClass()));
            } else if (tag == Tag.BOOLEAN && sType.isBoolean()) {
                Boolean bl = Boolean.parseBoolean(text);
            } else if (tag == Tag.TABLE) {
                if (typeName.equals("object")) {
                    if (sType.isMap()) {
                        Map<?, ?> map = this.parseIntoMap(session, (XMLEventReader)r, (Map)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectMap(bc)), sType.getKeyType(), sType.getValueType(), (BeanPropertyMeta)pMeta);
                    } else if (sType.canCreateNewInstanceFromObjectMap(outer)) {
                        ObjectMap m = new ObjectMap(bc);
                        this.parseIntoMap(session, (XMLEventReader)r, m, this.string(), this.object(), (BeanPropertyMeta)pMeta);
                        Object obj = sType.newInstanceFromObjectMap(outer, m);
                    } else if (sType.canCreateNewBean(outer)) {
                        BeanMap<?> m = bc.newBeanMap(outer, sType.getInnerClass());
                        Object obj = this.parseIntoBean(session, (XMLEventReader)r, m).getBean();
                    } else {
                        isValid = false;
                    }
                } else if (typeName.equals("array")) {
                    if (sType.isCollection()) {
                        Collection<?> collection = this.parseTableIntoCollection(session, (XMLEventReader)r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectList(bc)), sType.getElementType(), (BeanPropertyMeta)pMeta);
                    } else if (sType.isArray()) {
                        Object object = bc.toArray(sType, this.parseTableIntoCollection(session, (XMLEventReader)r, new ArrayList(), sType.getElementType(), (BeanPropertyMeta)pMeta));
                    } else {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
            } else if (tag == Tag.UL) {
                if (sType.isCollection()) {
                    Collection<?> collection = this.parseIntoCollection(session, (XMLEventReader)r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new ObjectList(bc)), sType.getElementType(), (BeanPropertyMeta)pMeta);
                } else if (sType.isArray()) {
                    Object object = bc.toArray(sType, this.parseIntoCollection(session, (XMLEventReader)r, new ArrayList(), sType.getElementType(), (BeanPropertyMeta)pMeta));
                } else {
                    isValid = false;
                }
            } else {
                isValid = false;
            }
            if (!isValid) {
                throw new XMLStreamException("Unexpected tag '" + (Object)((Object)tag) + "' for type '" + eType22 + "'", event.getLocation());
            }
        }
        if (transform != null && var10_44 != null) {
            Object t = transform.unswap(var10_44, (ClassMeta<?>)eType22, bc);
        }
        if (outer == null) return var10_46;
        this.setParent((ClassMeta<?>)eType22, var10_46, outer);
        return var10_46;
    }

    private <T> T parseAnchor(HtmlParserSession session, XMLEvent e, XMLEventReader r, ClassMeta<T> beanType) throws XMLStreamException {
        BeanContext bc = session.getBeanContext();
        String href = e.asStartElement().getAttributeByName(new QName("href")).getValue();
        String name = this.parseCharacters(e, r);
        Class<T> beanClass = beanType.getInnerClass();
        if (beanClass.isAnnotationPresent(HtmlLink.class)) {
            HtmlLink h = beanClass.getAnnotation(HtmlLink.class);
            BeanMap<T> m = bc.newBeanMap(beanClass);
            m.put(h.hrefProperty(), (Object)href);
            m.put(h.nameProperty(), (Object)name);
            return m.getBean();
        }
        return bc.convertToType((Object)href, beanType);
    }

    private Map<String, String> getAttributes(XMLEvent e) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        Iterator<Attribute> i = e.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            m.put(a.getName().getLocalPart(), a.getValue());
        }
        return m;
    }

    private <K, V> Map<K, V> parseIntoMap(HtmlParserSession session, XMLEventReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        Tag tag;
        while ((tag = this.nextTag(r, Tag.TR, Tag.xTABLE)) != Tag.xTABLE) {
            tag = this.nextTag(r, Tag.TD, Tag.TH);
            if (tag == Tag.TH) {
                this.parseElementText(r, Tag.xTH);
                this.nextTag(r, Tag.TH);
                this.parseElementText(r, Tag.xTH);
                this.nextTag(r, Tag.xTR);
                continue;
            }
            K key = this.parseAnything(session, keyType, r, m, pMeta);
            this.nextTag(r, Tag.xTD);
            this.nextTag(r, Tag.TD);
            V value = this.parseAnything(session, valueType, r, m, pMeta);
            this.setName(valueType, value, key);
            m.put(key, value);
            this.nextTag(r, Tag.xTD);
            this.nextTag(r, Tag.xTR);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(HtmlParserSession session, XMLEventReader r, Collection<E> l, ClassMeta<E> elementType, BeanPropertyMeta pMeta) throws Exception {
        Tag tag;
        while ((tag = this.nextTag(r, Tag.LI, Tag.xUL)) != Tag.xUL) {
            l.add(this.parseAnything(session, elementType, r, l, pMeta));
            this.nextTag(r, Tag.xLI);
        }
        return l;
    }

    private Object[] parseArgs(HtmlParserSession session, XMLEventReader r, ClassMeta<?>[] argTypes) throws Exception {
        Tag tag;
        Object[] o = new Object[argTypes.length];
        int i = 0;
        while ((tag = this.nextTag(r, Tag.LI, Tag.xUL)) != Tag.xUL) {
            o[i] = this.parseAnything(session, argTypes[i], r, session.getOuter(), null);
            ++i;
            this.nextTag(r, Tag.xLI);
        }
        return o;
    }

    private <E> Collection<E> parseTableIntoCollection(HtmlParserSession session, XMLEventReader r, Collection<E> l, ClassMeta<E> elementType, BeanPropertyMeta pMeta) throws Exception {
        XMLEvent event;
        BeanContext bc = session.getBeanContext();
        if (elementType == null) {
            elementType = this.object();
        }
        BeanDictionary bd = pMeta == null ? bc.getBeanDictionary() : pMeta.getBeanDictionary();
        Tag tag = this.nextTag(r, Tag.TR);
        ArrayList<String> keys = new ArrayList<String>();
        while ((tag = this.nextTag(r, Tag.TH, Tag.xTR)) != Tag.xTR) {
            keys.add(this.parseElementText(r, Tag.xTH));
        }
        while ((tag = Tag.forEvent(event = r.nextTag())) != Tag.xTABLE) {
            if (elementType.canCreateNewBean(l)) {
                BeanMap<Object> m = bc.newBeanMap(l, elementType.getInnerClass());
                for (int i = 0; i < keys.size(); ++i) {
                    tag = this.nextTag(r, Tag.TD, Tag.NULL);
                    if (tag == Tag.NULL) {
                        m = null;
                        this.nextTag(r, Tag.xNULL);
                        break;
                    }
                    String key = (String)keys.get(i);
                    BeanMapEntry e = m.getProperty(key);
                    if (e == null) {
                        this.parseAnything(session, this.object(), r, l, null);
                    } else {
                        BeanPropertyMeta bpm = e.getMeta();
                        ClassMeta<?> cm = bpm.getClassMeta();
                        Object value = this.parseAnything(session, cm, r, m.getBean(false), bpm);
                        this.setName(cm, value, key);
                        bpm.set(m, value);
                    }
                    this.nextTag(r, Tag.xTD);
                }
                l.add(m == null ? null : m.getBean());
            } else {
                String c = this.getAttributes(event).get(bc.getBeanTypePropertyName());
                Map m = (Map)(elementType.isMap() && elementType.canCreateNewInstance(l) ? elementType.newInstance(l) : new ObjectMap(bc));
                for (int i = 0; i < keys.size(); ++i) {
                    tag = this.nextTag(r, Tag.TD, Tag.NULL);
                    if (tag == Tag.NULL) {
                        m = null;
                        this.nextTag(r, Tag.xNULL);
                        break;
                    }
                    String key = (String)keys.get(i);
                    if (m != null) {
                        ClassMeta<?> et = elementType.getElementType();
                        Object value = this.parseAnything(session, et, r, l, pMeta);
                        this.setName(et, value, key);
                        m.put(key, value);
                    }
                    this.nextTag(r, Tag.xTD);
                }
                if (m != null && c != null) {
                    ObjectMap m2 = m instanceof ObjectMap ? (ObjectMap)m : new ObjectMap((Map<?, ?>)m).setBeanContext(session.getBeanContext());
                    m2.put(bc.getBeanTypePropertyName(), c);
                    l.add(bd.cast(m2));
                } else {
                    l.add(m);
                }
            }
            this.nextTag(r, Tag.xTR);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBean(HtmlParserSession session, XMLEventReader r, BeanMap<T> m) throws Exception {
        Tag tag;
        while ((tag = this.nextTag(r, Tag.TR, Tag.xTABLE)) != Tag.xTABLE) {
            tag = this.nextTag(r, Tag.TD, Tag.TH);
            if (tag == Tag.TH) {
                this.parseElementText(r, Tag.xTH);
                this.nextTag(r, Tag.TH);
                this.parseElementText(r, Tag.xTH);
                this.nextTag(r, Tag.xTR);
                continue;
            }
            String key = this.parseElementText(r, Tag.xTD);
            this.nextTag(r, Tag.TD);
            BeanPropertyMeta pMeta = m.getPropertyMeta(key);
            if (pMeta == null) {
                if (m.getMeta().isSubTyped()) {
                    Object value = this.parseAnything(session, this.object(), r, m.getBean(false), null);
                    m.put(key, value);
                } else {
                    this.onUnknownProperty(session, key, m, -1, -1);
                    this.parseAnything(session, this.object(), r, null, null);
                }
            } else {
                ClassMeta<?> cm = pMeta.getClassMeta();
                Object value = this.parseAnything(session, cm, r, m.getBean(false), pMeta);
                this.setName(cm, value, key);
                pMeta.set(m, value);
            }
            this.nextTag(r, Tag.xTD);
            this.nextTag(r, Tag.xTR);
        }
        return m;
    }

    private String parseCharacters(XMLEvent e, XMLEventReader r) throws XMLStreamException {
        LinkedList<String> strings = new LinkedList<String>();
        while (true) {
            Tag tag;
            int eventType;
            if ((eventType = e.getEventType()) == 4) {
                Characters c = e.asCharacters();
                if (!c.isWhiteSpace()) {
                    strings.add(c.getData());
                }
            } else if (eventType == 1) {
                Tag tag2 = Tag.forEvent(e);
                if (tag2 == Tag.BR) {
                    strings.add("\n");
                } else if (tag2 == Tag.FF) {
                    strings.add("\f");
                } else if (tag2 == Tag.BS) {
                    strings.add("\b");
                } else if (tag2 == Tag.TB) {
                    strings.add("\t");
                }
            }
            XMLEvent eNext = r.peek();
            if (eNext.isStartElement() || eNext.isEndElement() ? !(tag = Tag.forEvent(eNext)).isOneOf(Tag.A, Tag.xA, Tag.BR, Tag.xBR, Tag.FF, Tag.xFF, Tag.BS, Tag.xBS, Tag.TB, Tag.xTB, Tag.STRING, Tag.xSTRING, Tag.NUMBER, Tag.xNUMBER, Tag.BOOLEAN, Tag.xBOOLEAN) : eNext.isEndDocument()) {
                return this.trim(this.join(strings));
            }
            e = r.nextEvent();
        }
    }

    private String trim(String s) {
        int i3;
        char c;
        int i2 = 0;
        for (i2 = 0; i2 < s.length() && (c = s.charAt(i2)) == ' '; ++i2) {
        }
        for (i3 = s.length(); i3 > i2 && (c = s.charAt(i3 - 1)) == ' '; --i3) {
        }
        return s.substring(i2, i3);
    }

    private String parseElementText(XMLEventReader r, Tag endTag) throws XMLStreamException {
        Tag nTag;
        LinkedList<String> strings = new LinkedList<String>();
        XMLEvent e = r.nextEvent();
        Tag tag = nTag = e.isEndElement() ? Tag.forEvent(e) : null;
        while (nTag != endTag) {
            if (e.isCharacters()) {
                strings.add(this.parseCharacters(e, r));
            }
            if ((e = r.nextEvent()).getEventType() == 2) {
                nTag = Tag.forEvent(e);
            }
            if (nTag != endTag) continue;
            return this.join(strings);
        }
        return "";
    }

    private Tag nextTag(XMLEventReader r, Tag ... expected) throws XMLStreamException {
        XMLEvent event = r.nextTag();
        Tag tag = Tag.forEvent(event);
        if (expected.length == 0) {
            return tag;
        }
        for (Tag t : expected) {
            if (t != tag) continue;
            return tag;
        }
        throw new XMLStreamException("Unexpected tag: " + (Object)((Object)tag), event.getLocation());
    }

    private String join(List<String> s) {
        if (s.size() == 0) {
            return "";
        }
        if (s.size() == 1) {
            return s.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String ss : s) {
            sb.append(ss);
        }
        return sb.toString();
    }

    @Override
    public HtmlParserSession createSession(Object input, ObjectMap properties, Method javaMethod, Object outer) {
        return new HtmlParserSession(this.getContext(HtmlParserContext.class), this.getBeanContext(), input, properties, javaMethod, outer);
    }

    @Override
    protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
        type = session.getBeanContext().normalizeClassMeta(type);
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseAnything(s, type, s.getXmlEventReader(), session.getOuter(), null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserSession session, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseIntoMap(s, s.getXmlEventReader(), m, s.getBeanContext().getClassMeta(keyType), s.getBeanContext().getClassMeta(valueType), null);
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserSession session, Collection<E> c, Type elementType) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseIntoCollection(s, s.getXmlEventReader(), c, s.getBeanContext().getClassMeta(elementType), null);
    }

    @Override
    protected Object[] doParseArgs(ParserSession session, ClassMeta<?>[] argTypes) throws Exception {
        HtmlParserSession s = (HtmlParserSession)session;
        return this.parseArgs(s, s.getXmlEventReader(), argTypes);
    }

    @Override
    public HtmlParser setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public HtmlParser setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public HtmlParser addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public HtmlParser addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public HtmlParser addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public HtmlParser addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> HtmlParser addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public HtmlParser setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public HtmlParser lock() {
        super.lock();
        return this;
    }

    @Override
    public HtmlParser clone() {
        try {
            return (HtmlParser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static enum Tag {
        TABLE(1, "<table>"),
        TR(2, "<tr>"),
        TH(3, "<th>"),
        TD(4, "<td>"),
        UL(5, "<ul>"),
        LI(6, "<li>"),
        STRING(7, "<string>"),
        NUMBER(8, "<number>"),
        BOOLEAN(9, "<boolean>"),
        NULL(10, "<null>"),
        A(11, "<a>"),
        BR(12, "<br>"),
        FF(13, "<ff>"),
        BS(14, "<bs>"),
        TB(15, "<tb>"),
        xTABLE(-1, "</table>"),
        xTR(-2, "</tr>"),
        xTH(-3, "</th>"),
        xTD(-4, "</td>"),
        xUL(-5, "</ul>"),
        xLI(-6, "</li>"),
        xSTRING(-7, "</string>"),
        xNUMBER(-8, "</number>"),
        xBOOLEAN(-9, "</boolean>"),
        xNULL(-10, "</null>"),
        xA(-11, "</a>"),
        xBR(-12, "</br>"),
        xFF(-13, "</ff>"),
        xBS(-14, "</bs>"),
        xTB(-15, "</tb>");

        private Map<Integer, Tag> cache = new HashMap<Integer, Tag>();
        int id;
        String label;

        private Tag(int id, String label) {
            this.id = id;
            this.label = label;
            this.cache.put(id, this);
        }

        static Tag forEvent(XMLEvent event) throws XMLStreamException {
            if (event.isStartElement()) {
                return Tag.forString(event.asStartElement().getName().getLocalPart(), false);
            }
            if (event.isEndElement()) {
                return Tag.forString(event.asEndElement().getName().getLocalPart(), true);
            }
            throw new XMLStreamException("Invalid call to Tag.forEvent on event of type [" + event.getEventType() + "]");
        }

        private static Tag forString(String tag, boolean end) throws XMLStreamException {
            char c = tag.charAt(0);
            Tag t = null;
            if (c == 'u') {
                t = end ? xUL : UL;
            } else if (c == 'l') {
                t = end ? xLI : LI;
            } else if (c == 's') {
                t = end ? xSTRING : STRING;
            } else if (c == 'b') {
                c = tag.charAt(1);
                if (c == 'o') {
                    t = end ? xBOOLEAN : BOOLEAN;
                } else if (c == 'r') {
                    t = end ? xBR : BR;
                } else if (c == 's') {
                    t = end ? xBS : BS;
                }
            } else if (c == 'a') {
                t = end ? xA : A;
            } else if (c == 'n') {
                c = tag.charAt(2);
                if (c == 'm') {
                    t = end ? xNUMBER : NUMBER;
                } else if (c == 'l') {
                    t = end ? xNULL : NULL;
                }
            } else if (c == 't') {
                c = tag.charAt(1);
                if (c == 'a') {
                    t = end ? xTABLE : TABLE;
                } else if (c == 'r') {
                    t = end ? xTR : TR;
                } else if (c == 'h') {
                    t = end ? xTH : TH;
                } else if (c == 'd') {
                    t = end ? xTD : TD;
                } else if (c == 'b') {
                    t = end ? xTB : TB;
                }
            } else if (c == 'f') {
                Tag tag2 = t = end ? xFF : FF;
            }
            if (t == null) {
                throw new XMLStreamException("Unknown tag '" + tag + "' encountered");
            }
            return t;
        }

        public String toString() {
            return this.label;
        }

        public boolean isOneOf(Tag ... tags) {
            for (Tag tag : tags) {
                if (tag != this) continue;
                return true;
            }
            return false;
        }
    }
}

