/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.dto.Link;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerSession;

@Produces(value="text/html")
public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    private static final String REST_method = "RestServlet.method";
    private static final String REST_relativeServletURI = "RestServlet.relativeServletURI";
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer().lock();

    @Override
    public HtmlDocSerializerSession createSession(Object output, ObjectMap properties, Method javaMethod) {
        return new HtmlDocSerializerSession(this.getContext(HtmlDocSerializerContext.class), this.getBeanContext(), output, properties, javaMethod);
    }

    @Override
    protected void doSerialize(SerializerSession session, Object o) throws Exception {
        Map<String, String> htmlLinks;
        HtmlDocSerializerSession s = (HtmlDocSerializerSession)session;
        HtmlWriter w = s.getWriter();
        ObjectMap properties = s.getProperties();
        boolean isOptionsPage = properties.containsKey(REST_method) && properties.getString(REST_method).equalsIgnoreCase("OPTIONS");
        w.sTag("html").nl();
        w.sTag("head").nl();
        String cssUrl = s.getCssUrl();
        if (cssUrl == null) {
            cssUrl = properties.getString(REST_relativeServletURI) + "/style.css";
        }
        w.oTag(1, "style").attr("type", "text/css").appendln(">").append(2, "@import ").q().append(cssUrl).q().appendln(";");
        if (s.isNoWrap()) {
            w.appendln("\n* {white-space:nowrap;}");
        }
        if (s.getCssImports() != null) {
            for (String cssImport : s.getCssImports()) {
                w.append(2, "@import ").q().append(cssImport).q().appendln(";");
            }
        }
        w.eTag(1, "style").nl();
        w.eTag("head").nl();
        w.sTag("body").nl();
        String title = s.getTitle();
        if (title == null && isOptionsPage) {
            title = "Options";
        }
        String description = s.getDescription();
        if (title != null) {
            w.oTag(1, "h3").attr("class", "title").append('>').encodeText(title).eTag("h3").nl();
        }
        if (description != null) {
            w.oTag(1, "h5").attr("class", "description").append('>').encodeText(description).eTag("h5").nl();
        }
        LinkedList<Link> actions = new LinkedList<Link>();
        if (!isOptionsPage && (htmlLinks = s.getLinks()) != null) {
            for (Map.Entry<String, String> e : htmlLinks.entrySet()) {
                String uri = e.getValue();
                if (uri.indexOf("://") == -1 && !StringUtils.startsWith(uri, '/')) {
                    StringBuilder sb = new StringBuilder(properties.getString(REST_relativeServletURI));
                    if (!uri.isEmpty() && uri.charAt(0) != '?' && uri.charAt(0) != '/') {
                        sb.append('/');
                    }
                    sb.append(uri);
                    uri = sb.toString();
                }
                actions.add(new Link(e.getKey(), uri, new Object[0]));
            }
        }
        if (actions.size() > 0) {
            w.oTag(1, "p").attr("class", "links").append('>').nl();
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                Link h = (Link)i.next();
                w.oTag(2, "a").attr("class", "link").attr("href", (Object)h.getHref(), true).append('>').append(h.getName()).eTag("a").nl();
                if (!i.hasNext()) continue;
                w.append(3, " - ").nl();
            }
            w.eTag(1, "p").nl();
        }
        s.indent = 3;
        w.oTag(1, "div").attr("class", "outerdata").append('>').nl();
        w.oTag(2, "div").attr("class", "data").attr("id", "data").append('>').nl();
        if (this.isEmptyList(o)) {
            w.oTag(3, "p").append('>').append("no results").eTag("p");
        } else {
            super.doSerialize(s, o);
        }
        w.eTag(2, "div").nl();
        w.eTag(1, "div").nl();
        w.eTag("body").nl().eTag("html").nl();
    }

    private boolean isEmptyList(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Collection && ((Collection)o).size() == 0) {
            return true;
        }
        return o.getClass().isArray() && Array.getLength(o) == 0;
    }

    @Override
    public HtmlDocSerializer setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        return this;
    }

    @Override
    public HtmlDocSerializer setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        return this;
    }

    @Override
    public HtmlDocSerializer addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses((Class[])classes);
        return this;
    }

    @Override
    public HtmlDocSerializer addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters((Class[])classes);
        return this;
    }

    @Override
    public HtmlDocSerializer addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps((Class[])classes);
        return this;
    }

    @Override
    public HtmlDocSerializer addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary((Class[])classes);
        return this;
    }

    @Override
    public <T> HtmlDocSerializer addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public HtmlDocSerializer setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public HtmlDocSerializer lock() {
        super.lock();
        return this;
    }

    @Override
    public HtmlDocSerializer clone() {
        HtmlDocSerializer c = (HtmlDocSerializer)super.clone();
        return c;
    }
}

