/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.MediaRange;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.internal.ArrayUtils;

public final class EncoderGroup {
    private Map<String, EncoderEntry> entryMap = new TreeMap<String, EncoderEntry>(String.CASE_INSENSITIVE_ORDER);
    private LinkedList<EncoderEntry> tempEntries = new LinkedList();
    private EncoderEntry[] entries;

    public String findMatch(String acceptEncoding) {
        if (this.getEntries().length == 0) {
            return null;
        }
        MediaRange[] ae = MediaRange.parse(acceptEncoding);
        if (ae.length == 0) {
            ae = MediaRange.parse("*");
        }
        for (MediaRange a : ae) {
            for (EncoderEntry e : this.getEntries()) {
                for (MediaRange a2 : e.encodingRanges) {
                    if (!a.matches(a2)) continue;
                    return a2.getType();
                }
            }
        }
        return null;
    }

    public EncoderGroup append(Class<? extends Encoder> ... e) throws Exception {
        for (Class<? extends Encoder> r : ArrayUtils.reverse(e)) {
            this.append(r.newInstance());
        }
        return this;
    }

    public EncoderGroup append(Class<? extends Encoder> e) throws Exception {
        this.append(e.newInstance());
        return this;
    }

    public EncoderGroup append(Encoder ... e) {
        this.entries = null;
        for (Encoder r : ArrayUtils.reverse(e)) {
            EncoderEntry ee = new EncoderEntry(r);
            this.tempEntries.addFirst(ee);
            for (String s : ee.encodings) {
                this.entryMap.put(s, ee);
            }
        }
        return this;
    }

    public EncoderGroup append(EncoderGroup g) {
        for (EncoderEntry e : ArrayUtils.reverse(g.getEntries())) {
            this.append(e.encoder);
        }
        return this;
    }

    public Encoder getEncoder(String coding) {
        EncoderEntry e = this.entryMap.get(coding);
        return e == null ? null : e.encoder;
    }

    public List<String> getSupportedEncodings() {
        ArrayList<String> l = new ArrayList<String>();
        for (EncoderEntry e : this.getEntries()) {
            for (String enc : e.encodings) {
                if (l.contains(enc)) continue;
                l.add(enc);
            }
        }
        return l;
    }

    private EncoderEntry[] getEntries() {
        if (this.entries == null) {
            this.entries = this.tempEntries.toArray(new EncoderEntry[this.tempEntries.size()]);
        }
        return this.entries;
    }

    static class EncoderEntry {
        Encoder encoder;
        MediaRange[] encodingRanges;
        String[] encodings;

        EncoderEntry(Encoder e) {
            this.encoder = e;
            this.encodings = new String[e.getCodings().length];
            int i = 0;
            for (String enc : e.getCodings()) {
                this.encodings[i++] = enc;
            }
            LinkedList<MediaRange> l = new LinkedList<MediaRange>();
            for (i = 0; i < this.encodings.length; ++i) {
                l.addAll(Arrays.asList(MediaRange.parse(this.encodings[i])));
            }
            this.encodingRanges = l.toArray(new MediaRange[l.size()]);
        }
    }
}

