/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.Tag;

@Bean(properties="swagger,info,tags,externalDocs,basePath,schemes,consumes,produces,paths,definitions,parameters,responses,securityDefinitions,security")
public class Swagger {
    public static final Swagger NULL = new Swagger();
    private String swagger = "2.0";
    private Info info;
    private String host;
    private String basePath;
    private List<String> schemes;
    private List<String> consumes;
    private List<String> produces;
    private Map<String, Map<String, Operation>> paths;
    private Map<String, SchemaInfo> definitions;
    private Map<String, ParameterInfo> parameters;
    private Map<String, ResponseInfo> responses;
    private Map<String, SecurityScheme> securityDefinitions;
    private List<Map<String, List<String>>> security;
    private List<Tag> tags;
    private ExternalDocumentation externalDocs;

    public static Swagger create(Info info) {
        return new Swagger().setInfo(info);
    }

    public String getSwagger() {
        return this.swagger;
    }

    public Swagger setSwagger(String swagger) {
        this.swagger = swagger;
        return this;
    }

    public Info getInfo() {
        return this.info;
    }

    public Swagger setInfo(Info info) {
        this.info = info;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public Swagger setHost(String host) {
        this.host = host;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Swagger setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Swagger setSchemes(List<String> schemes) {
        this.schemes = schemes;
        return this;
    }

    public Swagger addSchemes(String ... schemes) {
        return this.addSchemes(Arrays.asList(schemes));
    }

    public Swagger addSchemes(Collection<String> schemes) {
        if (this.schemes == null) {
            this.schemes = new LinkedList<String>();
        }
        this.schemes.addAll(schemes);
        return this;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public Swagger setConsumes(List<String> consumes) {
        this.consumes = consumes;
        return this;
    }

    public Swagger addConsumes(String ... consumes) {
        return this.addConsumes(Arrays.asList(consumes));
    }

    public Swagger addConsumes(Collection<String> consumes) {
        if (this.consumes == null) {
            this.consumes = new LinkedList<String>();
        }
        this.consumes.addAll(consumes);
        return this;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public Swagger setProduces(List<String> produces) {
        this.produces = produces;
        return this;
    }

    public Swagger addProduces(String ... produces) {
        return this.addProduces(Arrays.asList(produces));
    }

    public Swagger addProduces(Collection<String> produces) {
        if (this.produces == null) {
            this.produces = new LinkedList<String>();
        }
        this.produces.addAll(produces);
        return this;
    }

    public Map<String, Map<String, Operation>> getPaths() {
        return this.paths;
    }

    public Swagger setPaths(Map<String, Map<String, Operation>> paths) {
        this.paths = paths;
        return this;
    }

    public Swagger addPath(String path, String methodName, Operation operation) {
        Map<String, Operation> p;
        if (this.paths == null) {
            this.paths = new TreeMap<String, Map<String, Operation>>();
        }
        if ((p = this.paths.get(path)) == null) {
            p = new TreeMap<String, Operation>(new MethodSorter());
            this.paths.put(path, p);
        }
        p.put(methodName, operation);
        return this;
    }

    public Map<String, SchemaInfo> getDefinitions() {
        return this.definitions;
    }

    public Swagger setDefinitions(Map<String, SchemaInfo> definitions) {
        this.definitions = definitions;
        return this;
    }

    public Swagger addDefinition(String name, SchemaInfo schema) {
        if (this.definitions == null) {
            this.definitions = new TreeMap<String, SchemaInfo>();
        }
        this.definitions.put(name, schema);
        return this;
    }

    public Map<String, ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Swagger setParameters(Map<String, ParameterInfo> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Swagger addParameter(String name, ParameterInfo parameter) {
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, ParameterInfo>();
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Swagger setResponses(Map<String, ResponseInfo> responses) {
        this.responses = responses;
        return this;
    }

    public Swagger addResponse(String name, ResponseInfo response) {
        if (this.responses == null) {
            this.responses = new TreeMap<String, ResponseInfo>();
        }
        this.responses.put(name, response);
        return this;
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public Swagger setSecurityDefinitions(Map<String, SecurityScheme> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
        return this;
    }

    public Swagger addSecurityDefinition(String name, SecurityScheme securityScheme) {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new TreeMap<String, SecurityScheme>();
        }
        this.securityDefinitions.put(name, securityScheme);
        return this;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Swagger setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
        return this;
    }

    public Swagger addSecurity(Map<String, List<String>> security) {
        if (this.security == null) {
            this.security = new LinkedList<Map<String, List<String>>>();
        }
        this.security.add(security);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Swagger setTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public Swagger addTags(Tag ... tags) {
        if (this.tags == null) {
            this.tags = new LinkedList<Tag>();
        }
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Swagger setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    private static class MethodSorter
    implements Comparator<String> {
        private final Map<String, Integer> methods = new HashMap<String, Integer>(){
            {
                this.put("get", 7);
                this.put("put", 6);
                this.put("post", 5);
                this.put("delete", 4);
                this.put("options", 3);
                this.put("head", 2);
                this.put("patch", 1);
            }
        };

        private MethodSorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            Integer i1 = this.methods.get(o1);
            Integer i2 = this.methods.get(o2);
            if (i1 == null) {
                i1 = 0;
            }
            if (i2 == null) {
                i2 = 0;
            }
            return i2.compareTo(i1);
        }
    }
}

