/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;

@Bean(properties="description,schema,headers,examples")
public class ResponseInfo {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers;
    private Map<String, Object> examples;

    public static ResponseInfo create(String description) {
        return new ResponseInfo().setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public ResponseInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ResponseInfo setSchema(SchemaInfo schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> headers) {
        this.headers = headers;
        return this;
    }

    public ResponseInfo addHeader(String name, HeaderInfo header) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, HeaderInfo>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public ResponseInfo setExamples(Map<String, Object> examples) {
        this.examples = examples;
        return this;
    }

    public ResponseInfo addExample(String mimeType, Object example) {
        if (this.examples == null) {
            this.examples = new TreeMap<String, Object>();
        }
        this.examples.put(mimeType, example);
        return this;
    }
}

