/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.JsonSerializer;

@Bean(properties="in,name,type,description,required,schema,format,allowEmptyValue,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf")
public class ParameterInfo {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "formData", "body"};
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "file"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String name;
    private String in;
    private String description;
    private Boolean required;
    private SchemaInfo schema;
    private String type;
    private String format;
    private Boolean allowEmptyValue;
    private Items items;
    private String collectionFormat;
    private Object _default;
    private Number maximum;
    private Boolean exclusiveMaximum;
    private Number minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private List<Object> _enum;
    private Number multipleOf;
    private boolean strict;

    public static ParameterInfo create(String in, String name) {
        return new ParameterInfo().setIn(in).setName(name);
    }

    public static ParameterInfo createStrict(String in, String name) {
        return new ParameterInfo().setStrict().setIn(in).setName(name);
    }

    private ParameterInfo setStrict() {
        this.strict = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ParameterInfo setName(String name) {
        if (!"body".equals(this.in)) {
            this.name = name;
        }
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public ParameterInfo setIn(String in) {
        if (this.strict && !ArrayUtils.contains(in, VALID_IN)) {
            throw new RuntimeException("Invalid value passed in to setIn(String).  Value='" + in + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_IN));
        }
        this.in = in;
        if ("path".equals(in)) {
            this.required = true;
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ParameterInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ParameterInfo setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ParameterInfo setSchema(SchemaInfo schema) {
        this.schema = schema;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ParameterInfo setType(String type) {
        if (this.strict && !ArrayUtils.contains(type, VALID_TYPES)) {
            throw new RuntimeException("Invalid value passed in to setType(String).  Value='" + type + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_TYPES));
        }
        this.type = type;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public ParameterInfo setFormat(String format) {
        this.format = format;
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public ParameterInfo setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public ParameterInfo setItems(Items items) {
        this.items = items;
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public ParameterInfo setCollectionFormat(String collectionFormat) {
        if (this.strict && !ArrayUtils.contains(collectionFormat, VALID_COLLECTION_FORMATS)) {
            throw new RuntimeException("Invalid value passed in to setCollectionFormat(String).  Value='" + collectionFormat + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = collectionFormat;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public ParameterInfo setDefault(Object _default) {
        this._default = _default;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public ParameterInfo setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public ParameterInfo setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public ParameterInfo setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ParameterInfo setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public ParameterInfo setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public ParameterInfo setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ParameterInfo setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ParameterInfo setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public ParameterInfo setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public ParameterInfo setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public ParameterInfo setEnum(List<Object> _enum) {
        this._enum = _enum;
        return this;
    }

    public ParameterInfo addEnum(Object ... _enum) {
        return this.addEnum(Arrays.asList(_enum));
    }

    public ParameterInfo addEnum(Collection<Object> _enum) {
        if (this._enum == null) {
            this._enum = new LinkedList<Object>();
        }
        this._enum.addAll(_enum);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public ParameterInfo setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }
}

