/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;

@Bean(properties="operationId,summary,description,tags,externalDocs,consumes,produces,parameters,responses,schemes,deprecated,security")
public class Operation {
    private List<String> tags;
    private String summary;
    private String description;
    private ExternalDocumentation externalDocs;
    private String operationId;
    private List<String> consumes;
    private List<String> produces;
    private List<ParameterInfo> parameters;
    private Map<String, ResponseInfo> responses;
    private List<String> schemes;
    private Boolean deprecated;
    private List<Map<String, List<String>>> security;

    public static Operation create() {
        return new Operation();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Operation setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Operation addTags(String ... tags) {
        return this.addTags(Arrays.asList(tags));
    }

    public Operation addTags(Collection<String> tags) {
        if (this.tags == null) {
            this.tags = new LinkedList<String>();
        }
        this.tags.addAll(tags);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public Operation setConsumes(List<String> consumes) {
        this.consumes = consumes;
        return this;
    }

    public Operation addConsumes(String ... consumes) {
        return this.addConsumes(Arrays.asList(consumes));
    }

    public Operation addConsumes(Collection<String> consumes) {
        if (this.consumes == null) {
            this.consumes = new LinkedList<String>();
        }
        this.consumes.addAll(consumes);
        return this;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public Operation setProduces(List<String> produces) {
        this.produces = produces;
        return this;
    }

    public Operation addProduces(String ... produces) {
        if (this.produces == null) {
            this.produces = new LinkedList<String>();
        }
        this.produces.addAll(Arrays.asList(produces));
        return this;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Operation setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Operation addParameter(ParameterInfo parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<ParameterInfo>();
        }
        this.parameters.add(parameter);
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Operation setResponses(Map<String, ResponseInfo> responses) {
        this.responses = responses;
        return this;
    }

    public Operation addResponse(String statusCode, ResponseInfo response) {
        if (this.responses == null) {
            this.responses = new TreeMap<String, ResponseInfo>();
        }
        this.responses.put(statusCode, response);
        return this;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Operation setSchemes(List<String> schemes) {
        this.schemes = schemes;
        return this;
    }

    public Operation addSchemes(String ... schemes) {
        return this.addSchemes(Arrays.asList(schemes));
    }

    public Operation addSchemes(Collection<String> schemes) {
        if (this.schemes == null) {
            this.schemes = new LinkedList<String>();
        }
        this.schemes.addAll(schemes);
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Operation setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
        return this;
    }

    public Operation addSecurity(Map<String, List<String>> security) {
        if (this.security == null) {
            this.security = new LinkedList<Map<String, List<String>>>();
        }
        this.security.add(security);
        return this;
    }
}

