/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.JsonSerializer;

@Bean(properties="type,format,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf")
public class Items {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String type;
    private String format;
    private Items items;
    private String collectionFormat;
    private Object _default;
    private Number maximum;
    private Boolean exclusiveMaximum;
    private Number minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private List<Object> _enum;
    private Number multipleOf;
    private boolean strict;

    public static Items create(String type) {
        return new Items().setType(type);
    }

    public static Items createStrict(String type) {
        return new Items().setStrict().setType(type);
    }

    private Items setStrict() {
        this.strict = true;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Items setType(String type) {
        if (this.strict && !ArrayUtils.contains(type, VALID_TYPES)) {
            throw new RuntimeException("Invalid value passed in to setType(String).  Value='" + type + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_TYPES));
        }
        this.type = type;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public Items setFormat(String format) {
        this.format = format;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public Items setItems(Items items) {
        this.items = items;
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Items setCollectionFormat(String collectionFormat) {
        if (this.strict && !ArrayUtils.contains(collectionFormat, VALID_COLLECTION_FORMATS)) {
            throw new RuntimeException("Invalid value passed in to setCollectionFormat(String).  Value='" + collectionFormat + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = collectionFormat;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public Items setDefault(Object _default) {
        this._default = _default;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Items setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Items setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Items setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Items setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Items setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Items setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Items setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Items setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Items setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Items setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public Items setEnum(List<Object> _enum) {
        this._enum = _enum;
        return this;
    }

    public Items addEnum(Object ... _enum) {
        return this.addEnum(Arrays.asList(_enum));
    }

    public Items addEnum(Collection<Object> _enum) {
        if (this._enum == null) {
            this._enum = new LinkedList<Object>();
        }
        this._enum.addAll(_enum);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Items setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }
}

